<?php
declare(strict_types=1);

/**
 * BulkEnvelopesApi.
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Docusign eSignature REST API
 *
 * The Docusign eSignature REST API provides you with a powerful, convenient, and simple Web services API for interacting with Docusign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\BulkEnvelopesApi;


/**
 * GetBulkSendBatchEnvelopesOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetBulkSendBatchEnvelopesOptions
{
    /**
      * $count 
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count 
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $include 
      * @var ?string
      */
    protected ?string $include = null;

    /**
     * Gets include
     *
     * @return ?string
     */
    public function getInclude(): ?string
    {
        return $this->include;
    }

    /**
     * Sets include
     * @param ?string $include 
     *
     * @return self
     */
    public function setInclude(?string $include): self
    {
        $this->include = $include;
        return $this;
    }
    /**
      * $order 
      * @var ?string
      */
    protected ?string $order = null;

    /**
     * Gets order
     *
     * @return ?string
     */
    public function getOrder(): ?string
    {
        return $this->order;
    }

    /**
     * Sets order
     * @param ?string $order 
     *
     * @return self
     */
    public function setOrder(?string $order): self
    {
        $this->order = $order;
        return $this;
    }
    /**
      * $order_by 
      * @var ?string
      */
    protected ?string $order_by = null;

    /**
     * Gets order_by
     *
     * @return ?string
     */
    public function getOrderBy(): ?string
    {
        return $this->order_by;
    }

    /**
     * Sets order_by
     * @param ?string $order_by 
     *
     * @return self
     */
    public function setOrderBy(?string $order_by): self
    {
        $this->order_by = $order_by;
        return $this;
    }
    /**
      * $search_text 
      * @var ?string
      */
    protected ?string $search_text = null;

    /**
     * Gets search_text
     *
     * @return ?string
     */
    public function getSearchText(): ?string
    {
        return $this->search_text;
    }

    /**
     * Sets search_text
     * @param ?string $search_text 
     *
     * @return self
     */
    public function setSearchText(?string $search_text): self
    {
        $this->search_text = $search_text;
        return $this;
    }
    /**
      * $start_position 
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position 
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $status 
      * @var ?string
      */
    protected ?string $status = null;

    /**
     * Gets status
     *
     * @return ?string
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * Sets status
     * @param ?string $status 
     *
     * @return self
     */
    public function setStatus(?string $status): self
    {
        $this->status = $status;
        return $this;
    }
}


/**
 * GetBulkSendBatchesOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetBulkSendBatchesOptions
{
    /**
      * $batch_ids 
      * @var ?string
      */
    protected ?string $batch_ids = null;

    /**
     * Gets batch_ids
     *
     * @return ?string
     */
    public function getBatchIds(): ?string
    {
        return $this->batch_ids;
    }

    /**
     * Sets batch_ids
     * @param ?string $batch_ids 
     *
     * @return self
     */
    public function setBatchIds(?string $batch_ids): self
    {
        $this->batch_ids = $batch_ids;
        return $this;
    }
    /**
      * $count 
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count 
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $from_date 
      * @var ?string
      */
    protected ?string $from_date = null;

    /**
     * Gets from_date
     *
     * @return ?string
     */
    public function getFromDate(): ?string
    {
        return $this->from_date;
    }

    /**
     * Sets from_date
     * @param ?string $from_date 
     *
     * @return self
     */
    public function setFromDate(?string $from_date): self
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $search_text 
      * @var ?string
      */
    protected ?string $search_text = null;

    /**
     * Gets search_text
     *
     * @return ?string
     */
    public function getSearchText(): ?string
    {
        return $this->search_text;
    }

    /**
     * Sets search_text
     * @param ?string $search_text 
     *
     * @return self
     */
    public function setSearchText(?string $search_text): self
    {
        $this->search_text = $search_text;
        return $this;
    }
    /**
      * $start_position 
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position 
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $status 
      * @var ?string
      */
    protected ?string $status = null;

    /**
     * Gets status
     *
     * @return ?string
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * Sets status
     * @param ?string $status 
     *
     * @return self
     */
    public function setStatus(?string $status): self
    {
        $this->status = $status;
        return $this;
    }
    /**
      * $to_date 
      * @var ?string
      */
    protected ?string $to_date = null;

    /**
     * Gets to_date
     *
     * @return ?string
     */
    public function getToDate(): ?string
    {
        return $this->to_date;
    }

    /**
     * Sets to_date
     * @param ?string $to_date 
     *
     * @return self
     */
    public function setToDate(?string $to_date): self
    {
        $this->to_date = $to_date;
        return $this;
    }
    /**
      * $user_id 
      * @var ?string
      */
    protected ?string $user_id = null;

    /**
     * Gets user_id
     *
     * @return ?string
     */
    public function getUserId(): ?string
    {
        return $this->user_id;
    }

    /**
     * Sets user_id
     * @param ?string $user_id 
     *
     * @return self
     */
    public function setUserId(?string $user_id): self
    {
        $this->user_id = $user_id;
        return $this;
    }
}



namespace DocuSign\eSign\Api;

use DocuSign\eSign\Client\ApiClient;
use DocuSign\eSign\Client\ApiException;
use DocuSign\eSign\Configuration;
use DocuSign\eSign\ObjectSerializer;

/**
 * BulkEnvelopesApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class BulkEnvelopesApi
{
    /**
     * API Client
     *
     * @var ApiClient instance of the ApiClient
     */
    protected ApiClient $apiClient;

    /**
     * Constructor
     *
     * @param ApiClient|null $apiClient The api client to use
     *
     * @return void
     */
    public function __construct(ApiClient $apiClient = null)
    {
        $this->apiClient = $apiClient ?? new ApiClient();
    }

    /**
     * Get API client
     *
     * @return ApiClient get the API client
     */
    public function getApiClient(): ApiClient
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param ApiClient $apiClient set the API client
     *
     * @return self
     */
    public function setApiClient(ApiClient $apiClient): self
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
    * Update $resourcePath with $
    *
    * @param string $resourcePath the resource path to use
    * @param string $baseName the base name param
    * @param string $paramName the parameter name
    *
    * @return string
    */
    public function updateResourcePath(string $resourcePath, string $baseName, string $paramName): string
    {
        return str_replace(
            "{" . $baseName . "}",
            $this->apiClient->getSerializer()->toPathValue($paramName),
            $resourcePath
        );
    }


    /**
     * Operation createBulkSendList
     *
     * Creates a new bulk send list
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\BulkSendingList $bulk_sending_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkSendingList
     */
    public function createBulkSendList($account_id, $bulk_sending_list = null)
    {
        list($response) = $this->createBulkSendListWithHttpInfo($account_id, $bulk_sending_list);
        return $response;
    }

    /**
     * Operation createBulkSendListWithHttpInfo
     *
     * Creates a new bulk send list
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\BulkSendingList $bulk_sending_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkSendingList, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBulkSendListWithHttpInfo($account_id, $bulk_sending_list = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createBulkSendList');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_send_lists";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($bulk_sending_list)) {
            $_tempBody = $bulk_sending_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkSendingList',
                '/v2.1/accounts/{accountId}/bulk_send_lists'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkSendingList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkSendingList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createBulkSendRequest
     *
     * Uses the specified bulk send list to send the envelope specified in the payload
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_list_id 
     * @param \DocuSign\eSign\Model\BulkSendRequest $bulk_send_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkSendResponse
     */
    public function createBulkSendRequest($account_id, $bulk_send_list_id, $bulk_send_request = null)
    {
        list($response) = $this->createBulkSendRequestWithHttpInfo($account_id, $bulk_send_list_id, $bulk_send_request);
        return $response;
    }

    /**
     * Operation createBulkSendRequestWithHttpInfo
     *
     * Uses the specified bulk send list to send the envelope specified in the payload
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_list_id 
     * @param \DocuSign\eSign\Model\BulkSendRequest $bulk_send_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkSendResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBulkSendRequestWithHttpInfo($account_id, $bulk_send_list_id, $bulk_send_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createBulkSendRequest');
        }
        // verify the required parameter 'bulk_send_list_id' is set
        if ($bulk_send_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_send_list_id when calling createBulkSendRequest');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}/send";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($bulk_send_list_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "bulkSendListId", $bulk_send_list_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($bulk_send_request)) {
            $_tempBody = $bulk_send_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkSendResponse',
                '/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}/send'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkSendResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkSendResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createBulkSendTestRequest
     *
     * Tests whether the specified bulk sending list can be used to send an envelope
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_list_id 
     * @param \DocuSign\eSign\Model\BulkSendRequest $bulk_send_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkSendTestResponse
     */
    public function createBulkSendTestRequest($account_id, $bulk_send_list_id, $bulk_send_request = null)
    {
        list($response) = $this->createBulkSendTestRequestWithHttpInfo($account_id, $bulk_send_list_id, $bulk_send_request);
        return $response;
    }

    /**
     * Operation createBulkSendTestRequestWithHttpInfo
     *
     * Tests whether the specified bulk sending list can be used to send an envelope
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_list_id 
     * @param \DocuSign\eSign\Model\BulkSendRequest $bulk_send_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkSendTestResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBulkSendTestRequestWithHttpInfo($account_id, $bulk_send_list_id, $bulk_send_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createBulkSendTestRequest');
        }
        // verify the required parameter 'bulk_send_list_id' is set
        if ($bulk_send_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_send_list_id when calling createBulkSendTestRequest');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}/test";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($bulk_send_list_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "bulkSendListId", $bulk_send_list_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($bulk_send_request)) {
            $_tempBody = $bulk_send_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkSendTestResponse',
                '/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}/test'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkSendTestResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkSendTestResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteBulkSendList
     *
     * Deletes an existing bulk send list
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_list_id 
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkSendingListSummaries
     */
    public function deleteBulkSendList($account_id, $bulk_send_list_id)
    {
        list($response) = $this->deleteBulkSendListWithHttpInfo($account_id, $bulk_send_list_id);
        return $response;
    }

    /**
     * Operation deleteBulkSendListWithHttpInfo
     *
     * Deletes an existing bulk send list
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_list_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkSendingListSummaries, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBulkSendListWithHttpInfo($account_id, $bulk_send_list_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteBulkSendList');
        }
        // verify the required parameter 'bulk_send_list_id' is set
        if ($bulk_send_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_send_list_id when calling deleteBulkSendList');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($bulk_send_list_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "bulkSendListId", $bulk_send_list_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkSendingListSummaries',
                '/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkSendingListSummaries', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkSendingListSummaries', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBulkSendBatchEnvelopes
     *
     * Gets envelopes from a specific bulk send batch
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_batch_id 
     * @param  \DocuSign\eSign\Api\BulkEnvelopesApi\GetBulkSendBatchEnvelopesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopesInformation
     */
    public function getBulkSendBatchEnvelopes($account_id, $bulk_send_batch_id, \DocuSign\eSign\Api\BulkEnvelopesApi\GetBulkSendBatchEnvelopesOptions $options = null)
    {
        list($response) = $this->getBulkSendBatchEnvelopesWithHttpInfo($account_id, $bulk_send_batch_id, $options);
        return $response;
    }

    /**
     * Operation getBulkSendBatchEnvelopesWithHttpInfo
     *
     * Gets envelopes from a specific bulk send batch
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_batch_id 
     * @param  \DocuSign\eSign\Api\BulkEnvelopesApi\GetBulkSendBatchEnvelopesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopesInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBulkSendBatchEnvelopesWithHttpInfo($account_id, $bulk_send_batch_id, \DocuSign\eSign\Api\BulkEnvelopesApi\GetBulkSendBatchEnvelopesOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBulkSendBatchEnvelopes');
        }
        // verify the required parameter 'bulk_send_batch_id' is set
        if ($bulk_send_batch_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_send_batch_id when calling getBulkSendBatchEnvelopes');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}/envelopes";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getInclude() != 'null') {
                $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
            }
            if ($options->getOrder() != 'null') {
                $queryParams['order'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrder());
            }
            if ($options->getOrderBy() != 'null') {
                $queryParams['order_by'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrderBy());
            }
            if ($options->getSearchText() != 'null') {
                $queryParams['search_text'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchText());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
            if ($options->getStatus() != 'null') {
                $queryParams['status'] = $this->apiClient->getSerializer()->toQueryValue($options->getStatus());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($bulk_send_batch_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "bulkSendBatchId", $bulk_send_batch_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopesInformation',
                '/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}/envelopes'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopesInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopesInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBulkSendBatchStatus
     *
     * Gets a specific bulk send batch status
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_batch_id 
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkSendBatchStatus
     */
    public function getBulkSendBatchStatus($account_id, $bulk_send_batch_id)
    {
        list($response) = $this->getBulkSendBatchStatusWithHttpInfo($account_id, $bulk_send_batch_id);
        return $response;
    }

    /**
     * Operation getBulkSendBatchStatusWithHttpInfo
     *
     * Gets a specific bulk send batch status
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_batch_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkSendBatchStatus, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBulkSendBatchStatusWithHttpInfo($account_id, $bulk_send_batch_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBulkSendBatchStatus');
        }
        // verify the required parameter 'bulk_send_batch_id' is set
        if ($bulk_send_batch_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_send_batch_id when calling getBulkSendBatchStatus');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($bulk_send_batch_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "bulkSendBatchId", $bulk_send_batch_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkSendBatchStatus',
                '/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkSendBatchStatus', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkSendBatchStatus', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBulkSendBatches
     *
     * Returns a list of bulk send batch satuses initiated by account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\BulkEnvelopesApi\GetBulkSendBatchesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkSendBatchSummaries
     */
    public function getBulkSendBatches($account_id, \DocuSign\eSign\Api\BulkEnvelopesApi\GetBulkSendBatchesOptions $options = null)
    {
        list($response) = $this->getBulkSendBatchesWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation getBulkSendBatchesWithHttpInfo
     *
     * Returns a list of bulk send batch satuses initiated by account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\BulkEnvelopesApi\GetBulkSendBatchesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkSendBatchSummaries, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBulkSendBatchesWithHttpInfo($account_id, \DocuSign\eSign\Api\BulkEnvelopesApi\GetBulkSendBatchesOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBulkSendBatches');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_send_batch";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getBatchIds() != 'null') {
                $queryParams['batch_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getBatchIds());
            }
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getFromDate() != 'null') {
                $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
            }
            if ($options->getSearchText() != 'null') {
                $queryParams['search_text'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchText());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
            if ($options->getStatus() != 'null') {
                $queryParams['status'] = $this->apiClient->getSerializer()->toQueryValue($options->getStatus());
            }
            if ($options->getToDate() != 'null') {
                $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
            }
            if ($options->getUserId() != 'null') {
                $queryParams['user_id'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserId());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkSendBatchSummaries',
                '/v2.1/accounts/{accountId}/bulk_send_batch'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkSendBatchSummaries', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkSendBatchSummaries', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBulkSendList
     *
     * Gets a specific bulk send list
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_list_id 
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkSendingList
     */
    public function getBulkSendList($account_id, $bulk_send_list_id)
    {
        list($response) = $this->getBulkSendListWithHttpInfo($account_id, $bulk_send_list_id);
        return $response;
    }

    /**
     * Operation getBulkSendListWithHttpInfo
     *
     * Gets a specific bulk send list
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_list_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkSendingList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBulkSendListWithHttpInfo($account_id, $bulk_send_list_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBulkSendList');
        }
        // verify the required parameter 'bulk_send_list_id' is set
        if ($bulk_send_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_send_list_id when calling getBulkSendList');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($bulk_send_list_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "bulkSendListId", $bulk_send_list_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkSendingList',
                '/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkSendingList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkSendingList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBulkSendLists
     *
     * Lists top-level details for all bulk send lists visible to the current user
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkSendingListSummaries
     */
    public function getBulkSendLists($account_id)
    {
        list($response) = $this->getBulkSendListsWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getBulkSendListsWithHttpInfo
     *
     * Lists top-level details for all bulk send lists visible to the current user
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkSendingListSummaries, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBulkSendListsWithHttpInfo($account_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBulkSendLists');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_send_lists";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkSendingListSummaries',
                '/v2.1/accounts/{accountId}/bulk_send_lists'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkSendingListSummaries', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkSendingListSummaries', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateBulkSendBatchAction
     *
     * Initiate a specific bulk send batch action
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_action 
     * @param ?string $bulk_send_batch_id 
     * @param \DocuSign\eSign\Model\BulkSendBatchActionRequest $bulk_send_batch_action_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkSendBatchStatus
     */
    public function updateBulkSendBatchAction($account_id, $bulk_action, $bulk_send_batch_id, $bulk_send_batch_action_request = null)
    {
        list($response) = $this->updateBulkSendBatchActionWithHttpInfo($account_id, $bulk_action, $bulk_send_batch_id, $bulk_send_batch_action_request);
        return $response;
    }

    /**
     * Operation updateBulkSendBatchActionWithHttpInfo
     *
     * Initiate a specific bulk send batch action
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_action 
     * @param ?string $bulk_send_batch_id 
     * @param \DocuSign\eSign\Model\BulkSendBatchActionRequest $bulk_send_batch_action_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkSendBatchStatus, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBulkSendBatchActionWithHttpInfo($account_id, $bulk_action, $bulk_send_batch_id, $bulk_send_batch_action_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateBulkSendBatchAction');
        }
        // verify the required parameter 'bulk_action' is set
        if ($bulk_action === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_action when calling updateBulkSendBatchAction');
        }
        // verify the required parameter 'bulk_send_batch_id' is set
        if ($bulk_send_batch_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_send_batch_id when calling updateBulkSendBatchAction');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}/{bulkAction}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($bulk_action !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "bulkAction", $bulk_action);
        }
        // path params
        if ($bulk_send_batch_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "bulkSendBatchId", $bulk_send_batch_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($bulk_send_batch_action_request)) {
            $_tempBody = $bulk_send_batch_action_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkSendBatchStatus',
                '/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}/{bulkAction}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkSendBatchStatus', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkSendBatchStatus', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateBulkSendBatchStatus
     *
     * Put/Update a specific bulk send batch status
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_batch_id 
     * @param \DocuSign\eSign\Model\BulkSendBatchRequest $bulk_send_batch_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkSendBatchStatus
     */
    public function updateBulkSendBatchStatus($account_id, $bulk_send_batch_id, $bulk_send_batch_request = null)
    {
        list($response) = $this->updateBulkSendBatchStatusWithHttpInfo($account_id, $bulk_send_batch_id, $bulk_send_batch_request);
        return $response;
    }

    /**
     * Operation updateBulkSendBatchStatusWithHttpInfo
     *
     * Put/Update a specific bulk send batch status
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_batch_id 
     * @param \DocuSign\eSign\Model\BulkSendBatchRequest $bulk_send_batch_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkSendBatchStatus, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBulkSendBatchStatusWithHttpInfo($account_id, $bulk_send_batch_id, $bulk_send_batch_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateBulkSendBatchStatus');
        }
        // verify the required parameter 'bulk_send_batch_id' is set
        if ($bulk_send_batch_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_send_batch_id when calling updateBulkSendBatchStatus');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($bulk_send_batch_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "bulkSendBatchId", $bulk_send_batch_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($bulk_send_batch_request)) {
            $_tempBody = $bulk_send_batch_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkSendBatchStatus',
                '/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkSendBatchStatus', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkSendBatchStatus', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateBulkSendList
     *
     * Updates an existing bulk send list.  If send_envelope query string value is provided, will accept an empty payload and try to send the specified envelope
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_list_id 
     * @param \DocuSign\eSign\Model\BulkSendingList $bulk_sending_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkSendingList
     */
    public function updateBulkSendList($account_id, $bulk_send_list_id, $bulk_sending_list = null)
    {
        list($response) = $this->updateBulkSendListWithHttpInfo($account_id, $bulk_send_list_id, $bulk_sending_list);
        return $response;
    }

    /**
     * Operation updateBulkSendListWithHttpInfo
     *
     * Updates an existing bulk send list.  If send_envelope query string value is provided, will accept an empty payload and try to send the specified envelope
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $bulk_send_list_id 
     * @param \DocuSign\eSign\Model\BulkSendingList $bulk_sending_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkSendingList, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBulkSendListWithHttpInfo($account_id, $bulk_send_list_id, $bulk_sending_list = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateBulkSendList');
        }
        // verify the required parameter 'bulk_send_list_id' is set
        if ($bulk_send_list_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $bulk_send_list_id when calling updateBulkSendList');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($bulk_send_list_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "bulkSendListId", $bulk_send_list_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($bulk_sending_list)) {
            $_tempBody = $bulk_sending_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkSendingList',
                '/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkSendingList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkSendingList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
