<?php include('header.php')?>
<style>
    /* Filters */
    .filters {
        display: flex;
        justify-content: flex-start;
        gap: 1rem;
        margin-bottom: 1rem;
    }
.fc-toolbar-title{
    font-size:30px !important;
}
    .filter {
        color: #0052cc;
        cursor: pointer;
    }

    .filter.active {
        font-weight: bold;
        color: #172b4d;
        background-color: #ebecf0;
        padding: 0.3rem 1rem;
        border-radius: 5px;
    }

    /* Board and Columns */
    .board {
        display: flex;
        gap: 1rem;
    }

    .column {
        flex: 1;
        background-color: #fff;
        border-radius: 10px;
        padding: 1rem;
        box-shadow: 0px 2px 5px rgba(0, 0, 0, 0.1);
    }

    .column-title {
        font-weight: bold;
        margin-bottom: 1rem;
        color: #42526e;
    }

    /* Task Card */
    .task-card {
        background-color: #e8f0fc;
        padding: 1rem;
        margin-bottom: 1rem;
        border-radius: 10px;
        box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
    }

    .task-title {
        font-size: 14px;
        font-weight: bold;
        color: #172b4d;
    }

    .task-meta {
        display: flex;
        justify-content: space-between;
        margin-top: 0.5rem;
        color: #42526e;
    }

    .badge-status {
        background-color: #90ee90;
        padding: 0.2rem 0.5rem;
        border-radius: 5px;
        font-size: 12px;
    }

    .task-footer {
        display: flex;
        justify-content: space-between;
        margin-top: 0.5rem;
    }

    .task-footer img {
        border-radius: 50%;
        width: 25px;
        height: 25px;
    }

    .comments {
        display: flex;
        align-items: center;
        color: #5e6c84;
    }

    .comments svg {
        margin-right: 5px;
    }
    
</style>
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.10.1/main.min.css" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="https://demo.thebrandchimp.com/texashrm/assets/hrm/assets/css/components/_datatable.scss">

  
  <div class="dashboard-main-body">
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
  <h6 class="fw-semibold mb-0">Dashboard</h6>
  <ul class="d-flex align-items-center gap-2">
    <li class="fw-medium">
      <a href="index.html" class="d-flex align-items-center gap-1 hover-text-primary">
        <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
        Dashboard
      </a>
    </li>
    <li>-</li>
    <li class="fw-medium">AI</li>
  </ul>
</div>
<?php
$session = \Config\Services::session();
$db = \Config\Database::connect();
?>
          
<div class="py-1">
    <?php if ($session->get('message')) { ?>
        <div class="alert alert-success bg-success-100 text-success-600 border-success-600 border-start-width-4-px border-top-0 border-end-0 border-bottom-0 px-24 py-13 mb-0 fw-semibold text-lg radius-4 d-flex align-items-center justify-content-between" role="alert">
            <div class="d-flex align-items-center gap-2">
                <iconify-icon icon="akar-icons:double-check" class="icon text-xl"></iconify-icon>
                <?php echo $session->get('message'); ?>
            </div>
            <button class="remove-button text-success-600 text-xxl line-height-1"> <iconify-icon icon="iconamoon:sign-times-light" class="icon"></iconify-icon></button>
        </div>
    <?php } ?>
    <?php if ($session->get('error')) { ?>
        <div class="alert alert-danger bg-danger-100 text-danger-600 border-danger-600 border-start-width-4-px border-top-0 border-end-0 border-bottom-0 px-24 py-13 mb-0 fw-semibold text-lg radius-4 d-flex align-items-center justify-content-between" role="alert">
            <div class="d-flex align-items-center gap-2">
                <iconify-icon icon="mdi:alert-circle-outline" class="icon text-xl"></iconify-icon>
                <?php echo $session->get('message'); ?>
            </div>
            <button class="remove-button text-danger-600 text-xxl line-height-1"> <iconify-icon icon="iconamoon:sign-times-light" class="icon"></iconify-icon></button>
        </div>
    <?php } ?>
</div>  
<?php

// Get logged-in user's ID using the CI4 session helper
$user_id = session()->get('user_id');

// Get employee details from tbl_employees
$employeeBuilder = $db->table('tbl_employees');
$userQuery = $employeeBuilder->getWhere(['id' => $user_id]);
$user = $userQuery->getRowArray();

// Get employee type details from tbl_employee_type using the employee's type
$employeeTypeBuilder = $db->table('tbl_employee_type');
$employeeTypeQuery = $employeeTypeBuilder->getWhere(['id' => $user['employee_type']]);
$designation = $employeeTypeQuery->getRowArray();

// Get today's date
$today = date('Y-m-d');

// Get attendance for today and logged-in user from tbl_attendance
$attendanceBuilder = $db->table('tbl_attendance');
$attendanceBuilder->where('dater', $today);
$attendanceBuilder->where('eid', $user_id);
$attendanceQuery = $attendanceBuilder->get();

// Count the number of rows found
$attcount = $attendanceQuery->getNumRows();

// Fetch the first row (or the only row) for today's attendance as an associative array
$attendanceRow = $attendanceQuery->getRowArray();
?>



    
<style>
    .fc .fc-button-primary:focus, .fc .fc-button-primary:not(:disabled).fc-button-active:focus, .fc .fc-button-primary:not(:disabled):active:focus {
    box-shadow: 0 0 0 .2rem rgb(76 91 106 / 0%);
}
 .fc .fc-button-primary:not(:disabled):active:focus {
   background :#222222; 
}
.fc-button{
    height:auto;
}
</style>



    <div class="row mt-3">
        <!-- Attendance List Table -->
         <div class="col-xl-4">
                      <div class="card" style=" height: 96%;">
                    <div class="card-header">
                      <h4 class="card-title mb-0">Attendance </h4>
                    </div>
                    <div class="card-body">
                      <form class="custom-input" method="post" action="<?= base_url('home/attendancemark') ?>"  >
                        <div class="mb-3">
                            <label class="form-label">Start Time</label>
                            <?php if ($attcount > 0) { ?>
                                <input class="form-control" name="startdate" type="text" value="<?php echo $attendanceRow['startdate']; ?>" readonly>
                            <?php } else { ?>
                                <input class="form-control" name="startdate" type="time" required>
                            <?php } ?>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">End Time</label>
                            <?php if ($attcount > 0) { ?>
                                <input class="form-control" name="exittime" type="text" value="<?php echo $attendanceRow['exittime']; ?>" readonly>
                            <?php } else { ?>
                                <input class="form-control" type="time" name="exittime" required>
                            <?php } ?>
                        </div>
                        <div class="form-footer">
                          <button type="submit" class="btn btn-primary btn-block" <?php if ($attcount > 0) { echo 'disabled';} ?> >Mark Attendance</button>
                        </div>
                      </form>
                    </div>
                  </div>
                <div class="row d-none"> 
                  <div class="col-xl-12 col-sm-6 box-col-12 ">
                    <div class="card profile-box">
                  <div class="card-body">
                    <div class="d-flex media-wrapper justify-content-between">
                      <div class="flex-grow-1"> 
                        <div class="greeting-user">
                          <h2 class="f-w-600">Welcome <?=$user['name']?>..</h2>
                          <p>Ready to kickstart your day? Let’s make today count!</p>
                          <div class="whatsnew-btn"><a id="dayToggleBtn" class="btn btn-outline-white" target="_blank">Start Your Day</a></div>
                        </div>
                      </div>
                      <div>  
                        <div class="clockbox">
                          <svg id="clock" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 600 600">
                            <g id="face">
                              <circle class="circle" cx="300" cy="300" r="253.9"></circle>
                              <path class="hour-marks" d="M300.5 94V61M506 300.5h32M300.5 506v33M94 300.5H60M411.3 107.8l7.9-13.8M493 190.2l13-7.4M492.1 411.4l16.5 9.5M411 492.3l8.9 15.3M189 492.3l-9.2 15.9M107.7 411L93 419.5M107.5 189.3l-17.1-9.9M188.1 108.2l-9-15.6"></path>
                              <circle class="mid-circle" cx="300" cy="300" r="16.2"></circle>
                            </g>
                            <g id="hour" style="transform: rotate(349.5deg);">
                              <path class="hour-hand" d="M300.5 298V142"></path>
                              <circle class="sizing-box" cx="300" cy="300" r="253.9"></circle>
                            </g>
                            <g id="minute" style="transform: rotate(236deg);">
                              <path class="minute-hand" d="M300.5 298V67">   </path>
                              <circle class="sizing-box" cx="300" cy="300" r="253.9"></circle>
                            </g>
                            <g id="second" style="transform: rotate(480deg);">
                              <path class="second-hand" d="M300.5 350V55"></path>
                              <circle class="sizing-box" cx="300" cy="300" r="253.9">   </circle>
                            </g>
                          </svg>
                        </div>
                        <div class="badge f-10 p-0" id="timerDisplay">00.00.00</div>
                      </div>
                    </div>
                    <div class="cartoon"><img class="img-fluid" src="<?php echo base_url() ?>assets/hrm/assets/images/dashboard/cartoon.svg" alt="vector women with leptop"></div>
                  </div>
                </div>
                  </div>
                  <div class="col-xl-12 col-sm-6 box-col-12 ">
                    <div class="card widget-1">
                      <div class="card-body">
                        <div class="widget-content">
                          <div class="widget-round secondary">
                            <div class="bg-round">
                              <svg>
                                <use href="<?php echo base_url() ?>assets/hrm/assets/svg/icon-sprite.svg#c-revenue"> </use>
                              </svg>
                              <svg class="half-circle svg-fill">
                                <use href="<?php echo base_url() ?>assets/hrm/assets/svg/icon-sprite.svg#halfcircle"></use>
                              </svg>
                            </div>
                          </div>
                          <div> 
                            <h4>$<span class="counter" data-target="45195">45,195</span></h4><span class="f-light">Revenue</span>
                          </div>
                        </div>
                        <div class="font-success f-w-500"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trending-up bookmark-search me-1"><polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline><polyline points="17 6 23 6 23 12"></polyline></svg><span class="txt-success">+50%</span></div>
                      </div>
                    </div>
                    
                    <div class="card widget-1">
                        <div class="card-body"> 
                          <div class="widget-content">
                            <div class="widget-round primary">
                              <div class="bg-round">
                                <svg class="fill-primary">
                                  <use href="<?php echo base_url() ?>assets/hrm/assets/svg/icon-sprite.svg#c-invoice"> </use>
                                </svg>
                                <svg class="half-circle svg-fill">
                                  <use href="<?php echo base_url() ?>assets/hrm/assets/svg/icon-sprite.svg#halfcircle"></use>
                                </svg>
                              </div>
                            </div>
                            <div> 
                              <h4 class="counter" data-target="10905">10,905</h4><span class="f-light">Invoices</span>
                            </div>
                          </div>
                          <div class="font-success f-w-500"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trending-up bookmark-search me-1"><polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline><polyline points="17 6 23 6 23 12"></polyline></svg><span class="txt-success">+50%</span></div>
                        </div>
                      </div>
                  </div>
                </div>
              
                  </div>
                <div class="col-xl-4">
                  <div class="card">
                    <div class="card-header">
                      <h4 class="card-title mb-0">My Profile</h4>
                    </div>
                    <div class="card-body">
                      <form class="custom-input" method="post" action="<?php echo base_url() ?>home/update_employee_action"  enctype="multipart/form-data">
                        <div class="row mb-2">
                          <div class="profile-title">
                            <div class="d-flex">         
                            <?php 
                            if(isset($user['image'])){
                                ?>
                             <img class="img-70 rounded-circle me-2" style="height:70px;width:70px;object-fit:cover;" alt="" src="<?php echo base_url() ?>uploads/employees/<?=$user['image']?>">
                            <?php }else{ ?>
                                <img class="img-70 rounded-circle me-2" style="height:70px;width:70px;object-fit:cover;" alt="" src="<?php echo base_url() ?>assets/assets/images/7.jpg">
                            <?php } ?>
                              <div class="flex-grow-1">
                                <h5 class="mb-1"><?=$user['name']?></h5>
                                <p><?= isset($designation['employee_type']) ? $designation['employee_type'] : ''; ?></p>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Upload Profile Image</label>
                            <input type="file" class="form-control" accept="image/*" name="image">
                        </div>
                        <div class="mb-3">
                          <label class="form-label">Email Address</label>
                          <input class="form-control" placeholder="" value="<?=$user['email']?>" readonly>
                        </div>
                        <div class="mb-3">
                          <label class="form-label">New Password</label>
                          <input class="form-control" type="password" name="password">
                        </div>
                        <div class="form-footer">
                          <button type="submit" class="btn btn-primary btn-block">Update Profile</button>
                        </div>
                      </form>
                    </div>
                  </div>
                </div>
        <div class="col-lg-4">
            <div class="card h-100">
                <div class="card-header">
                      <h4 class="card-title mb-0">Upcoming Holiday's</h4>
                    </div>
          <div class="card-body">
            

            <div class="mt-2">
 <?php foreach ($holidays as $holiday): ?>
              <div class="event-item d-flex align-items-center justify-content-between gap-4 pb-16 mb-16 border border-start-0 border-end-0 border-top-0">
                <div class="d-flex align-items-center">
                  <div class="flex-grow-1">
                    <h6 class="text-md mb-0 fw-medium"><?php echo htmlspecialchars($holiday['event']); ?></h6>
                    <span class="text-sm text-secondary-light fw-medium d-flex gap-1 align-items-center">
                        <iconify-icon icon="solar:calendar-outline" class="menu-icon"></iconify-icon>
                        <?php echo date('d M Y', strtotime($holiday['date'])); ?></span>
                  </div>
                </div>
              </div>
 <?php endforeach; ?>
            </div>
            
          </div>
        </div>
                     
        </div>
    </div>





 <div class="card mt-3">
        <div class="card-body">
            <div class="row" id="wrap">
                <div class="col-xxl-12 box-col-12">
                    <div class="calendar-default" id="calendar-container">
                        <div id="calendar"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    
<script>
    // Handle Select All Checkbox
    function toggleSelectAll(source) {
        const checkboxes = document.querySelectorAll('.acb');
        checkboxes.forEach(checkbox => checkbox.checked = source.checked);
    }

    // Approve Multiple Records
    document.getElementById('approveAllBtn').addEventListener('click', function () {
        const selectedIds = [];
        const checkboxes = document.querySelectorAll('.acb:checked');
        checkboxes.forEach(checkbox => selectedIds.push(checkbox.value));

        if (selectedIds.length > 0) {
            // Show loading state (optional)
            let approveBtn = document.getElementById('approveAllBtn');
            approveBtn.disabled = true;
            approveBtn.innerText = 'Approving...';

            // Send the selected IDs to approve
            fetch('<?php echo base_url('home/approveLeaves'); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ ids: selectedIds })
            })
            .then(response => response.json())
            .then(data => {
                alert(data.message || 'Leaves approved successfully!');
                location.reload(); // Reload the page to show updated data
            })
            .catch(error => {
                console.error('Error approving leaves:', error);
                alert('There was an error. Please try again later.');
            })
            .finally(() => {
                approveBtn.disabled = false;
                approveBtn.innerText = 'Approve All';
            });
        } else {
            alert('Please select at least one record to approve.');
        }
    });

    // Reject Multiple Records
    document.getElementById('rejectAllBtn').addEventListener('click', function () {
        const selectedIds = [];
        const checkboxes = document.querySelectorAll('.acb:checked');
        checkboxes.forEach(checkbox => selectedIds.push(checkbox.value));

        if (selectedIds.length > 0) {
            // Show loading state (optional)
            let rejectBtn = document.getElementById('rejectAllBtn');
            rejectBtn.disabled = true;
            rejectBtn.innerText = 'Rejecting...';

            // Send the selected IDs to reject
            fetch('<?php echo base_url('home/rejectLeaves'); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ ids: selectedIds })
            })
            .then(response => response.json())
            .then(data => {
                alert(data.message || 'Leaves rejected successfully!');
                location.reload(); // Reload the page to show updated data
            })
            .catch(error => {
                console.error('Error rejecting leaves:', error);
                alert('There was an error. Please try again later.');
            })
            .finally(() => {
                rejectBtn.disabled = false;
                rejectBtn.innerText = 'Reject All';
            });
        } else {
            alert('Please select at least one record to reject.');
        }
    });
    
    
    
    // Approve Individual Record
function approveLeave(id, status) {
    // Send the selected ID and status to the server
    fetch('<?php echo base_url('home/updatesingleLeaveStatus'); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({ ids: [id], status: status })
    })
    .then(response => response.json())
    .then(data => {
        alert(data.message || 'Attendance approved successfully!');
        location.reload(); // Reload the page to show updated data
    })
    .catch(error => {
        console.error('Error approving leave:', error);
        alert('There was an error. Please try again later.');
    });
}

// Reject Individual Record
function cancelLeave(id, status) {
    // Send the selected ID and status to the server
    fetch('<?php echo base_url('home/updatesingleLeaveStatus'); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({ ids: [id], status: status })
    })
    .then(response => response.json())
    .then(data => {
        alert(data.message || 'Leave rejected successfully!');
        location.reload(); // Reload the page to show updated data
    })
    .catch(error => {
        console.error('Error rejecting leave:', error);
        alert('There was an error. Please try again later.');
    });
}

</script>


  </div>
  
  
  



<?php include('footer.php')?>