<?php
/**
 * PaletteSettings
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Docusign eSignature REST API
 *
 * The Docusign eSignature REST API provides you with a powerful, convenient, and simple Web services API for interacting with Docusign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * PaletteSettings Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The Docusign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PaletteSettings implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'paletteSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'annotations' => '\DocuSign\eSign\Model\PaletteItemSettings',
        'custom' => '\DocuSign\eSign\Model\PaletteItemSettings',
        'merge' => '\DocuSign\eSign\Model\PaletteItemSettings',
        'notary' => '\DocuSign\eSign\Model\PaletteItemSettings',
        'seals' => '\DocuSign\eSign\Model\PaletteItemSettings',
        'smart_contracts' => '\DocuSign\eSign\Model\PaletteItemSettings',
        'smart_sections' => '\DocuSign\eSign\Model\PaletteItemSettings'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'annotations' => null,
        'custom' => null,
        'merge' => null,
        'notary' => null,
        'seals' => null,
        'smart_contracts' => null,
        'smart_sections' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'annotations' => 'annotations',
        'custom' => 'custom',
        'merge' => 'merge',
        'notary' => 'notary',
        'seals' => 'seals',
        'smart_contracts' => 'smartContracts',
        'smart_sections' => 'smartSections'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'annotations' => 'setAnnotations',
        'custom' => 'setCustom',
        'merge' => 'setMerge',
        'notary' => 'setNotary',
        'seals' => 'setSeals',
        'smart_contracts' => 'setSmartContracts',
        'smart_sections' => 'setSmartSections'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'annotations' => 'getAnnotations',
        'custom' => 'getCustom',
        'merge' => 'getMerge',
        'notary' => 'getNotary',
        'seals' => 'getSeals',
        'smart_contracts' => 'getSmartContracts',
        'smart_sections' => 'getSmartSections'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['annotations'] = isset($data['annotations']) ? $data['annotations'] : null;
        $this->container['custom'] = isset($data['custom']) ? $data['custom'] : null;
        $this->container['merge'] = isset($data['merge']) ? $data['merge'] : null;
        $this->container['notary'] = isset($data['notary']) ? $data['notary'] : null;
        $this->container['seals'] = isset($data['seals']) ? $data['seals'] : null;
        $this->container['smart_contracts'] = isset($data['smart_contracts']) ? $data['smart_contracts'] : null;
        $this->container['smart_sections'] = isset($data['smart_sections']) ? $data['smart_sections'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets annotations
     *
     * @return \DocuSign\eSign\Model\PaletteItemSettings
     */
    public function getAnnotations()
    {
        return $this->container['annotations'];
    }

    /**
     * Sets annotations
     *
     * @param \DocuSign\eSign\Model\PaletteItemSettings $annotations 
     *
     * @return $this
     */
    public function setAnnotations($annotations)
    {
        $this->container['annotations'] = $annotations;

        return $this;
    }

    /**
     * Gets custom
     *
     * @return \DocuSign\eSign\Model\PaletteItemSettings
     */
    public function getCustom()
    {
        return $this->container['custom'];
    }

    /**
     * Sets custom
     *
     * @param \DocuSign\eSign\Model\PaletteItemSettings $custom 
     *
     * @return $this
     */
    public function setCustom($custom)
    {
        $this->container['custom'] = $custom;

        return $this;
    }

    /**
     * Gets merge
     *
     * @return \DocuSign\eSign\Model\PaletteItemSettings
     */
    public function getMerge()
    {
        return $this->container['merge'];
    }

    /**
     * Sets merge
     *
     * @param \DocuSign\eSign\Model\PaletteItemSettings $merge 
     *
     * @return $this
     */
    public function setMerge($merge)
    {
        $this->container['merge'] = $merge;

        return $this;
    }

    /**
     * Gets notary
     *
     * @return \DocuSign\eSign\Model\PaletteItemSettings
     */
    public function getNotary()
    {
        return $this->container['notary'];
    }

    /**
     * Sets notary
     *
     * @param \DocuSign\eSign\Model\PaletteItemSettings $notary 
     *
     * @return $this
     */
    public function setNotary($notary)
    {
        $this->container['notary'] = $notary;

        return $this;
    }

    /**
     * Gets seals
     *
     * @return \DocuSign\eSign\Model\PaletteItemSettings
     */
    public function getSeals()
    {
        return $this->container['seals'];
    }

    /**
     * Sets seals
     *
     * @param \DocuSign\eSign\Model\PaletteItemSettings $seals 
     *
     * @return $this
     */
    public function setSeals($seals)
    {
        $this->container['seals'] = $seals;

        return $this;
    }

    /**
     * Gets smart_contracts
     *
     * @return \DocuSign\eSign\Model\PaletteItemSettings
     */
    public function getSmartContracts()
    {
        return $this->container['smart_contracts'];
    }

    /**
     * Sets smart_contracts
     *
     * @param \DocuSign\eSign\Model\PaletteItemSettings $smart_contracts 
     *
     * @return $this
     */
    public function setSmartContracts($smart_contracts)
    {
        $this->container['smart_contracts'] = $smart_contracts;

        return $this;
    }

    /**
     * Gets smart_sections
     *
     * @return \DocuSign\eSign\Model\PaletteItemSettings
     */
    public function getSmartSections()
    {
        return $this->container['smart_sections'];
    }

    /**
     * Sets smart_sections
     *
     * @param \DocuSign\eSign\Model\PaletteItemSettings $smart_sections 
     *
     * @return $this
     */
    public function setSmartSections($smart_sections)
    {
        $this->container['smart_sections'] = $smart_sections;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

