<?php
/**
 * CertifiedDelivery
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Docusign eSignature REST API
 *
 * The Docusign eSignature REST API provides you with a powerful, convenient, and simple Web services API for interacting with Docusign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * CertifiedDelivery Class Doc Comment
 *
 * @category    Class
 * @description Contains information about a certified delivery recipient. Certified delivery recipients must receive the completed documents for the envelope to be completed. However, they don&#39;t need to sign, initial, date or add information to any of the documents.
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The Docusign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CertifiedDelivery implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'certifiedDelivery';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'access_code' => '?string',
        'access_code_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'add_access_code_to_email' => '?string',
        'additional_notifications' => '\DocuSign\eSign\Model\RecipientAdditionalNotification[]',
        'agent_can_edit_email' => '?string',
        'agent_can_edit_name' => '?string',
        'allow_system_override_for_locked_recipient' => '?string',
        'auto_responded_reason' => '?string',
        'bulk_send_v2_recipient' => '?string',
        'client_user_id' => '?string',
        'completed_count' => '?string',
        'consent_details_list' => '\DocuSign\eSign\Model\ConsentDetails[]',
        'custom_fields' => '?string[]',
        'declined_date_time' => '?string',
        'declined_reason' => '?string',
        'delivered_date_time' => '?string',
        'delivery_method' => '?string',
        'delivery_method_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'designator_id' => '?string',
        'designator_id_guid' => '?string',
        'document_visibility' => '\DocuSign\eSign\Model\DocumentVisibility[]',
        'email' => '?string',
        'email_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'email_notification' => '\DocuSign\eSign\Model\RecipientEmailNotification',
        'email_recipient_post_signing_url' => '?string',
        'embedded_recipient_start_url' => '?string',
        'error_details' => '\DocuSign\eSign\Model\ErrorDetails',
        'excluded_documents' => '?string[]',
        'fax_number' => '?string',
        'fax_number_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'first_name' => '?string',
        'first_name_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'full_name' => '?string',
        'full_name_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'id_check_configuration_name' => '?string',
        'id_check_configuration_name_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'id_check_information_input' => '\DocuSign\eSign\Model\IdCheckInformationInput',
        'identity_verification' => '\DocuSign\eSign\Model\RecipientIdentityVerification',
        'inherit_email_notification_configuration' => '?string',
        'last_name' => '?string',
        'last_name_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'locked_recipient_phone_auth_editable' => '?string',
        'locked_recipient_sms_editable' => '?string',
        'name' => '?string',
        'name_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'note' => '?string',
        'note_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'phone_authentication' => '\DocuSign\eSign\Model\RecipientPhoneAuthentication',
        'phone_number' => '\DocuSign\eSign\Model\RecipientPhoneNumber',
        'proof_file' => '\DocuSign\eSign\Model\RecipientProofFile',
        'recipient_attachments' => '\DocuSign\eSign\Model\RecipientAttachment[]',
        'recipient_authentication_status' => '\DocuSign\eSign\Model\AuthenticationStatus',
        'recipient_feature_metadata' => '\DocuSign\eSign\Model\FeatureAvailableMetadata[]',
        'recipient_id' => '?string',
        'recipient_id_guid' => '?string',
        'recipient_type' => '?string',
        'recipient_type_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'require_id_lookup' => '?string',
        'require_id_lookup_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'role_name' => '?string',
        'routing_order' => '?string',
        'routing_order_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'sent_date_time' => '?string',
        'signed_date_time' => '?string',
        'signing_group_id' => '?string',
        'signing_group_id_metadata' => '\DocuSign\eSign\Model\PropertyMetadata',
        'signing_group_name' => '?string',
        'signing_group_users' => '\DocuSign\eSign\Model\UserInfo[]',
        'sms_authentication' => '\DocuSign\eSign\Model\RecipientSMSAuthentication',
        'social_authentications' => '\DocuSign\eSign\Model\SocialAuthentication[]',
        'status' => '?string',
        'status_code' => '?string',
        'suppress_emails' => '?string',
        'template_locked' => '?string',
        'template_required' => '?string',
        'total_tab_count' => '?string',
        'user_id' => '?string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'access_code' => null,
        'access_code_metadata' => null,
        'add_access_code_to_email' => null,
        'additional_notifications' => null,
        'agent_can_edit_email' => null,
        'agent_can_edit_name' => null,
        'allow_system_override_for_locked_recipient' => null,
        'auto_responded_reason' => null,
        'bulk_send_v2_recipient' => null,
        'client_user_id' => null,
        'completed_count' => null,
        'consent_details_list' => null,
        'custom_fields' => null,
        'declined_date_time' => null,
        'declined_reason' => null,
        'delivered_date_time' => null,
        'delivery_method' => null,
        'delivery_method_metadata' => null,
        'designator_id' => null,
        'designator_id_guid' => null,
        'document_visibility' => null,
        'email' => null,
        'email_metadata' => null,
        'email_notification' => null,
        'email_recipient_post_signing_url' => null,
        'embedded_recipient_start_url' => null,
        'error_details' => null,
        'excluded_documents' => null,
        'fax_number' => null,
        'fax_number_metadata' => null,
        'first_name' => null,
        'first_name_metadata' => null,
        'full_name' => null,
        'full_name_metadata' => null,
        'id_check_configuration_name' => null,
        'id_check_configuration_name_metadata' => null,
        'id_check_information_input' => null,
        'identity_verification' => null,
        'inherit_email_notification_configuration' => null,
        'last_name' => null,
        'last_name_metadata' => null,
        'locked_recipient_phone_auth_editable' => null,
        'locked_recipient_sms_editable' => null,
        'name' => null,
        'name_metadata' => null,
        'note' => null,
        'note_metadata' => null,
        'phone_authentication' => null,
        'phone_number' => null,
        'proof_file' => null,
        'recipient_attachments' => null,
        'recipient_authentication_status' => null,
        'recipient_feature_metadata' => null,
        'recipient_id' => null,
        'recipient_id_guid' => null,
        'recipient_type' => null,
        'recipient_type_metadata' => null,
        'require_id_lookup' => null,
        'require_id_lookup_metadata' => null,
        'role_name' => null,
        'routing_order' => null,
        'routing_order_metadata' => null,
        'sent_date_time' => null,
        'signed_date_time' => null,
        'signing_group_id' => null,
        'signing_group_id_metadata' => null,
        'signing_group_name' => null,
        'signing_group_users' => null,
        'sms_authentication' => null,
        'social_authentications' => null,
        'status' => null,
        'status_code' => null,
        'suppress_emails' => null,
        'template_locked' => null,
        'template_required' => null,
        'total_tab_count' => null,
        'user_id' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'access_code' => 'accessCode',
        'access_code_metadata' => 'accessCodeMetadata',
        'add_access_code_to_email' => 'addAccessCodeToEmail',
        'additional_notifications' => 'additionalNotifications',
        'agent_can_edit_email' => 'agentCanEditEmail',
        'agent_can_edit_name' => 'agentCanEditName',
        'allow_system_override_for_locked_recipient' => 'allowSystemOverrideForLockedRecipient',
        'auto_responded_reason' => 'autoRespondedReason',
        'bulk_send_v2_recipient' => 'bulkSendV2Recipient',
        'client_user_id' => 'clientUserId',
        'completed_count' => 'completedCount',
        'consent_details_list' => 'consentDetailsList',
        'custom_fields' => 'customFields',
        'declined_date_time' => 'declinedDateTime',
        'declined_reason' => 'declinedReason',
        'delivered_date_time' => 'deliveredDateTime',
        'delivery_method' => 'deliveryMethod',
        'delivery_method_metadata' => 'deliveryMethodMetadata',
        'designator_id' => 'designatorId',
        'designator_id_guid' => 'designatorIdGuid',
        'document_visibility' => 'documentVisibility',
        'email' => 'email',
        'email_metadata' => 'emailMetadata',
        'email_notification' => 'emailNotification',
        'email_recipient_post_signing_url' => 'emailRecipientPostSigningURL',
        'embedded_recipient_start_url' => 'embeddedRecipientStartURL',
        'error_details' => 'errorDetails',
        'excluded_documents' => 'excludedDocuments',
        'fax_number' => 'faxNumber',
        'fax_number_metadata' => 'faxNumberMetadata',
        'first_name' => 'firstName',
        'first_name_metadata' => 'firstNameMetadata',
        'full_name' => 'fullName',
        'full_name_metadata' => 'fullNameMetadata',
        'id_check_configuration_name' => 'idCheckConfigurationName',
        'id_check_configuration_name_metadata' => 'idCheckConfigurationNameMetadata',
        'id_check_information_input' => 'idCheckInformationInput',
        'identity_verification' => 'identityVerification',
        'inherit_email_notification_configuration' => 'inheritEmailNotificationConfiguration',
        'last_name' => 'lastName',
        'last_name_metadata' => 'lastNameMetadata',
        'locked_recipient_phone_auth_editable' => 'lockedRecipientPhoneAuthEditable',
        'locked_recipient_sms_editable' => 'lockedRecipientSmsEditable',
        'name' => 'name',
        'name_metadata' => 'nameMetadata',
        'note' => 'note',
        'note_metadata' => 'noteMetadata',
        'phone_authentication' => 'phoneAuthentication',
        'phone_number' => 'phoneNumber',
        'proof_file' => 'proofFile',
        'recipient_attachments' => 'recipientAttachments',
        'recipient_authentication_status' => 'recipientAuthenticationStatus',
        'recipient_feature_metadata' => 'recipientFeatureMetadata',
        'recipient_id' => 'recipientId',
        'recipient_id_guid' => 'recipientIdGuid',
        'recipient_type' => 'recipientType',
        'recipient_type_metadata' => 'recipientTypeMetadata',
        'require_id_lookup' => 'requireIdLookup',
        'require_id_lookup_metadata' => 'requireIdLookupMetadata',
        'role_name' => 'roleName',
        'routing_order' => 'routingOrder',
        'routing_order_metadata' => 'routingOrderMetadata',
        'sent_date_time' => 'sentDateTime',
        'signed_date_time' => 'signedDateTime',
        'signing_group_id' => 'signingGroupId',
        'signing_group_id_metadata' => 'signingGroupIdMetadata',
        'signing_group_name' => 'signingGroupName',
        'signing_group_users' => 'signingGroupUsers',
        'sms_authentication' => 'smsAuthentication',
        'social_authentications' => 'socialAuthentications',
        'status' => 'status',
        'status_code' => 'statusCode',
        'suppress_emails' => 'suppressEmails',
        'template_locked' => 'templateLocked',
        'template_required' => 'templateRequired',
        'total_tab_count' => 'totalTabCount',
        'user_id' => 'userId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'access_code' => 'setAccessCode',
        'access_code_metadata' => 'setAccessCodeMetadata',
        'add_access_code_to_email' => 'setAddAccessCodeToEmail',
        'additional_notifications' => 'setAdditionalNotifications',
        'agent_can_edit_email' => 'setAgentCanEditEmail',
        'agent_can_edit_name' => 'setAgentCanEditName',
        'allow_system_override_for_locked_recipient' => 'setAllowSystemOverrideForLockedRecipient',
        'auto_responded_reason' => 'setAutoRespondedReason',
        'bulk_send_v2_recipient' => 'setBulkSendV2Recipient',
        'client_user_id' => 'setClientUserId',
        'completed_count' => 'setCompletedCount',
        'consent_details_list' => 'setConsentDetailsList',
        'custom_fields' => 'setCustomFields',
        'declined_date_time' => 'setDeclinedDateTime',
        'declined_reason' => 'setDeclinedReason',
        'delivered_date_time' => 'setDeliveredDateTime',
        'delivery_method' => 'setDeliveryMethod',
        'delivery_method_metadata' => 'setDeliveryMethodMetadata',
        'designator_id' => 'setDesignatorId',
        'designator_id_guid' => 'setDesignatorIdGuid',
        'document_visibility' => 'setDocumentVisibility',
        'email' => 'setEmail',
        'email_metadata' => 'setEmailMetadata',
        'email_notification' => 'setEmailNotification',
        'email_recipient_post_signing_url' => 'setEmailRecipientPostSigningUrl',
        'embedded_recipient_start_url' => 'setEmbeddedRecipientStartUrl',
        'error_details' => 'setErrorDetails',
        'excluded_documents' => 'setExcludedDocuments',
        'fax_number' => 'setFaxNumber',
        'fax_number_metadata' => 'setFaxNumberMetadata',
        'first_name' => 'setFirstName',
        'first_name_metadata' => 'setFirstNameMetadata',
        'full_name' => 'setFullName',
        'full_name_metadata' => 'setFullNameMetadata',
        'id_check_configuration_name' => 'setIdCheckConfigurationName',
        'id_check_configuration_name_metadata' => 'setIdCheckConfigurationNameMetadata',
        'id_check_information_input' => 'setIdCheckInformationInput',
        'identity_verification' => 'setIdentityVerification',
        'inherit_email_notification_configuration' => 'setInheritEmailNotificationConfiguration',
        'last_name' => 'setLastName',
        'last_name_metadata' => 'setLastNameMetadata',
        'locked_recipient_phone_auth_editable' => 'setLockedRecipientPhoneAuthEditable',
        'locked_recipient_sms_editable' => 'setLockedRecipientSmsEditable',
        'name' => 'setName',
        'name_metadata' => 'setNameMetadata',
        'note' => 'setNote',
        'note_metadata' => 'setNoteMetadata',
        'phone_authentication' => 'setPhoneAuthentication',
        'phone_number' => 'setPhoneNumber',
        'proof_file' => 'setProofFile',
        'recipient_attachments' => 'setRecipientAttachments',
        'recipient_authentication_status' => 'setRecipientAuthenticationStatus',
        'recipient_feature_metadata' => 'setRecipientFeatureMetadata',
        'recipient_id' => 'setRecipientId',
        'recipient_id_guid' => 'setRecipientIdGuid',
        'recipient_type' => 'setRecipientType',
        'recipient_type_metadata' => 'setRecipientTypeMetadata',
        'require_id_lookup' => 'setRequireIdLookup',
        'require_id_lookup_metadata' => 'setRequireIdLookupMetadata',
        'role_name' => 'setRoleName',
        'routing_order' => 'setRoutingOrder',
        'routing_order_metadata' => 'setRoutingOrderMetadata',
        'sent_date_time' => 'setSentDateTime',
        'signed_date_time' => 'setSignedDateTime',
        'signing_group_id' => 'setSigningGroupId',
        'signing_group_id_metadata' => 'setSigningGroupIdMetadata',
        'signing_group_name' => 'setSigningGroupName',
        'signing_group_users' => 'setSigningGroupUsers',
        'sms_authentication' => 'setSmsAuthentication',
        'social_authentications' => 'setSocialAuthentications',
        'status' => 'setStatus',
        'status_code' => 'setStatusCode',
        'suppress_emails' => 'setSuppressEmails',
        'template_locked' => 'setTemplateLocked',
        'template_required' => 'setTemplateRequired',
        'total_tab_count' => 'setTotalTabCount',
        'user_id' => 'setUserId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'access_code' => 'getAccessCode',
        'access_code_metadata' => 'getAccessCodeMetadata',
        'add_access_code_to_email' => 'getAddAccessCodeToEmail',
        'additional_notifications' => 'getAdditionalNotifications',
        'agent_can_edit_email' => 'getAgentCanEditEmail',
        'agent_can_edit_name' => 'getAgentCanEditName',
        'allow_system_override_for_locked_recipient' => 'getAllowSystemOverrideForLockedRecipient',
        'auto_responded_reason' => 'getAutoRespondedReason',
        'bulk_send_v2_recipient' => 'getBulkSendV2Recipient',
        'client_user_id' => 'getClientUserId',
        'completed_count' => 'getCompletedCount',
        'consent_details_list' => 'getConsentDetailsList',
        'custom_fields' => 'getCustomFields',
        'declined_date_time' => 'getDeclinedDateTime',
        'declined_reason' => 'getDeclinedReason',
        'delivered_date_time' => 'getDeliveredDateTime',
        'delivery_method' => 'getDeliveryMethod',
        'delivery_method_metadata' => 'getDeliveryMethodMetadata',
        'designator_id' => 'getDesignatorId',
        'designator_id_guid' => 'getDesignatorIdGuid',
        'document_visibility' => 'getDocumentVisibility',
        'email' => 'getEmail',
        'email_metadata' => 'getEmailMetadata',
        'email_notification' => 'getEmailNotification',
        'email_recipient_post_signing_url' => 'getEmailRecipientPostSigningUrl',
        'embedded_recipient_start_url' => 'getEmbeddedRecipientStartUrl',
        'error_details' => 'getErrorDetails',
        'excluded_documents' => 'getExcludedDocuments',
        'fax_number' => 'getFaxNumber',
        'fax_number_metadata' => 'getFaxNumberMetadata',
        'first_name' => 'getFirstName',
        'first_name_metadata' => 'getFirstNameMetadata',
        'full_name' => 'getFullName',
        'full_name_metadata' => 'getFullNameMetadata',
        'id_check_configuration_name' => 'getIdCheckConfigurationName',
        'id_check_configuration_name_metadata' => 'getIdCheckConfigurationNameMetadata',
        'id_check_information_input' => 'getIdCheckInformationInput',
        'identity_verification' => 'getIdentityVerification',
        'inherit_email_notification_configuration' => 'getInheritEmailNotificationConfiguration',
        'last_name' => 'getLastName',
        'last_name_metadata' => 'getLastNameMetadata',
        'locked_recipient_phone_auth_editable' => 'getLockedRecipientPhoneAuthEditable',
        'locked_recipient_sms_editable' => 'getLockedRecipientSmsEditable',
        'name' => 'getName',
        'name_metadata' => 'getNameMetadata',
        'note' => 'getNote',
        'note_metadata' => 'getNoteMetadata',
        'phone_authentication' => 'getPhoneAuthentication',
        'phone_number' => 'getPhoneNumber',
        'proof_file' => 'getProofFile',
        'recipient_attachments' => 'getRecipientAttachments',
        'recipient_authentication_status' => 'getRecipientAuthenticationStatus',
        'recipient_feature_metadata' => 'getRecipientFeatureMetadata',
        'recipient_id' => 'getRecipientId',
        'recipient_id_guid' => 'getRecipientIdGuid',
        'recipient_type' => 'getRecipientType',
        'recipient_type_metadata' => 'getRecipientTypeMetadata',
        'require_id_lookup' => 'getRequireIdLookup',
        'require_id_lookup_metadata' => 'getRequireIdLookupMetadata',
        'role_name' => 'getRoleName',
        'routing_order' => 'getRoutingOrder',
        'routing_order_metadata' => 'getRoutingOrderMetadata',
        'sent_date_time' => 'getSentDateTime',
        'signed_date_time' => 'getSignedDateTime',
        'signing_group_id' => 'getSigningGroupId',
        'signing_group_id_metadata' => 'getSigningGroupIdMetadata',
        'signing_group_name' => 'getSigningGroupName',
        'signing_group_users' => 'getSigningGroupUsers',
        'sms_authentication' => 'getSmsAuthentication',
        'social_authentications' => 'getSocialAuthentications',
        'status' => 'getStatus',
        'status_code' => 'getStatusCode',
        'suppress_emails' => 'getSuppressEmails',
        'template_locked' => 'getTemplateLocked',
        'template_required' => 'getTemplateRequired',
        'total_tab_count' => 'getTotalTabCount',
        'user_id' => 'getUserId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['access_code'] = isset($data['access_code']) ? $data['access_code'] : null;
        $this->container['access_code_metadata'] = isset($data['access_code_metadata']) ? $data['access_code_metadata'] : null;
        $this->container['add_access_code_to_email'] = isset($data['add_access_code_to_email']) ? $data['add_access_code_to_email'] : null;
        $this->container['additional_notifications'] = isset($data['additional_notifications']) ? $data['additional_notifications'] : null;
        $this->container['agent_can_edit_email'] = isset($data['agent_can_edit_email']) ? $data['agent_can_edit_email'] : null;
        $this->container['agent_can_edit_name'] = isset($data['agent_can_edit_name']) ? $data['agent_can_edit_name'] : null;
        $this->container['allow_system_override_for_locked_recipient'] = isset($data['allow_system_override_for_locked_recipient']) ? $data['allow_system_override_for_locked_recipient'] : null;
        $this->container['auto_responded_reason'] = isset($data['auto_responded_reason']) ? $data['auto_responded_reason'] : null;
        $this->container['bulk_send_v2_recipient'] = isset($data['bulk_send_v2_recipient']) ? $data['bulk_send_v2_recipient'] : null;
        $this->container['client_user_id'] = isset($data['client_user_id']) ? $data['client_user_id'] : null;
        $this->container['completed_count'] = isset($data['completed_count']) ? $data['completed_count'] : null;
        $this->container['consent_details_list'] = isset($data['consent_details_list']) ? $data['consent_details_list'] : null;
        $this->container['custom_fields'] = isset($data['custom_fields']) ? $data['custom_fields'] : null;
        $this->container['declined_date_time'] = isset($data['declined_date_time']) ? $data['declined_date_time'] : null;
        $this->container['declined_reason'] = isset($data['declined_reason']) ? $data['declined_reason'] : null;
        $this->container['delivered_date_time'] = isset($data['delivered_date_time']) ? $data['delivered_date_time'] : null;
        $this->container['delivery_method'] = isset($data['delivery_method']) ? $data['delivery_method'] : null;
        $this->container['delivery_method_metadata'] = isset($data['delivery_method_metadata']) ? $data['delivery_method_metadata'] : null;
        $this->container['designator_id'] = isset($data['designator_id']) ? $data['designator_id'] : null;
        $this->container['designator_id_guid'] = isset($data['designator_id_guid']) ? $data['designator_id_guid'] : null;
        $this->container['document_visibility'] = isset($data['document_visibility']) ? $data['document_visibility'] : null;
        $this->container['email'] = isset($data['email']) ? $data['email'] : null;
        $this->container['email_metadata'] = isset($data['email_metadata']) ? $data['email_metadata'] : null;
        $this->container['email_notification'] = isset($data['email_notification']) ? $data['email_notification'] : null;
        $this->container['email_recipient_post_signing_url'] = isset($data['email_recipient_post_signing_url']) ? $data['email_recipient_post_signing_url'] : null;
        $this->container['embedded_recipient_start_url'] = isset($data['embedded_recipient_start_url']) ? $data['embedded_recipient_start_url'] : null;
        $this->container['error_details'] = isset($data['error_details']) ? $data['error_details'] : null;
        $this->container['excluded_documents'] = isset($data['excluded_documents']) ? $data['excluded_documents'] : null;
        $this->container['fax_number'] = isset($data['fax_number']) ? $data['fax_number'] : null;
        $this->container['fax_number_metadata'] = isset($data['fax_number_metadata']) ? $data['fax_number_metadata'] : null;
        $this->container['first_name'] = isset($data['first_name']) ? $data['first_name'] : null;
        $this->container['first_name_metadata'] = isset($data['first_name_metadata']) ? $data['first_name_metadata'] : null;
        $this->container['full_name'] = isset($data['full_name']) ? $data['full_name'] : null;
        $this->container['full_name_metadata'] = isset($data['full_name_metadata']) ? $data['full_name_metadata'] : null;
        $this->container['id_check_configuration_name'] = isset($data['id_check_configuration_name']) ? $data['id_check_configuration_name'] : null;
        $this->container['id_check_configuration_name_metadata'] = isset($data['id_check_configuration_name_metadata']) ? $data['id_check_configuration_name_metadata'] : null;
        $this->container['id_check_information_input'] = isset($data['id_check_information_input']) ? $data['id_check_information_input'] : null;
        $this->container['identity_verification'] = isset($data['identity_verification']) ? $data['identity_verification'] : null;
        $this->container['inherit_email_notification_configuration'] = isset($data['inherit_email_notification_configuration']) ? $data['inherit_email_notification_configuration'] : null;
        $this->container['last_name'] = isset($data['last_name']) ? $data['last_name'] : null;
        $this->container['last_name_metadata'] = isset($data['last_name_metadata']) ? $data['last_name_metadata'] : null;
        $this->container['locked_recipient_phone_auth_editable'] = isset($data['locked_recipient_phone_auth_editable']) ? $data['locked_recipient_phone_auth_editable'] : null;
        $this->container['locked_recipient_sms_editable'] = isset($data['locked_recipient_sms_editable']) ? $data['locked_recipient_sms_editable'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['name_metadata'] = isset($data['name_metadata']) ? $data['name_metadata'] : null;
        $this->container['note'] = isset($data['note']) ? $data['note'] : null;
        $this->container['note_metadata'] = isset($data['note_metadata']) ? $data['note_metadata'] : null;
        $this->container['phone_authentication'] = isset($data['phone_authentication']) ? $data['phone_authentication'] : null;
        $this->container['phone_number'] = isset($data['phone_number']) ? $data['phone_number'] : null;
        $this->container['proof_file'] = isset($data['proof_file']) ? $data['proof_file'] : null;
        $this->container['recipient_attachments'] = isset($data['recipient_attachments']) ? $data['recipient_attachments'] : null;
        $this->container['recipient_authentication_status'] = isset($data['recipient_authentication_status']) ? $data['recipient_authentication_status'] : null;
        $this->container['recipient_feature_metadata'] = isset($data['recipient_feature_metadata']) ? $data['recipient_feature_metadata'] : null;
        $this->container['recipient_id'] = isset($data['recipient_id']) ? $data['recipient_id'] : null;
        $this->container['recipient_id_guid'] = isset($data['recipient_id_guid']) ? $data['recipient_id_guid'] : null;
        $this->container['recipient_type'] = isset($data['recipient_type']) ? $data['recipient_type'] : null;
        $this->container['recipient_type_metadata'] = isset($data['recipient_type_metadata']) ? $data['recipient_type_metadata'] : null;
        $this->container['require_id_lookup'] = isset($data['require_id_lookup']) ? $data['require_id_lookup'] : null;
        $this->container['require_id_lookup_metadata'] = isset($data['require_id_lookup_metadata']) ? $data['require_id_lookup_metadata'] : null;
        $this->container['role_name'] = isset($data['role_name']) ? $data['role_name'] : null;
        $this->container['routing_order'] = isset($data['routing_order']) ? $data['routing_order'] : null;
        $this->container['routing_order_metadata'] = isset($data['routing_order_metadata']) ? $data['routing_order_metadata'] : null;
        $this->container['sent_date_time'] = isset($data['sent_date_time']) ? $data['sent_date_time'] : null;
        $this->container['signed_date_time'] = isset($data['signed_date_time']) ? $data['signed_date_time'] : null;
        $this->container['signing_group_id'] = isset($data['signing_group_id']) ? $data['signing_group_id'] : null;
        $this->container['signing_group_id_metadata'] = isset($data['signing_group_id_metadata']) ? $data['signing_group_id_metadata'] : null;
        $this->container['signing_group_name'] = isset($data['signing_group_name']) ? $data['signing_group_name'] : null;
        $this->container['signing_group_users'] = isset($data['signing_group_users']) ? $data['signing_group_users'] : null;
        $this->container['sms_authentication'] = isset($data['sms_authentication']) ? $data['sms_authentication'] : null;
        $this->container['social_authentications'] = isset($data['social_authentications']) ? $data['social_authentications'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['status_code'] = isset($data['status_code']) ? $data['status_code'] : null;
        $this->container['suppress_emails'] = isset($data['suppress_emails']) ? $data['suppress_emails'] : null;
        $this->container['template_locked'] = isset($data['template_locked']) ? $data['template_locked'] : null;
        $this->container['template_required'] = isset($data['template_required']) ? $data['template_required'] : null;
        $this->container['total_tab_count'] = isset($data['total_tab_count']) ? $data['total_tab_count'] : null;
        $this->container['user_id'] = isset($data['user_id']) ? $data['user_id'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets access_code
     *
     * @return ?string
     */
    public function getAccessCode()
    {
        return $this->container['access_code'];
    }

    /**
     * Sets access_code
     *
     * @param ?string $access_code If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.
     *
     * @return $this
     */
    public function setAccessCode($access_code)
    {
        $this->container['access_code'] = $access_code;

        return $this;
    }

    /**
     * Gets access_code_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getAccessCodeMetadata()
    {
        return $this->container['access_code_metadata'];
    }

    /**
     * Sets access_code_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $access_code_metadata Metadata that indicates whether the `accessCode` property is editable. This property is read-only.
     *
     * @return $this
     */
    public function setAccessCodeMetadata($access_code_metadata)
    {
        $this->container['access_code_metadata'] = $access_code_metadata;

        return $this;
    }

    /**
     * Gets add_access_code_to_email
     *
     * @return ?string
     */
    public function getAddAccessCodeToEmail()
    {
        return $this->container['add_access_code_to_email'];
    }

    /**
     * Sets add_access_code_to_email
     *
     * @param ?string $add_access_code_to_email This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.
     *
     * @return $this
     */
    public function setAddAccessCodeToEmail($add_access_code_to_email)
    {
        $this->container['add_access_code_to_email'] = $add_access_code_to_email;

        return $this;
    }

    /**
     * Gets additional_notifications
     *
     * @return \DocuSign\eSign\Model\RecipientAdditionalNotification[]
     */
    public function getAdditionalNotifications()
    {
        return $this->container['additional_notifications'];
    }

    /**
     * Sets additional_notifications
     *
     * @param \DocuSign\eSign\Model\RecipientAdditionalNotification[] $additional_notifications 
     *
     * @return $this
     */
    public function setAdditionalNotifications($additional_notifications)
    {
        $this->container['additional_notifications'] = $additional_notifications;

        return $this;
    }

    /**
     * Gets agent_can_edit_email
     *
     * @return ?string
     */
    public function getAgentCanEditEmail()
    {
        return $this->container['agent_can_edit_email'];
    }

    /**
     * Sets agent_can_edit_email
     *
     * @param ?string $agent_can_edit_email 
     *
     * @return $this
     */
    public function setAgentCanEditEmail($agent_can_edit_email)
    {
        $this->container['agent_can_edit_email'] = $agent_can_edit_email;

        return $this;
    }

    /**
     * Gets agent_can_edit_name
     *
     * @return ?string
     */
    public function getAgentCanEditName()
    {
        return $this->container['agent_can_edit_name'];
    }

    /**
     * Sets agent_can_edit_name
     *
     * @param ?string $agent_can_edit_name 
     *
     * @return $this
     */
    public function setAgentCanEditName($agent_can_edit_name)
    {
        $this->container['agent_can_edit_name'] = $agent_can_edit_name;

        return $this;
    }

    /**
     * Gets allow_system_override_for_locked_recipient
     *
     * @return ?string
     */
    public function getAllowSystemOverrideForLockedRecipient()
    {
        return $this->container['allow_system_override_for_locked_recipient'];
    }

    /**
     * Sets allow_system_override_for_locked_recipient
     *
     * @param ?string $allow_system_override_for_locked_recipient 
     *
     * @return $this
     */
    public function setAllowSystemOverrideForLockedRecipient($allow_system_override_for_locked_recipient)
    {
        $this->container['allow_system_override_for_locked_recipient'] = $allow_system_override_for_locked_recipient;

        return $this;
    }

    /**
     * Gets auto_responded_reason
     *
     * @return ?string
     */
    public function getAutoRespondedReason()
    {
        return $this->container['auto_responded_reason'];
    }

    /**
     * Sets auto_responded_reason
     *
     * @param ?string $auto_responded_reason 
     *
     * @return $this
     */
    public function setAutoRespondedReason($auto_responded_reason)
    {
        $this->container['auto_responded_reason'] = $auto_responded_reason;

        return $this;
    }

    /**
     * Gets bulk_send_v2_recipient
     *
     * @return ?string
     */
    public function getBulkSendV2Recipient()
    {
        return $this->container['bulk_send_v2_recipient'];
    }

    /**
     * Sets bulk_send_v2_recipient
     *
     * @param ?string $bulk_send_v2_recipient 
     *
     * @return $this
     */
    public function setBulkSendV2Recipient($bulk_send_v2_recipient)
    {
        $this->container['bulk_send_v2_recipient'] = $bulk_send_v2_recipient;

        return $this;
    }

    /**
     * Gets client_user_id
     *
     * @return ?string
     */
    public function getClientUserId()
    {
        return $this->container['client_user_id'];
    }

    /**
     * Sets client_user_id
     *
     * @param ?string $client_user_id Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters.
     *
     * @return $this
     */
    public function setClientUserId($client_user_id)
    {
        $this->container['client_user_id'] = $client_user_id;

        return $this;
    }

    /**
     * Gets completed_count
     *
     * @return ?string
     */
    public function getCompletedCount()
    {
        return $this->container['completed_count'];
    }

    /**
     * Sets completed_count
     *
     * @param ?string $completed_count 
     *
     * @return $this
     */
    public function setCompletedCount($completed_count)
    {
        $this->container['completed_count'] = $completed_count;

        return $this;
    }

    /**
     * Gets consent_details_list
     *
     * @return \DocuSign\eSign\Model\ConsentDetails[]
     */
    public function getConsentDetailsList()
    {
        return $this->container['consent_details_list'];
    }

    /**
     * Sets consent_details_list
     *
     * @param \DocuSign\eSign\Model\ConsentDetails[] $consent_details_list 
     *
     * @return $this
     */
    public function setConsentDetailsList($consent_details_list)
    {
        $this->container['consent_details_list'] = $consent_details_list;

        return $this;
    }

    /**
     * Gets custom_fields
     *
     * @return ?string[]
     */
    public function getCustomFields()
    {
        return $this->container['custom_fields'];
    }

    /**
     * Sets custom_fields
     *
     * @param ?string[] $custom_fields An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.
     *
     * @return $this
     */
    public function setCustomFields($custom_fields)
    {
        $this->container['custom_fields'] = $custom_fields;

        return $this;
    }

    /**
     * Gets declined_date_time
     *
     * @return ?string
     */
    public function getDeclinedDateTime()
    {
        return $this->container['declined_date_time'];
    }

    /**
     * Sets declined_date_time
     *
     * @param ?string $declined_date_time The date and time the recipient declined the document.
     *
     * @return $this
     */
    public function setDeclinedDateTime($declined_date_time)
    {
        $this->container['declined_date_time'] = $declined_date_time;

        return $this;
    }

    /**
     * Gets declined_reason
     *
     * @return ?string
     */
    public function getDeclinedReason()
    {
        return $this->container['declined_reason'];
    }

    /**
     * Sets declined_reason
     *
     * @param ?string $declined_reason The reason the recipient declined the document.
     *
     * @return $this
     */
    public function setDeclinedReason($declined_reason)
    {
        $this->container['declined_reason'] = $declined_reason;

        return $this;
    }

    /**
     * Gets delivered_date_time
     *
     * @return ?string
     */
    public function getDeliveredDateTime()
    {
        return $this->container['delivered_date_time'];
    }

    /**
     * Sets delivered_date_time
     *
     * @param ?string $delivered_date_time Reserved: For DocuSign use only.
     *
     * @return $this
     */
    public function setDeliveredDateTime($delivered_date_time)
    {
        $this->container['delivered_date_time'] = $delivered_date_time;

        return $this;
    }

    /**
     * Gets delivery_method
     *
     * @return ?string
     */
    public function getDeliveryMethod()
    {
        return $this->container['delivery_method'];
    }

    /**
     * Sets delivery_method
     *
     * @param ?string $delivery_method Reserved: For DocuSign use only.
     *
     * @return $this
     */
    public function setDeliveryMethod($delivery_method)
    {
        $this->container['delivery_method'] = $delivery_method;

        return $this;
    }

    /**
     * Gets delivery_method_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getDeliveryMethodMetadata()
    {
        return $this->container['delivery_method_metadata'];
    }

    /**
     * Sets delivery_method_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $delivery_method_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setDeliveryMethodMetadata($delivery_method_metadata)
    {
        $this->container['delivery_method_metadata'] = $delivery_method_metadata;

        return $this;
    }

    /**
     * Gets designator_id
     *
     * @return ?string
     */
    public function getDesignatorId()
    {
        return $this->container['designator_id'];
    }

    /**
     * Sets designator_id
     *
     * @param ?string $designator_id 
     *
     * @return $this
     */
    public function setDesignatorId($designator_id)
    {
        $this->container['designator_id'] = $designator_id;

        return $this;
    }

    /**
     * Gets designator_id_guid
     *
     * @return ?string
     */
    public function getDesignatorIdGuid()
    {
        return $this->container['designator_id_guid'];
    }

    /**
     * Sets designator_id_guid
     *
     * @param ?string $designator_id_guid 
     *
     * @return $this
     */
    public function setDesignatorIdGuid($designator_id_guid)
    {
        $this->container['designator_id_guid'] = $designator_id_guid;

        return $this;
    }

    /**
     * Gets document_visibility
     *
     * @return \DocuSign\eSign\Model\DocumentVisibility[]
     */
    public function getDocumentVisibility()
    {
        return $this->container['document_visibility'];
    }

    /**
     * Sets document_visibility
     *
     * @param \DocuSign\eSign\Model\DocumentVisibility[] $document_visibility 
     *
     * @return $this
     */
    public function setDocumentVisibility($document_visibility)
    {
        $this->container['document_visibility'] = $document_visibility;

        return $this;
    }

    /**
     * Gets email
     *
     * @return ?string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param ?string $email 
     *
     * @return $this
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets email_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getEmailMetadata()
    {
        return $this->container['email_metadata'];
    }

    /**
     * Sets email_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $email_metadata Metadata that indicates whether the `email` property is editable. This property is read-only.
     *
     * @return $this
     */
    public function setEmailMetadata($email_metadata)
    {
        $this->container['email_metadata'] = $email_metadata;

        return $this;
    }

    /**
     * Gets email_notification
     *
     * @return \DocuSign\eSign\Model\RecipientEmailNotification
     */
    public function getEmailNotification()
    {
        return $this->container['email_notification'];
    }

    /**
     * Sets email_notification
     *
     * @param \DocuSign\eSign\Model\RecipientEmailNotification $email_notification A complex type that contains information sets the language of the recipient's email information.   **IMPORTANT**: If you enable email notification for one recipient, you must enable email notification for all recipients as it overrides the Envelope Subject and `EmailBlurb` property settings.
     *
     * @return $this
     */
    public function setEmailNotification($email_notification)
    {
        $this->container['email_notification'] = $email_notification;

        return $this;
    }

    /**
     * Gets email_recipient_post_signing_url
     *
     * @return ?string
     */
    public function getEmailRecipientPostSigningUrl()
    {
        return $this->container['email_recipient_post_signing_url'];
    }

    /**
     * Sets email_recipient_post_signing_url
     *
     * @param ?string $email_recipient_post_signing_url 
     *
     * @return $this
     */
    public function setEmailRecipientPostSigningUrl($email_recipient_post_signing_url)
    {
        $this->container['email_recipient_post_signing_url'] = $email_recipient_post_signing_url;

        return $this;
    }

    /**
     * Gets embedded_recipient_start_url
     *
     * @return ?string
     */
    public function getEmbeddedRecipientStartUrl()
    {
        return $this->container['embedded_recipient_start_url'];
    }

    /**
     * Sets embedded_recipient_start_url
     *
     * @param ?string $embedded_recipient_start_url Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]`
     *
     * @return $this
     */
    public function setEmbeddedRecipientStartUrl($embedded_recipient_start_url)
    {
        $this->container['embedded_recipient_start_url'] = $embedded_recipient_start_url;

        return $this;
    }

    /**
     * Gets error_details
     *
     * @return \DocuSign\eSign\Model\ErrorDetails
     */
    public function getErrorDetails()
    {
        return $this->container['error_details'];
    }

    /**
     * Sets error_details
     *
     * @param \DocuSign\eSign\Model\ErrorDetails $error_details Array or errors.
     *
     * @return $this
     */
    public function setErrorDetails($error_details)
    {
        $this->container['error_details'] = $error_details;

        return $this;
    }

    /**
     * Gets excluded_documents
     *
     * @return ?string[]
     */
    public function getExcludedDocuments()
    {
        return $this->container['excluded_documents'];
    }

    /**
     * Sets excluded_documents
     *
     * @param ?string[] $excluded_documents Specifies the documents that are not visible to this recipient. Document Visibility must be enabled for the account and the `enforceSignerVisibility` property must be set to **true** for the envelope to use this.  When enforce signer visibility is enabled, documents with tabs can only be viewed by signers that have a tab on that document. Recipients that have an administrative role (Agent, Editor, or Intermediaries) or informational role (Certified Deliveries or Carbon Copies) can always see all the documents in an envelope, unless they are specifically excluded using this setting when an envelope is sent. Documents that do not have tabs are always visible to all recipients, unless they are specifically excluded using this setting when an envelope is sent.
     *
     * @return $this
     */
    public function setExcludedDocuments($excluded_documents)
    {
        $this->container['excluded_documents'] = $excluded_documents;

        return $this;
    }

    /**
     * Gets fax_number
     *
     * @return ?string
     */
    public function getFaxNumber()
    {
        return $this->container['fax_number'];
    }

    /**
     * Sets fax_number
     *
     * @param ?string $fax_number Reserved:
     *
     * @return $this
     */
    public function setFaxNumber($fax_number)
    {
        $this->container['fax_number'] = $fax_number;

        return $this;
    }

    /**
     * Gets fax_number_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getFaxNumberMetadata()
    {
        return $this->container['fax_number_metadata'];
    }

    /**
     * Sets fax_number_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $fax_number_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setFaxNumberMetadata($fax_number_metadata)
    {
        $this->container['fax_number_metadata'] = $fax_number_metadata;

        return $this;
    }

    /**
     * Gets first_name
     *
     * @return ?string
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     *
     * @param ?string $first_name The user's first name.  Maximum Length: 50 characters.
     *
     * @return $this
     */
    public function setFirstName($first_name)
    {
        $this->container['first_name'] = $first_name;

        return $this;
    }

    /**
     * Gets first_name_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getFirstNameMetadata()
    {
        return $this->container['first_name_metadata'];
    }

    /**
     * Sets first_name_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $first_name_metadata Metadata that indicates whether the `firstName` property is editable. This property is read-only.
     *
     * @return $this
     */
    public function setFirstNameMetadata($first_name_metadata)
    {
        $this->container['first_name_metadata'] = $first_name_metadata;

        return $this;
    }

    /**
     * Gets full_name
     *
     * @return ?string
     */
    public function getFullName()
    {
        return $this->container['full_name'];
    }

    /**
     * Sets full_name
     *
     * @param ?string $full_name 
     *
     * @return $this
     */
    public function setFullName($full_name)
    {
        $this->container['full_name'] = $full_name;

        return $this;
    }

    /**
     * Gets full_name_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getFullNameMetadata()
    {
        return $this->container['full_name_metadata'];
    }

    /**
     * Sets full_name_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $full_name_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setFullNameMetadata($full_name_metadata)
    {
        $this->container['full_name_metadata'] = $full_name_metadata;

        return $this;
    }

    /**
     * Gets id_check_configuration_name
     *
     * @return ?string
     */
    public function getIdCheckConfigurationName()
    {
        return $this->container['id_check_configuration_name'];
    }

    /**
     * Sets id_check_configuration_name
     *
     * @param ?string $id_check_configuration_name Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.
     *
     * @return $this
     */
    public function setIdCheckConfigurationName($id_check_configuration_name)
    {
        $this->container['id_check_configuration_name'] = $id_check_configuration_name;

        return $this;
    }

    /**
     * Gets id_check_configuration_name_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getIdCheckConfigurationNameMetadata()
    {
        return $this->container['id_check_configuration_name_metadata'];
    }

    /**
     * Sets id_check_configuration_name_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $id_check_configuration_name_metadata Metadata that indicates whether the `idCheckConfigurationName` property is editable. This property is read-only.
     *
     * @return $this
     */
    public function setIdCheckConfigurationNameMetadata($id_check_configuration_name_metadata)
    {
        $this->container['id_check_configuration_name_metadata'] = $id_check_configuration_name_metadata;

        return $this;
    }

    /**
     * Gets id_check_information_input
     *
     * @return \DocuSign\eSign\Model\IdCheckInformationInput
     */
    public function getIdCheckInformationInput()
    {
        return $this->container['id_check_information_input'];
    }

    /**
     * Sets id_check_information_input
     *
     * @param \DocuSign\eSign\Model\IdCheckInformationInput $id_check_information_input An object that contains input information related to a recipient ID check.
     *
     * @return $this
     */
    public function setIdCheckInformationInput($id_check_information_input)
    {
        $this->container['id_check_information_input'] = $id_check_information_input;

        return $this;
    }

    /**
     * Gets identity_verification
     *
     * @return \DocuSign\eSign\Model\RecipientIdentityVerification
     */
    public function getIdentityVerification()
    {
        return $this->container['identity_verification'];
    }

    /**
     * Sets identity_verification
     *
     * @param \DocuSign\eSign\Model\RecipientIdentityVerification $identity_verification Specifies the ID Verification workflow applied on an envelope by workflow ID. <br/>See the [list](/docs/esign-rest-api/reference/accounts/identityverifications/list/) method in the [IdentityVerifications](/docs/esign-rest-api/reference/accounts/identityverifications/) resource for more information on how to retrieve workflow IDs available for an account. <br/>This can be used in addition to other [recipient authentication](https://support.docusign.com/en/guides/ndse-user-guide-recipient-authentication) methods. <br/>Note that ID Verification and ID Check are two distinct methods. ID Verification checks recipients' identity by verifying their ID while ID Check relies on data available on public records (such as current and former address).
     *
     * @return $this
     */
    public function setIdentityVerification($identity_verification)
    {
        $this->container['identity_verification'] = $identity_verification;

        return $this;
    }

    /**
     * Gets inherit_email_notification_configuration
     *
     * @return ?string
     */
    public function getInheritEmailNotificationConfiguration()
    {
        return $this->container['inherit_email_notification_configuration'];
    }

    /**
     * Sets inherit_email_notification_configuration
     *
     * @param ?string $inherit_email_notification_configuration When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account.
     *
     * @return $this
     */
    public function setInheritEmailNotificationConfiguration($inherit_email_notification_configuration)
    {
        $this->container['inherit_email_notification_configuration'] = $inherit_email_notification_configuration;

        return $this;
    }

    /**
     * Gets last_name
     *
     * @return ?string
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     *
     * @param ?string $last_name 
     *
     * @return $this
     */
    public function setLastName($last_name)
    {
        $this->container['last_name'] = $last_name;

        return $this;
    }

    /**
     * Gets last_name_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getLastNameMetadata()
    {
        return $this->container['last_name_metadata'];
    }

    /**
     * Sets last_name_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $last_name_metadata Metadata that indicates whether the `lastName` property is editable. This property is read-only.
     *
     * @return $this
     */
    public function setLastNameMetadata($last_name_metadata)
    {
        $this->container['last_name_metadata'] = $last_name_metadata;

        return $this;
    }

    /**
     * Gets locked_recipient_phone_auth_editable
     *
     * @return ?string
     */
    public function getLockedRecipientPhoneAuthEditable()
    {
        return $this->container['locked_recipient_phone_auth_editable'];
    }

    /**
     * Sets locked_recipient_phone_auth_editable
     *
     * @param ?string $locked_recipient_phone_auth_editable 
     *
     * @return $this
     */
    public function setLockedRecipientPhoneAuthEditable($locked_recipient_phone_auth_editable)
    {
        $this->container['locked_recipient_phone_auth_editable'] = $locked_recipient_phone_auth_editable;

        return $this;
    }

    /**
     * Gets locked_recipient_sms_editable
     *
     * @return ?string
     */
    public function getLockedRecipientSmsEditable()
    {
        return $this->container['locked_recipient_sms_editable'];
    }

    /**
     * Sets locked_recipient_sms_editable
     *
     * @param ?string $locked_recipient_sms_editable 
     *
     * @return $this
     */
    public function setLockedRecipientSmsEditable($locked_recipient_sms_editable)
    {
        $this->container['locked_recipient_sms_editable'] = $locked_recipient_sms_editable;

        return $this;
    }

    /**
     * Gets name
     *
     * @return ?string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param ?string $name 
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets name_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getNameMetadata()
    {
        return $this->container['name_metadata'];
    }

    /**
     * Sets name_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $name_metadata Metadata that indicates whether the `name` property is editable. This property is read-only.
     *
     * @return $this
     */
    public function setNameMetadata($name_metadata)
    {
        $this->container['name_metadata'] = $name_metadata;

        return $this;
    }

    /**
     * Gets note
     *
     * @return ?string
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     *
     * @param ?string $note Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.
     *
     * @return $this
     */
    public function setNote($note)
    {
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets note_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getNoteMetadata()
    {
        return $this->container['note_metadata'];
    }

    /**
     * Sets note_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $note_metadata Metadata that indicates whether the `note` property is editable. This property is read-only.
     *
     * @return $this
     */
    public function setNoteMetadata($note_metadata)
    {
        $this->container['note_metadata'] = $note_metadata;

        return $this;
    }

    /**
     * Gets phone_authentication
     *
     * @return \DocuSign\eSign\Model\RecipientPhoneAuthentication
     */
    public function getPhoneAuthentication()
    {
        return $this->container['phone_authentication'];
    }

    /**
     * Sets phone_authentication
     *
     * @param \DocuSign\eSign\Model\RecipientPhoneAuthentication $phone_authentication When `idCheckConfigurationName` is set to `Phone Auth $`, you use this complex type to provide the recipient authentication method details. It contains the following elements:  * `recipMayProvideNumber`: Boolean. When **true,** the recipient can use whatever phone number they choose. * `senderProvidedNumbers`: ArrayOfStrings.  A list of phone numbers the recipient can use. * `recordVoicePrint`: Reserved for DocuSign. * `validateRecipProvidedNumber`: Reserved for DocuSign.
     *
     * @return $this
     */
    public function setPhoneAuthentication($phone_authentication)
    {
        $this->container['phone_authentication'] = $phone_authentication;

        return $this;
    }

    /**
     * Gets phone_number
     *
     * @return \DocuSign\eSign\Model\RecipientPhoneNumber
     */
    public function getPhoneNumber()
    {
        return $this->container['phone_number'];
    }

    /**
     * Sets phone_number
     *
     * @param \DocuSign\eSign\Model\RecipientPhoneNumber $phone_number Describes the recipient phone number.
     *
     * @return $this
     */
    public function setPhoneNumber($phone_number)
    {
        $this->container['phone_number'] = $phone_number;

        return $this;
    }

    /**
     * Gets proof_file
     *
     * @return \DocuSign\eSign\Model\RecipientProofFile
     */
    public function getProofFile()
    {
        return $this->container['proof_file'];
    }

    /**
     * Sets proof_file
     *
     * @param \DocuSign\eSign\Model\RecipientProofFile $proof_file The proof file of the recipient.
     *
     * @return $this
     */
    public function setProofFile($proof_file)
    {
        $this->container['proof_file'] = $proof_file;

        return $this;
    }

    /**
     * Gets recipient_attachments
     *
     * @return \DocuSign\eSign\Model\RecipientAttachment[]
     */
    public function getRecipientAttachments()
    {
        return $this->container['recipient_attachments'];
    }

    /**
     * Sets recipient_attachments
     *
     * @param \DocuSign\eSign\Model\RecipientAttachment[] $recipient_attachments Reserved:
     *
     * @return $this
     */
    public function setRecipientAttachments($recipient_attachments)
    {
        $this->container['recipient_attachments'] = $recipient_attachments;

        return $this;
    }

    /**
     * Gets recipient_authentication_status
     *
     * @return \DocuSign\eSign\Model\AuthenticationStatus
     */
    public function getRecipientAuthenticationStatus()
    {
        return $this->container['recipient_authentication_status'];
    }

    /**
     * Sets recipient_authentication_status
     *
     * @param \DocuSign\eSign\Model\AuthenticationStatus $recipient_authentication_status Information about the recipient's authentication status. This property is read-only.
     *
     * @return $this
     */
    public function setRecipientAuthenticationStatus($recipient_authentication_status)
    {
        $this->container['recipient_authentication_status'] = $recipient_authentication_status;

        return $this;
    }

    /**
     * Gets recipient_feature_metadata
     *
     * @return \DocuSign\eSign\Model\FeatureAvailableMetadata[]
     */
    public function getRecipientFeatureMetadata()
    {
        return $this->container['recipient_feature_metadata'];
    }

    /**
     * Sets recipient_feature_metadata
     *
     * @param \DocuSign\eSign\Model\FeatureAvailableMetadata[] $recipient_feature_metadata 
     *
     * @return $this
     */
    public function setRecipientFeatureMetadata($recipient_feature_metadata)
    {
        $this->container['recipient_feature_metadata'] = $recipient_feature_metadata;

        return $this;
    }

    /**
     * Gets recipient_id
     *
     * @return ?string
     */
    public function getRecipientId()
    {
        return $this->container['recipient_id'];
    }

    /**
     * Sets recipient_id
     *
     * @param ?string $recipient_id Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.
     *
     * @return $this
     */
    public function setRecipientId($recipient_id)
    {
        $this->container['recipient_id'] = $recipient_id;

        return $this;
    }

    /**
     * Gets recipient_id_guid
     *
     * @return ?string
     */
    public function getRecipientIdGuid()
    {
        return $this->container['recipient_id_guid'];
    }

    /**
     * Sets recipient_id_guid
     *
     * @param ?string $recipient_id_guid 
     *
     * @return $this
     */
    public function setRecipientIdGuid($recipient_id_guid)
    {
        $this->container['recipient_id_guid'] = $recipient_id_guid;

        return $this;
    }

    /**
     * Gets recipient_type
     *
     * @return ?string
     */
    public function getRecipientType()
    {
        return $this->container['recipient_type'];
    }

    /**
     * Sets recipient_type
     *
     * @param ?string $recipient_type 
     *
     * @return $this
     */
    public function setRecipientType($recipient_type)
    {
        $this->container['recipient_type'] = $recipient_type;

        return $this;
    }

    /**
     * Gets recipient_type_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getRecipientTypeMetadata()
    {
        return $this->container['recipient_type_metadata'];
    }

    /**
     * Sets recipient_type_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $recipient_type_metadata Metadata that indicates whether the `recipientType` property is editable. This property is read-only.
     *
     * @return $this
     */
    public function setRecipientTypeMetadata($recipient_type_metadata)
    {
        $this->container['recipient_type_metadata'] = $recipient_type_metadata;

        return $this;
    }

    /**
     * Gets require_id_lookup
     *
     * @return ?string
     */
    public function getRequireIdLookup()
    {
        return $this->container['require_id_lookup'];
    }

    /**
     * Sets require_id_lookup
     *
     * @param ?string $require_id_lookup When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity.
     *
     * @return $this
     */
    public function setRequireIdLookup($require_id_lookup)
    {
        $this->container['require_id_lookup'] = $require_id_lookup;

        return $this;
    }

    /**
     * Gets require_id_lookup_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getRequireIdLookupMetadata()
    {
        return $this->container['require_id_lookup_metadata'];
    }

    /**
     * Sets require_id_lookup_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $require_id_lookup_metadata Metadata that indicates whether the `requireIdLookup` property is editable. This property is read-only.
     *
     * @return $this
     */
    public function setRequireIdLookupMetadata($require_id_lookup_metadata)
    {
        $this->container['require_id_lookup_metadata'] = $require_id_lookup_metadata;

        return $this;
    }

    /**
     * Gets role_name
     *
     * @return ?string
     */
    public function getRoleName()
    {
        return $this->container['role_name'];
    }

    /**
     * Sets role_name
     *
     * @param ?string $role_name Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.
     *
     * @return $this
     */
    public function setRoleName($role_name)
    {
        $this->container['role_name'] = $role_name;

        return $this;
    }

    /**
     * Gets routing_order
     *
     * @return ?string
     */
    public function getRoutingOrder()
    {
        return $this->container['routing_order'];
    }

    /**
     * Sets routing_order
     *
     * @param ?string $routing_order Specifies the routing order of the recipient in the envelope.
     *
     * @return $this
     */
    public function setRoutingOrder($routing_order)
    {
        $this->container['routing_order'] = $routing_order;

        return $this;
    }

    /**
     * Gets routing_order_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getRoutingOrderMetadata()
    {
        return $this->container['routing_order_metadata'];
    }

    /**
     * Sets routing_order_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $routing_order_metadata Metadata that indicates whether the `routingOrder` property is editable. This property is read-only.
     *
     * @return $this
     */
    public function setRoutingOrderMetadata($routing_order_metadata)
    {
        $this->container['routing_order_metadata'] = $routing_order_metadata;

        return $this;
    }

    /**
     * Gets sent_date_time
     *
     * @return ?string
     */
    public function getSentDateTime()
    {
        return $this->container['sent_date_time'];
    }

    /**
     * Sets sent_date_time
     *
     * @param ?string $sent_date_time The date and time the envelope was sent.
     *
     * @return $this
     */
    public function setSentDateTime($sent_date_time)
    {
        $this->container['sent_date_time'] = $sent_date_time;

        return $this;
    }

    /**
     * Gets signed_date_time
     *
     * @return ?string
     */
    public function getSignedDateTime()
    {
        return $this->container['signed_date_time'];
    }

    /**
     * Sets signed_date_time
     *
     * @param ?string $signed_date_time Reserved: For DocuSign use only.
     *
     * @return $this
     */
    public function setSignedDateTime($signed_date_time)
    {
        $this->container['signed_date_time'] = $signed_date_time;

        return $this;
    }

    /**
     * Gets signing_group_id
     *
     * @return ?string
     */
    public function getSigningGroupId()
    {
        return $this->container['signing_group_id'];
    }

    /**
     * Sets signing_group_id
     *
     * @param ?string $signing_group_id When set to **true** and the feature is enabled in the sender's account, the signing recipient is required to draw signatures and initials at each signature/initial tab ( instead of adopting a signature/initial style or only drawing a signature/initial once).
     *
     * @return $this
     */
    public function setSigningGroupId($signing_group_id)
    {
        $this->container['signing_group_id'] = $signing_group_id;

        return $this;
    }

    /**
     * Gets signing_group_id_metadata
     *
     * @return \DocuSign\eSign\Model\PropertyMetadata
     */
    public function getSigningGroupIdMetadata()
    {
        return $this->container['signing_group_id_metadata'];
    }

    /**
     * Sets signing_group_id_metadata
     *
     * @param \DocuSign\eSign\Model\PropertyMetadata $signing_group_id_metadata Metadata that indicates whether the `signingGroupId` property is editable. This property is read-only.
     *
     * @return $this
     */
    public function setSigningGroupIdMetadata($signing_group_id_metadata)
    {
        $this->container['signing_group_id_metadata'] = $signing_group_id_metadata;

        return $this;
    }

    /**
     * Gets signing_group_name
     *
     * @return ?string
     */
    public function getSigningGroupName()
    {
        return $this->container['signing_group_name'];
    }

    /**
     * Sets signing_group_name
     *
     * @param ?string $signing_group_name The display name for the signing group.   Maximum Length: 100 characters.
     *
     * @return $this
     */
    public function setSigningGroupName($signing_group_name)
    {
        $this->container['signing_group_name'] = $signing_group_name;

        return $this;
    }

    /**
     * Gets signing_group_users
     *
     * @return \DocuSign\eSign\Model\UserInfo[]
     */
    public function getSigningGroupUsers()
    {
        return $this->container['signing_group_users'];
    }

    /**
     * Sets signing_group_users
     *
     * @param \DocuSign\eSign\Model\UserInfo[] $signing_group_users A complex type that contains information about users in the signing group.
     *
     * @return $this
     */
    public function setSigningGroupUsers($signing_group_users)
    {
        $this->container['signing_group_users'] = $signing_group_users;

        return $this;
    }

    /**
     * Gets sms_authentication
     *
     * @return \DocuSign\eSign\Model\RecipientSMSAuthentication
     */
    public function getSmsAuthentication()
    {
        return $this->container['sms_authentication'];
    }

    /**
     * Sets sms_authentication
     *
     * @param \DocuSign\eSign\Model\RecipientSMSAuthentication $sms_authentication When `idCheckConfigurationName` is set to `SMS Auth $`, you use this complex type to provide the recipient authentication method details. It contains the element `senderProvidedNumbers`, which is an array of phone numbers that the recipient can use for SMS text authentication.
     *
     * @return $this
     */
    public function setSmsAuthentication($sms_authentication)
    {
        $this->container['sms_authentication'] = $sms_authentication;

        return $this;
    }

    /**
     * Gets social_authentications
     *
     * @return \DocuSign\eSign\Model\SocialAuthentication[]
     */
    public function getSocialAuthentications()
    {
        return $this->container['social_authentications'];
    }

    /**
     * Sets social_authentications
     *
     * @param \DocuSign\eSign\Model\SocialAuthentication[] $social_authentications Lists the social ID type that can be used for recipient authentication.
     *
     * @return $this
     */
    public function setSocialAuthentications($social_authentications)
    {
        $this->container['social_authentications'] = $social_authentications;

        return $this;
    }

    /**
     * Gets status
     *
     * @return ?string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param ?string $status Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets status_code
     *
     * @return ?string
     */
    public function getStatusCode()
    {
        return $this->container['status_code'];
    }

    /**
     * Sets status_code
     *
     * @param ?string $status_code 
     *
     * @return $this
     */
    public function setStatusCode($status_code)
    {
        $this->container['status_code'] = $status_code;

        return $this;
    }

    /**
     * Gets suppress_emails
     *
     * @return ?string
     */
    public function getSuppressEmails()
    {
        return $this->container['suppress_emails'];
    }

    /**
     * Sets suppress_emails
     *
     * @param ?string $suppress_emails 
     *
     * @return $this
     */
    public function setSuppressEmails($suppress_emails)
    {
        $this->container['suppress_emails'] = $suppress_emails;

        return $this;
    }

    /**
     * Gets template_locked
     *
     * @return ?string
     */
    public function getTemplateLocked()
    {
        return $this->container['template_locked'];
    }

    /**
     * Sets template_locked
     *
     * @param ?string $template_locked When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients.
     *
     * @return $this
     */
    public function setTemplateLocked($template_locked)
    {
        $this->container['template_locked'] = $template_locked;

        return $this;
    }

    /**
     * Gets template_required
     *
     * @return ?string
     */
    public function getTemplateRequired()
    {
        return $this->container['template_required'];
    }

    /**
     * Sets template_required
     *
     * @param ?string $template_required When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.
     *
     * @return $this
     */
    public function setTemplateRequired($template_required)
    {
        $this->container['template_required'] = $template_required;

        return $this;
    }

    /**
     * Gets total_tab_count
     *
     * @return ?string
     */
    public function getTotalTabCount()
    {
        return $this->container['total_tab_count'];
    }

    /**
     * Sets total_tab_count
     *
     * @param ?string $total_tab_count 
     *
     * @return $this
     */
    public function setTotalTabCount($total_tab_count)
    {
        $this->container['total_tab_count'] = $total_tab_count;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return ?string
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * @param ?string $user_id 
     *
     * @return $this
     */
    public function setUserId($user_id)
    {
        $this->container['user_id'] = $user_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

