<!-- meta tags and other links -->
<!DOCTYPE html>
<html lang="en" data-theme="light">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Texas Client Potal</title>
  <link rel="icon" type="image/png" href="<?php echo base_url()?>assets/assets/images/favicon.png" sizes="16x16">
  <!-- remix icon font css  -->
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/remixicon.css">
  <!-- BootStrap css -->
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/lib/bootstrap.min.css">
  <!-- Apex Chart css -->
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/lib/apexcharts.css">
  <!-- Data Table css -->
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/lib/dataTables.min.css">
  <!-- Text Editor css -->
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/lib/editor-katex.min.css">
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/lib/editor.atom-one-dark.min.css">
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/lib/editor.quill.snow.css">
  <!-- Date picker css -->
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/lib/flatpickr.min.css">
  <!-- Calendar css -->
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/lib/full-calendar.css">
  <!-- Vector Map css -->
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/lib/jquery-jvectormap-2.0.5.css">
  <!-- Popup css -->
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/lib/magnific-popup.css">
  <!-- Slick Slider css -->
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/lib/slick.css">
  <!-- prism css -->
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/lib/prism.css">
  <!-- file upload css -->
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/lib/file-upload.css">
  
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/lib/audioplayer.css">
  <!-- main css -->
  <link rel="stylesheet" href="<?php echo base_url()?>assets/assets/css/style.css">
  
  <style>
      button, input, optgroup, select, textarea {
    -webkit-appearance: auto;
    appearance: auto;
      }
     .sidebar:not(.active) .sidebar-logo {
    height: 9.5rem;
      }
      .sidebar:not(.active) .sidebar-logo img {
    max-height: 8.4375rem;
}
  </style>
</head>
  <body>
<aside class="sidebar">
  <button type="button" class="sidebar-close-btn">
    <iconify-icon icon="radix-icons:cross-2"></iconify-icon>
  </button>
  <div>
    <a href="index.html" class="sidebar-logo justify-content-center">
      <img src="<?php echo base_url()?>assets/assets/images/logo.png" alt="site logo" class="light-logo">
      <img src="<?php echo base_url()?>assets/assets/images/logo.png" alt="site logo" class="dark-logo">
      <img src="<?php echo base_url()?>assets/assets/images/logo-icon.png" alt="site logo" class="logo-icon">
    </a>
  </div>


<?php
$hrmaccess = "no";
$propertyaccess = "no";

// Get session and database connection
$session = session();
$db = \Config\Database::connect();

if ($session->get('user_type') != 'admin') { 
    // Query to get access data for the logged-in user
    $builder = $db->table('tbl_employees');
    $access = $builder->where('id', $session->get('user_id'))->get()->getRow();

    if ($access && $access->hrm_access == 0) {
        $hrmaccess = "no";
    }
    if ($access && $access->property_access == 0) {
        $propertyaccess = "no";
    }
}
?>

  <div class="sidebar-menu-area">
   <ul class="sidebar-menu" id="sidebar-menu">
    <li>
        <a href="<?= base_url('home'); ?>">
            <iconify-icon icon="solar:home-smile-angle-outline" class="menu-icon"></iconify-icon>
            <span>Dashboard</span>
        </a>
    </li>
<?php if($hrmaccess == "yes"){ ?>
    <li class="dropdown active">
        <a href="javascript:void(0)">
            <iconify-icon icon="hugeicons:user" class="menu-icon"></iconify-icon>
            <span>HRMS</span>
        </a>
        <ul class="sidebar-submenu">
            <?php if (session()->get('user_type') === 'admin') { ?>
            <li><a href="<?= base_url('home/employees'); ?>"><i class="ri-circle-fill circle-icon text-primary-600 w-auto"></i> Employees</a></li>
            <li><a href="<?= base_url('home/timesheet'); ?>"><i class="ri-circle-fill circle-icon text-warning-main w-auto"></i> Time Sheet</a></li>
            <?php } ?>
            <li><a href="<?= base_url('home/sslips'); ?>"><i class="ri-circle-fill circle-icon text-info-main w-auto"></i> Salary Slips</a></li>
            <?php if (session()->get('user_type') === 'admin') { ?>
            <li><a href="<?= base_url('home/leaveslist'); ?>"><i class="ri-circle-fill circle-icon text-danger-main w-auto"></i> Leaves</a></li>
            <?php }else{ ?>
            <li><a href="<?= base_url('home/leaves'); ?>"><i class="ri-circle-fill circle-icon text-danger-main w-auto"></i> Leaves</a></li>
            <?php } ?>
            <li><a href="<?= base_url('home/reports'); ?>"><i class="ri-circle-fill circle-icon text-success-main w-auto"></i> Work Reports</a></li>
        </ul>
    </li>
<?php } ?>

<?php if($propertyaccess == "yes"){ ?>
    <li class="dropdown">
        <a href="javascript:void(0)">
            <iconify-icon icon="mingcute:storage-line" class="menu-icon"></iconify-icon>
            <span>Property Management</span>
        </a>
        <ul class="sidebar-submenu">
            <li><a href="<?= base_url('home/leases'); ?>"><i class="ri-circle-fill circle-icon text-primary-600 w-auto"></i> Leases</a></li>
            <li><a href="<?= base_url('home/extensions'); ?>"><i class="ri-circle-fill circle-icon text-warning-main w-auto"></i> Extensions</a></li>
            <li><a href="<?= base_url('home/listings'); ?>"><i class="ri-circle-fill circle-icon text-info-main w-auto"></i> Listing Status</a></li>
        </ul>
    </li>
<?php } ?>

    <!--<li>-->
    <!--    <a href="<?= base_url('home/payments'); ?>">-->
    <!--        <iconify-icon icon="hugeicons:money-send-square" class="menu-icon"></iconify-icon>-->
    <!--        <span>Payments</span>-->
    <!--    </a>-->
    <!--</li>-->

    <li>
        <a href="<?= base_url('home/leasedocuments'); ?>">
            <iconify-icon icon="heroicons:document" class="menu-icon"></iconify-icon>
            <span>Lease Documents</span>
        </a>
    </li>
</ul>

  </div>
</aside>

<main class="dashboard-main">
  <div class="navbar-header">
  <div class="row align-items-center justify-content-between">
    <div class="col-auto">
      <div class="d-flex flex-wrap align-items-center gap-4">
        <button type="button" class="sidebar-toggle">
          <iconify-icon icon="heroicons:bars-3-solid" class="icon text-2xl non-active"></iconify-icon>
          <iconify-icon icon="iconoir:arrow-right" class="icon text-2xl active"></iconify-icon>
        </button>
        <button type="button" class="sidebar-mobile-toggle">
          <iconify-icon icon="heroicons:bars-3-solid" class="icon"></iconify-icon>
        </button>
        <!--<form class="navbar-search">-->
        <!--  <input type="text" name="search" placeholder="Search">-->
        <!--  <iconify-icon icon="ion:search-outline" class="icon"></iconify-icon>-->
        <!--</form>-->
      </div>
    </div>
    <div class="col-auto">
      <div class="d-flex flex-wrap align-items-center gap-3">
        <button type="button" data-theme-toggle class="w-40-px h-40-px bg-neutral-200 rounded-circle d-flex justify-content-center align-items-center"></button>
        
<?php
$session = session();
$eid = $session->get('user_id');

$db = \Config\Database::connect();
$builder = $db->table('notifications');

// Query to get unread notifications
$notifications = $builder->where('status', 'unread')
                         ->where('eid', $eid)
                         ->orderBy('id', 'DESC')
                         ->get()
                         ->getResultArray();

// Get the count of unread notifications
$notifications_count = $db->table('notifications')
                          ->where('status', 'unread')
                          ->where('eid', $eid)
                          ->countAllResults();
?>

        

        <div class="dropdown d-none">
          <button class="has-indicator w-40-px h-40-px bg-neutral-200 rounded-circle d-flex justify-content-center align-items-center" type="button" data-bs-toggle="dropdown">
            <iconify-icon icon="iconoir:bell" class="text-primary-light text-xl"></iconify-icon>
          </button>
          <div class="dropdown-menu to-top dropdown-menu-lg p-0">
              <?php if (isset($notifications) && count($notifications) == 0): ?>
            <div class="m-16 py-12 px-16 radius-8 bg-primary-50 mb-16 d-flex align-items-center justify-content-between gap-2">
              <div>
                <h6 class="text-lg text-primary-light fw-semibold mb-0">No Notifications Available</h6>
              </div>
            </div>
            <?php endif; ?>
            
           <div class="max-h-400-px overflow-y-auto scroll-sm pe-4">
           <?php foreach ($notifications as $notification): ?>
            <a href="javascript:void(0)" class="px-24 py-12 d-flex align-items-center gap-3 mb-2 justify-content-between border-bottom rounded-pill">
              <div class="text-black hover-bg-transparent hover-text-primary d-flex align-items-center gap-3"> 
                
                <div>
                  <h6 class="text-md fw-semibold mb-4"></h6>
                  <p class="mb-0 text-sm text-secondary-light "><?php echo $notification['message']; ?></p>
                </div>
              </div>
              <div class="d-flex flex-column align-items-end"> 
                <button class="btn-close me-2 m-auto" type="button" data-bs-dismiss="toast" 
        aria-label="Close" data-id="<?= $notification['id'] ?>" onclick="markAsRead(this)"> <iconify-icon icon="radix-icons:cross-2"></iconify-icon>
</button>
              </div>
            </a>
            <?php endforeach; ?>
           </div>


          </div>
        </div><!-- Notification dropdown end -->

<?php
$session = session();
$db = \Config\Database::connect();

if ($session->get('user_type') == 'client') {
$builder = $db->table('codeigniter_register');
$userdata = $builder->where('id', $session->get('user_id'))
                    ->get()
                    ->getRowArray();
                    
    $username  = $userdata['name'];
    $initial = strtoupper(substr($username, 0, 1)); 
 }
?>

        <div class="dropdown">
          <button class="d-flex justify-content-center align-items-center bg-neutral-200 rounded-circle" type="button" data-bs-toggle="dropdown">
            <b alt="image" class="d-flex justify-content-center align-items-center w-40-px h-40-px object-fit-cover rounded-circle"><?=$initial?></b>
            
          </button>
          <div class="dropdown-menu to-top dropdown-menu-sm">
            <div class="py-12 px-16 radius-8 bg-primary-50 mb-16 d-flex align-items-center justify-content-between gap-2">
              <div>
                <h6 class="text-lg text-primary-light fw-semibold mb-2"><?= $username; ?></h6>
                <span class="text-secondary-light fw-medium text-sm"><?= $session->get('user_type'); ?></span>
              </div>
              <button type="button" class="hover-text-danger">
                <iconify-icon icon="radix-icons:cross-1" class="icon text-xl"></iconify-icon> 
              </button>
            </div>
            <ul class="to-top-list">
              <!--<li>-->
              <!--  <a class="dropdown-item text-black px-0 py-8 hover-bg-transparent hover-text-primary d-flex align-items-center gap-3" href="view-profile.html"> -->
              <!--  <iconify-icon icon="solar:user-linear" class="icon text-xl"></iconify-icon>  My Profile</a>-->
              <!--</li>-->
              <!--<li>-->
              <!--  <a class="dropdown-item text-black px-0 py-8 hover-bg-transparent hover-text-primary d-flex align-items-center gap-3" href="company.html"> -->
              <!--  <iconify-icon icon="icon-park-outline:setting-two" class="icon text-xl"></iconify-icon>  Setting</a>-->
              <!--</li>-->
              <li>
                <a class="dropdown-item text-black px-0 py-8 hover-bg-transparent hover-text-danger d-flex align-items-center gap-3" href="<?= base_url('home/logout'); ?>"> 
                <iconify-icon icon="lucide:power" class="icon text-xl"></iconify-icon>  Log Out</a>
              </li>
            </ul>
          </div>
        </div><!-- Profile dropdown end -->
      </div>
    </div>
  </div>
</div> 