<?php
/**
 * UserProfile
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Docusign eSignature REST API
 *
 * The Docusign eSignature REST API provides you with a powerful, convenient, and simple Web services API for interacting with Docusign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * UserProfile Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The Docusign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserProfile implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'userProfile';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'address' => '\DocuSign\eSign\Model\AddressInformation',
        'authentication_methods' => '\DocuSign\eSign\Model\AuthenticationMethod[]',
        'company_name' => '?string',
        'display_organization_info' => '?string',
        'display_personal_info' => '?string',
        'display_profile' => '?string',
        'display_usage_history' => '?string',
        'profile_image_uri' => '?string',
        'title' => '?string',
        'usage_history' => '\DocuSign\eSign\Model\UsageHistory',
        'user_details' => '\DocuSign\eSign\Model\UserInformation',
        'user_profile_last_modified_date' => '?string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'address' => null,
        'authentication_methods' => null,
        'company_name' => null,
        'display_organization_info' => null,
        'display_personal_info' => null,
        'display_profile' => null,
        'display_usage_history' => null,
        'profile_image_uri' => null,
        'title' => null,
        'usage_history' => null,
        'user_details' => null,
        'user_profile_last_modified_date' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'address' => 'address',
        'authentication_methods' => 'authenticationMethods',
        'company_name' => 'companyName',
        'display_organization_info' => 'displayOrganizationInfo',
        'display_personal_info' => 'displayPersonalInfo',
        'display_profile' => 'displayProfile',
        'display_usage_history' => 'displayUsageHistory',
        'profile_image_uri' => 'profileImageUri',
        'title' => 'title',
        'usage_history' => 'usageHistory',
        'user_details' => 'userDetails',
        'user_profile_last_modified_date' => 'userProfileLastModifiedDate'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'address' => 'setAddress',
        'authentication_methods' => 'setAuthenticationMethods',
        'company_name' => 'setCompanyName',
        'display_organization_info' => 'setDisplayOrganizationInfo',
        'display_personal_info' => 'setDisplayPersonalInfo',
        'display_profile' => 'setDisplayProfile',
        'display_usage_history' => 'setDisplayUsageHistory',
        'profile_image_uri' => 'setProfileImageUri',
        'title' => 'setTitle',
        'usage_history' => 'setUsageHistory',
        'user_details' => 'setUserDetails',
        'user_profile_last_modified_date' => 'setUserProfileLastModifiedDate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'address' => 'getAddress',
        'authentication_methods' => 'getAuthenticationMethods',
        'company_name' => 'getCompanyName',
        'display_organization_info' => 'getDisplayOrganizationInfo',
        'display_personal_info' => 'getDisplayPersonalInfo',
        'display_profile' => 'getDisplayProfile',
        'display_usage_history' => 'getDisplayUsageHistory',
        'profile_image_uri' => 'getProfileImageUri',
        'title' => 'getTitle',
        'usage_history' => 'getUsageHistory',
        'user_details' => 'getUserDetails',
        'user_profile_last_modified_date' => 'getUserProfileLastModifiedDate'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['authentication_methods'] = isset($data['authentication_methods']) ? $data['authentication_methods'] : null;
        $this->container['company_name'] = isset($data['company_name']) ? $data['company_name'] : null;
        $this->container['display_organization_info'] = isset($data['display_organization_info']) ? $data['display_organization_info'] : null;
        $this->container['display_personal_info'] = isset($data['display_personal_info']) ? $data['display_personal_info'] : null;
        $this->container['display_profile'] = isset($data['display_profile']) ? $data['display_profile'] : null;
        $this->container['display_usage_history'] = isset($data['display_usage_history']) ? $data['display_usage_history'] : null;
        $this->container['profile_image_uri'] = isset($data['profile_image_uri']) ? $data['profile_image_uri'] : null;
        $this->container['title'] = isset($data['title']) ? $data['title'] : null;
        $this->container['usage_history'] = isset($data['usage_history']) ? $data['usage_history'] : null;
        $this->container['user_details'] = isset($data['user_details']) ? $data['user_details'] : null;
        $this->container['user_profile_last_modified_date'] = isset($data['user_profile_last_modified_date']) ? $data['user_profile_last_modified_date'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets address
     *
     * @return \DocuSign\eSign\Model\AddressInformation
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     *
     * @param \DocuSign\eSign\Model\AddressInformation $address The user's address.
     *
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets authentication_methods
     *
     * @return \DocuSign\eSign\Model\AuthenticationMethod[]
     */
    public function getAuthenticationMethods()
    {
        return $this->container['authentication_methods'];
    }

    /**
     * Sets authentication_methods
     *
     * @param \DocuSign\eSign\Model\AuthenticationMethod[] $authentication_methods These properties cannot be modified in the PUT.   Indicates the authentication methods used by the user.
     *
     * @return $this
     */
    public function setAuthenticationMethods($authentication_methods)
    {
        $this->container['authentication_methods'] = $authentication_methods;

        return $this;
    }

    /**
     * Gets company_name
     *
     * @return ?string
     */
    public function getCompanyName()
    {
        return $this->container['company_name'];
    }

    /**
     * Sets company_name
     *
     * @param ?string $company_name The name of the user's Company.
     *
     * @return $this
     */
    public function setCompanyName($company_name)
    {
        $this->container['company_name'] = $company_name;

        return $this;
    }

    /**
     * Gets display_organization_info
     *
     * @return ?string
     */
    public function getDisplayOrganizationInfo()
    {
        return $this->container['display_organization_info'];
    }

    /**
     * Sets display_organization_info
     *
     * @param ?string $display_organization_info When set to **true**, the user's company and title information are shown on the ID card.
     *
     * @return $this
     */
    public function setDisplayOrganizationInfo($display_organization_info)
    {
        $this->container['display_organization_info'] = $display_organization_info;

        return $this;
    }

    /**
     * Gets display_personal_info
     *
     * @return ?string
     */
    public function getDisplayPersonalInfo()
    {
        return $this->container['display_personal_info'];
    }

    /**
     * Sets display_personal_info
     *
     * @param ?string $display_personal_info When set to **true**, the user's Address and Phone number are shown on the ID card.
     *
     * @return $this
     */
    public function setDisplayPersonalInfo($display_personal_info)
    {
        $this->container['display_personal_info'] = $display_personal_info;

        return $this;
    }

    /**
     * Gets display_profile
     *
     * @return ?string
     */
    public function getDisplayProfile()
    {
        return $this->container['display_profile'];
    }

    /**
     * Sets display_profile
     *
     * @param ?string $display_profile When set to **true**, the user's ID card can be viewed from signed documents and envelope history.
     *
     * @return $this
     */
    public function setDisplayProfile($display_profile)
    {
        $this->container['display_profile'] = $display_profile;

        return $this;
    }

    /**
     * Gets display_usage_history
     *
     * @return ?string
     */
    public function getDisplayUsageHistory()
    {
        return $this->container['display_usage_history'];
    }

    /**
     * Sets display_usage_history
     *
     * @param ?string $display_usage_history When set to **true**, the user's usage information is shown on the ID card.
     *
     * @return $this
     */
    public function setDisplayUsageHistory($display_usage_history)
    {
        $this->container['display_usage_history'] = $display_usage_history;

        return $this;
    }

    /**
     * Gets profile_image_uri
     *
     * @return ?string
     */
    public function getProfileImageUri()
    {
        return $this->container['profile_image_uri'];
    }

    /**
     * Sets profile_image_uri
     *
     * @param ?string $profile_image_uri 
     *
     * @return $this
     */
    public function setProfileImageUri($profile_image_uri)
    {
        $this->container['profile_image_uri'] = $profile_image_uri;

        return $this;
    }

    /**
     * Gets title
     *
     * @return ?string
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param ?string $title 
     *
     * @return $this
     */
    public function setTitle($title)
    {
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets usage_history
     *
     * @return \DocuSign\eSign\Model\UsageHistory
     */
    public function getUsageHistory()
    {
        return $this->container['usage_history'];
    }

    /**
     * Sets usage_history
     *
     * @param \DocuSign\eSign\Model\UsageHistory $usage_history A complex element consisting of:   - `lastSentDateTime`: The date and time the user last sent an envelope.  - `lastSignedDateTime`: The date and time the user last signed an envelope. - `sentCount`: The number of envelopes the user has sent. - `signedCount`: The number of envelopes the user has signed.
     *
     * @return $this
     */
    public function setUsageHistory($usage_history)
    {
        $this->container['usage_history'] = $usage_history;

        return $this;
    }

    /**
     * Gets user_details
     *
     * @return \DocuSign\eSign\Model\UserInformation
     */
    public function getUserDetails()
    {
        return $this->container['user_details'];
    }

    /**
     * Sets user_details
     *
     * @param \DocuSign\eSign\Model\UserInformation $user_details 
     *
     * @return $this
     */
    public function setUserDetails($user_details)
    {
        $this->container['user_details'] = $user_details;

        return $this;
    }

    /**
     * Gets user_profile_last_modified_date
     *
     * @return ?string
     */
    public function getUserProfileLastModifiedDate()
    {
        return $this->container['user_profile_last_modified_date'];
    }

    /**
     * Sets user_profile_last_modified_date
     *
     * @param ?string $user_profile_last_modified_date 
     *
     * @return $this
     */
    public function setUserProfileLastModifiedDate($user_profile_last_modified_date)
    {
        $this->container['user_profile_last_modified_date'] = $user_profile_last_modified_date;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

