<?php
/**
 * AccountRoleSettings
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Docusign eSignature REST API
 *
 * The Docusign eSignature REST API provides you with a powerful, convenient, and simple Web services API for interacting with Docusign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * AccountRoleSettings Class Doc Comment
 *
 * @category    Class
 * @description This object defines account permissions for users who are associated with the account permission profile.
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The Docusign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AccountRoleSettings implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'accountRoleSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'allow_account_management' => '?string',
        'allow_account_management_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_api_access' => '?string',
        'allow_api_access_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_api_access_to_account' => '?string',
        'allow_api_access_to_account_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_api_sending_on_behalf_of_others' => '?string',
        'allow_api_sending_on_behalf_of_others_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_api_sequential_signing' => '?string',
        'allow_api_sequential_signing_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_auto_tagging' => '?string',
        'allow_auto_tagging_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_bulk_sending' => '?string',
        'allow_bulk_sending_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_docu_sign_desktop_client' => '?string',
        'allow_docu_sign_desktop_client_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allowed_address_book_access' => '?string',
        'allowed_address_book_access_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allowed_clickwraps_access' => '?string',
        'allowed_clickwraps_access_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allowed_orchestration_access' => '?string',
        'allowed_orchestration_access_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allowed_template_access' => '?string',
        'allowed_template_access_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allowed_to_be_envelope_transfer_recipient' => '?string',
        'allowed_to_be_envelope_transfer_recipient_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_envelope_sending' => '?string',
        'allow_envelope_sending_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_e_seal_recipients' => '?string',
        'allow_e_seal_recipients_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_power_forms_admin_to_access_all_power_form_envelopes' => '?string',
        'allow_power_forms_admin_to_access_all_power_form_envelopes_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_senders_to_set_recipient_email_language' => '?string',
        'allow_senders_to_set_recipient_email_language_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_signer_attachments' => '?string',
        'allow_signer_attachments_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_supplemental_documents' => '?string',
        'allow_supplemental_documents_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_tagging_in_send_and_correct' => '?string',
        'allow_tagging_in_send_and_correct_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_transactions' => '?string',
        'allow_transactions_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_vaulting' => '?string',
        'allow_vaulting_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_wet_signing_override' => '?string',
        'allow_wet_signing_override_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_create_transaction' => '?string',
        'can_create_transaction_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_create_workspaces' => '?string',
        'can_create_workspaces_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_delete_documents_in_transaction' => '?string',
        'can_delete_documents_in_transaction_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_delete_transaction' => '?string',
        'can_delete_transaction_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_send_envelopes_via_sms' => '?string',
        'can_send_envelopes_via_sms_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_document_upload' => '?string',
        'disable_document_upload_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_other_actions' => '?string',
        'disable_other_actions_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_api_request_logging' => '?string',
        'enable_api_request_logging_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_key_terms_suggestions_by_document_type' => '?string',
        'enable_key_terms_suggestions_by_document_type_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_recipient_viewing_notifications' => '?string',
        'enable_recipient_viewing_notifications_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_sequential_signing_interface' => '?string',
        'enable_sequential_signing_interface_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_transaction_point_integration' => '?string',
        'enable_transaction_point_integration_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'power_form_role' => '?string',
        'power_form_role_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'receive_completed_self_signed_documents_as_email_links' => '?string',
        'receive_completed_self_signed_documents_as_email_links_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'signing_ui_version_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'supplemental_documents_must_accept' => '?string',
        'supplemental_documents_must_accept_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'supplemental_documents_must_read' => '?string',
        'supplemental_documents_must_read_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'supplemental_documents_must_view' => '?string',
        'supplemental_documents_must_view_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_new_docu_sign_experience_interface' => '?string',
        'use_new_docu_sign_experience_interface_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_new_sending_interface' => '?string',
        'use_new_sending_interface_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'vaulting_mode' => '?string',
        'vaulting_mode_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'web_forms' => '?string',
        'web_forms_metadata' => '\DocuSign\eSign\Model\SettingsMetadata'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'allow_account_management' => null,
        'allow_account_management_metadata' => null,
        'allow_api_access' => null,
        'allow_api_access_metadata' => null,
        'allow_api_access_to_account' => null,
        'allow_api_access_to_account_metadata' => null,
        'allow_api_sending_on_behalf_of_others' => null,
        'allow_api_sending_on_behalf_of_others_metadata' => null,
        'allow_api_sequential_signing' => null,
        'allow_api_sequential_signing_metadata' => null,
        'allow_auto_tagging' => null,
        'allow_auto_tagging_metadata' => null,
        'allow_bulk_sending' => null,
        'allow_bulk_sending_metadata' => null,
        'allow_docu_sign_desktop_client' => null,
        'allow_docu_sign_desktop_client_metadata' => null,
        'allowed_address_book_access' => null,
        'allowed_address_book_access_metadata' => null,
        'allowed_clickwraps_access' => null,
        'allowed_clickwraps_access_metadata' => null,
        'allowed_orchestration_access' => null,
        'allowed_orchestration_access_metadata' => null,
        'allowed_template_access' => null,
        'allowed_template_access_metadata' => null,
        'allowed_to_be_envelope_transfer_recipient' => null,
        'allowed_to_be_envelope_transfer_recipient_metadata' => null,
        'allow_envelope_sending' => null,
        'allow_envelope_sending_metadata' => null,
        'allow_e_seal_recipients' => null,
        'allow_e_seal_recipients_metadata' => null,
        'allow_power_forms_admin_to_access_all_power_form_envelopes' => null,
        'allow_power_forms_admin_to_access_all_power_form_envelopes_metadata' => null,
        'allow_senders_to_set_recipient_email_language' => null,
        'allow_senders_to_set_recipient_email_language_metadata' => null,
        'allow_signer_attachments' => null,
        'allow_signer_attachments_metadata' => null,
        'allow_supplemental_documents' => null,
        'allow_supplemental_documents_metadata' => null,
        'allow_tagging_in_send_and_correct' => null,
        'allow_tagging_in_send_and_correct_metadata' => null,
        'allow_transactions' => null,
        'allow_transactions_metadata' => null,
        'allow_vaulting' => null,
        'allow_vaulting_metadata' => null,
        'allow_wet_signing_override' => null,
        'allow_wet_signing_override_metadata' => null,
        'can_create_transaction' => null,
        'can_create_transaction_metadata' => null,
        'can_create_workspaces' => null,
        'can_create_workspaces_metadata' => null,
        'can_delete_documents_in_transaction' => null,
        'can_delete_documents_in_transaction_metadata' => null,
        'can_delete_transaction' => null,
        'can_delete_transaction_metadata' => null,
        'can_send_envelopes_via_sms' => null,
        'can_send_envelopes_via_sms_metadata' => null,
        'disable_document_upload' => null,
        'disable_document_upload_metadata' => null,
        'disable_other_actions' => null,
        'disable_other_actions_metadata' => null,
        'enable_api_request_logging' => null,
        'enable_api_request_logging_metadata' => null,
        'enable_key_terms_suggestions_by_document_type' => null,
        'enable_key_terms_suggestions_by_document_type_metadata' => null,
        'enable_recipient_viewing_notifications' => null,
        'enable_recipient_viewing_notifications_metadata' => null,
        'enable_sequential_signing_interface' => null,
        'enable_sequential_signing_interface_metadata' => null,
        'enable_transaction_point_integration' => null,
        'enable_transaction_point_integration_metadata' => null,
        'power_form_role' => null,
        'power_form_role_metadata' => null,
        'receive_completed_self_signed_documents_as_email_links' => null,
        'receive_completed_self_signed_documents_as_email_links_metadata' => null,
        'signing_ui_version_metadata' => null,
        'supplemental_documents_must_accept' => null,
        'supplemental_documents_must_accept_metadata' => null,
        'supplemental_documents_must_read' => null,
        'supplemental_documents_must_read_metadata' => null,
        'supplemental_documents_must_view' => null,
        'supplemental_documents_must_view_metadata' => null,
        'use_new_docu_sign_experience_interface' => null,
        'use_new_docu_sign_experience_interface_metadata' => null,
        'use_new_sending_interface' => null,
        'use_new_sending_interface_metadata' => null,
        'vaulting_mode' => null,
        'vaulting_mode_metadata' => null,
        'web_forms' => null,
        'web_forms_metadata' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'allow_account_management' => 'allowAccountManagement',
        'allow_account_management_metadata' => 'allowAccountManagementMetadata',
        'allow_api_access' => 'allowApiAccess',
        'allow_api_access_metadata' => 'allowApiAccessMetadata',
        'allow_api_access_to_account' => 'allowApiAccessToAccount',
        'allow_api_access_to_account_metadata' => 'allowApiAccessToAccountMetadata',
        'allow_api_sending_on_behalf_of_others' => 'allowApiSendingOnBehalfOfOthers',
        'allow_api_sending_on_behalf_of_others_metadata' => 'allowApiSendingOnBehalfOfOthersMetadata',
        'allow_api_sequential_signing' => 'allowApiSequentialSigning',
        'allow_api_sequential_signing_metadata' => 'allowApiSequentialSigningMetadata',
        'allow_auto_tagging' => 'allowAutoTagging',
        'allow_auto_tagging_metadata' => 'allowAutoTaggingMetadata',
        'allow_bulk_sending' => 'allowBulkSending',
        'allow_bulk_sending_metadata' => 'allowBulkSendingMetadata',
        'allow_docu_sign_desktop_client' => 'allowDocuSignDesktopClient',
        'allow_docu_sign_desktop_client_metadata' => 'allowDocuSignDesktopClientMetadata',
        'allowed_address_book_access' => 'allowedAddressBookAccess',
        'allowed_address_book_access_metadata' => 'allowedAddressBookAccessMetadata',
        'allowed_clickwraps_access' => 'allowedClickwrapsAccess',
        'allowed_clickwraps_access_metadata' => 'allowedClickwrapsAccessMetadata',
        'allowed_orchestration_access' => 'allowedOrchestrationAccess',
        'allowed_orchestration_access_metadata' => 'allowedOrchestrationAccessMetadata',
        'allowed_template_access' => 'allowedTemplateAccess',
        'allowed_template_access_metadata' => 'allowedTemplateAccessMetadata',
        'allowed_to_be_envelope_transfer_recipient' => 'allowedToBeEnvelopeTransferRecipient',
        'allowed_to_be_envelope_transfer_recipient_metadata' => 'allowedToBeEnvelopeTransferRecipientMetadata',
        'allow_envelope_sending' => 'allowEnvelopeSending',
        'allow_envelope_sending_metadata' => 'allowEnvelopeSendingMetadata',
        'allow_e_seal_recipients' => 'allowESealRecipients',
        'allow_e_seal_recipients_metadata' => 'allowESealRecipientsMetadata',
        'allow_power_forms_admin_to_access_all_power_form_envelopes' => 'allowPowerFormsAdminToAccessAllPowerFormEnvelopes',
        'allow_power_forms_admin_to_access_all_power_form_envelopes_metadata' => 'allowPowerFormsAdminToAccessAllPowerFormEnvelopesMetadata',
        'allow_senders_to_set_recipient_email_language' => 'allowSendersToSetRecipientEmailLanguage',
        'allow_senders_to_set_recipient_email_language_metadata' => 'allowSendersToSetRecipientEmailLanguageMetadata',
        'allow_signer_attachments' => 'allowSignerAttachments',
        'allow_signer_attachments_metadata' => 'allowSignerAttachmentsMetadata',
        'allow_supplemental_documents' => 'allowSupplementalDocuments',
        'allow_supplemental_documents_metadata' => 'allowSupplementalDocumentsMetadata',
        'allow_tagging_in_send_and_correct' => 'allowTaggingInSendAndCorrect',
        'allow_tagging_in_send_and_correct_metadata' => 'allowTaggingInSendAndCorrectMetadata',
        'allow_transactions' => 'allowTransactions',
        'allow_transactions_metadata' => 'allowTransactionsMetadata',
        'allow_vaulting' => 'allowVaulting',
        'allow_vaulting_metadata' => 'allowVaultingMetadata',
        'allow_wet_signing_override' => 'allowWetSigningOverride',
        'allow_wet_signing_override_metadata' => 'allowWetSigningOverrideMetadata',
        'can_create_transaction' => 'canCreateTransaction',
        'can_create_transaction_metadata' => 'canCreateTransactionMetadata',
        'can_create_workspaces' => 'canCreateWorkspaces',
        'can_create_workspaces_metadata' => 'canCreateWorkspacesMetadata',
        'can_delete_documents_in_transaction' => 'canDeleteDocumentsInTransaction',
        'can_delete_documents_in_transaction_metadata' => 'canDeleteDocumentsInTransactionMetadata',
        'can_delete_transaction' => 'canDeleteTransaction',
        'can_delete_transaction_metadata' => 'canDeleteTransactionMetadata',
        'can_send_envelopes_via_sms' => 'canSendEnvelopesViaSMS',
        'can_send_envelopes_via_sms_metadata' => 'canSendEnvelopesViaSMSMetadata',
        'disable_document_upload' => 'disableDocumentUpload',
        'disable_document_upload_metadata' => 'disableDocumentUploadMetadata',
        'disable_other_actions' => 'disableOtherActions',
        'disable_other_actions_metadata' => 'disableOtherActionsMetadata',
        'enable_api_request_logging' => 'enableApiRequestLogging',
        'enable_api_request_logging_metadata' => 'enableApiRequestLoggingMetadata',
        'enable_key_terms_suggestions_by_document_type' => 'enableKeyTermsSuggestionsByDocumentType',
        'enable_key_terms_suggestions_by_document_type_metadata' => 'enableKeyTermsSuggestionsByDocumentTypeMetadata',
        'enable_recipient_viewing_notifications' => 'enableRecipientViewingNotifications',
        'enable_recipient_viewing_notifications_metadata' => 'enableRecipientViewingNotificationsMetadata',
        'enable_sequential_signing_interface' => 'enableSequentialSigningInterface',
        'enable_sequential_signing_interface_metadata' => 'enableSequentialSigningInterfaceMetadata',
        'enable_transaction_point_integration' => 'enableTransactionPointIntegration',
        'enable_transaction_point_integration_metadata' => 'enableTransactionPointIntegrationMetadata',
        'power_form_role' => 'powerFormRole',
        'power_form_role_metadata' => 'powerFormRoleMetadata',
        'receive_completed_self_signed_documents_as_email_links' => 'receiveCompletedSelfSignedDocumentsAsEmailLinks',
        'receive_completed_self_signed_documents_as_email_links_metadata' => 'receiveCompletedSelfSignedDocumentsAsEmailLinksMetadata',
        'signing_ui_version_metadata' => 'signingUiVersionMetadata',
        'supplemental_documents_must_accept' => 'supplementalDocumentsMustAccept',
        'supplemental_documents_must_accept_metadata' => 'supplementalDocumentsMustAcceptMetadata',
        'supplemental_documents_must_read' => 'supplementalDocumentsMustRead',
        'supplemental_documents_must_read_metadata' => 'supplementalDocumentsMustReadMetadata',
        'supplemental_documents_must_view' => 'supplementalDocumentsMustView',
        'supplemental_documents_must_view_metadata' => 'supplementalDocumentsMustViewMetadata',
        'use_new_docu_sign_experience_interface' => 'useNewDocuSignExperienceInterface',
        'use_new_docu_sign_experience_interface_metadata' => 'useNewDocuSignExperienceInterfaceMetadata',
        'use_new_sending_interface' => 'useNewSendingInterface',
        'use_new_sending_interface_metadata' => 'useNewSendingInterfaceMetadata',
        'vaulting_mode' => 'vaultingMode',
        'vaulting_mode_metadata' => 'vaultingModeMetadata',
        'web_forms' => 'webForms',
        'web_forms_metadata' => 'webFormsMetadata'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'allow_account_management' => 'setAllowAccountManagement',
        'allow_account_management_metadata' => 'setAllowAccountManagementMetadata',
        'allow_api_access' => 'setAllowApiAccess',
        'allow_api_access_metadata' => 'setAllowApiAccessMetadata',
        'allow_api_access_to_account' => 'setAllowApiAccessToAccount',
        'allow_api_access_to_account_metadata' => 'setAllowApiAccessToAccountMetadata',
        'allow_api_sending_on_behalf_of_others' => 'setAllowApiSendingOnBehalfOfOthers',
        'allow_api_sending_on_behalf_of_others_metadata' => 'setAllowApiSendingOnBehalfOfOthersMetadata',
        'allow_api_sequential_signing' => 'setAllowApiSequentialSigning',
        'allow_api_sequential_signing_metadata' => 'setAllowApiSequentialSigningMetadata',
        'allow_auto_tagging' => 'setAllowAutoTagging',
        'allow_auto_tagging_metadata' => 'setAllowAutoTaggingMetadata',
        'allow_bulk_sending' => 'setAllowBulkSending',
        'allow_bulk_sending_metadata' => 'setAllowBulkSendingMetadata',
        'allow_docu_sign_desktop_client' => 'setAllowDocuSignDesktopClient',
        'allow_docu_sign_desktop_client_metadata' => 'setAllowDocuSignDesktopClientMetadata',
        'allowed_address_book_access' => 'setAllowedAddressBookAccess',
        'allowed_address_book_access_metadata' => 'setAllowedAddressBookAccessMetadata',
        'allowed_clickwraps_access' => 'setAllowedClickwrapsAccess',
        'allowed_clickwraps_access_metadata' => 'setAllowedClickwrapsAccessMetadata',
        'allowed_orchestration_access' => 'setAllowedOrchestrationAccess',
        'allowed_orchestration_access_metadata' => 'setAllowedOrchestrationAccessMetadata',
        'allowed_template_access' => 'setAllowedTemplateAccess',
        'allowed_template_access_metadata' => 'setAllowedTemplateAccessMetadata',
        'allowed_to_be_envelope_transfer_recipient' => 'setAllowedToBeEnvelopeTransferRecipient',
        'allowed_to_be_envelope_transfer_recipient_metadata' => 'setAllowedToBeEnvelopeTransferRecipientMetadata',
        'allow_envelope_sending' => 'setAllowEnvelopeSending',
        'allow_envelope_sending_metadata' => 'setAllowEnvelopeSendingMetadata',
        'allow_e_seal_recipients' => 'setAllowESealRecipients',
        'allow_e_seal_recipients_metadata' => 'setAllowESealRecipientsMetadata',
        'allow_power_forms_admin_to_access_all_power_form_envelopes' => 'setAllowPowerFormsAdminToAccessAllPowerFormEnvelopes',
        'allow_power_forms_admin_to_access_all_power_form_envelopes_metadata' => 'setAllowPowerFormsAdminToAccessAllPowerFormEnvelopesMetadata',
        'allow_senders_to_set_recipient_email_language' => 'setAllowSendersToSetRecipientEmailLanguage',
        'allow_senders_to_set_recipient_email_language_metadata' => 'setAllowSendersToSetRecipientEmailLanguageMetadata',
        'allow_signer_attachments' => 'setAllowSignerAttachments',
        'allow_signer_attachments_metadata' => 'setAllowSignerAttachmentsMetadata',
        'allow_supplemental_documents' => 'setAllowSupplementalDocuments',
        'allow_supplemental_documents_metadata' => 'setAllowSupplementalDocumentsMetadata',
        'allow_tagging_in_send_and_correct' => 'setAllowTaggingInSendAndCorrect',
        'allow_tagging_in_send_and_correct_metadata' => 'setAllowTaggingInSendAndCorrectMetadata',
        'allow_transactions' => 'setAllowTransactions',
        'allow_transactions_metadata' => 'setAllowTransactionsMetadata',
        'allow_vaulting' => 'setAllowVaulting',
        'allow_vaulting_metadata' => 'setAllowVaultingMetadata',
        'allow_wet_signing_override' => 'setAllowWetSigningOverride',
        'allow_wet_signing_override_metadata' => 'setAllowWetSigningOverrideMetadata',
        'can_create_transaction' => 'setCanCreateTransaction',
        'can_create_transaction_metadata' => 'setCanCreateTransactionMetadata',
        'can_create_workspaces' => 'setCanCreateWorkspaces',
        'can_create_workspaces_metadata' => 'setCanCreateWorkspacesMetadata',
        'can_delete_documents_in_transaction' => 'setCanDeleteDocumentsInTransaction',
        'can_delete_documents_in_transaction_metadata' => 'setCanDeleteDocumentsInTransactionMetadata',
        'can_delete_transaction' => 'setCanDeleteTransaction',
        'can_delete_transaction_metadata' => 'setCanDeleteTransactionMetadata',
        'can_send_envelopes_via_sms' => 'setCanSendEnvelopesViaSms',
        'can_send_envelopes_via_sms_metadata' => 'setCanSendEnvelopesViaSmsMetadata',
        'disable_document_upload' => 'setDisableDocumentUpload',
        'disable_document_upload_metadata' => 'setDisableDocumentUploadMetadata',
        'disable_other_actions' => 'setDisableOtherActions',
        'disable_other_actions_metadata' => 'setDisableOtherActionsMetadata',
        'enable_api_request_logging' => 'setEnableApiRequestLogging',
        'enable_api_request_logging_metadata' => 'setEnableApiRequestLoggingMetadata',
        'enable_key_terms_suggestions_by_document_type' => 'setEnableKeyTermsSuggestionsByDocumentType',
        'enable_key_terms_suggestions_by_document_type_metadata' => 'setEnableKeyTermsSuggestionsByDocumentTypeMetadata',
        'enable_recipient_viewing_notifications' => 'setEnableRecipientViewingNotifications',
        'enable_recipient_viewing_notifications_metadata' => 'setEnableRecipientViewingNotificationsMetadata',
        'enable_sequential_signing_interface' => 'setEnableSequentialSigningInterface',
        'enable_sequential_signing_interface_metadata' => 'setEnableSequentialSigningInterfaceMetadata',
        'enable_transaction_point_integration' => 'setEnableTransactionPointIntegration',
        'enable_transaction_point_integration_metadata' => 'setEnableTransactionPointIntegrationMetadata',
        'power_form_role' => 'setPowerFormRole',
        'power_form_role_metadata' => 'setPowerFormRoleMetadata',
        'receive_completed_self_signed_documents_as_email_links' => 'setReceiveCompletedSelfSignedDocumentsAsEmailLinks',
        'receive_completed_self_signed_documents_as_email_links_metadata' => 'setReceiveCompletedSelfSignedDocumentsAsEmailLinksMetadata',
        'signing_ui_version_metadata' => 'setSigningUiVersionMetadata',
        'supplemental_documents_must_accept' => 'setSupplementalDocumentsMustAccept',
        'supplemental_documents_must_accept_metadata' => 'setSupplementalDocumentsMustAcceptMetadata',
        'supplemental_documents_must_read' => 'setSupplementalDocumentsMustRead',
        'supplemental_documents_must_read_metadata' => 'setSupplementalDocumentsMustReadMetadata',
        'supplemental_documents_must_view' => 'setSupplementalDocumentsMustView',
        'supplemental_documents_must_view_metadata' => 'setSupplementalDocumentsMustViewMetadata',
        'use_new_docu_sign_experience_interface' => 'setUseNewDocuSignExperienceInterface',
        'use_new_docu_sign_experience_interface_metadata' => 'setUseNewDocuSignExperienceInterfaceMetadata',
        'use_new_sending_interface' => 'setUseNewSendingInterface',
        'use_new_sending_interface_metadata' => 'setUseNewSendingInterfaceMetadata',
        'vaulting_mode' => 'setVaultingMode',
        'vaulting_mode_metadata' => 'setVaultingModeMetadata',
        'web_forms' => 'setWebForms',
        'web_forms_metadata' => 'setWebFormsMetadata'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'allow_account_management' => 'getAllowAccountManagement',
        'allow_account_management_metadata' => 'getAllowAccountManagementMetadata',
        'allow_api_access' => 'getAllowApiAccess',
        'allow_api_access_metadata' => 'getAllowApiAccessMetadata',
        'allow_api_access_to_account' => 'getAllowApiAccessToAccount',
        'allow_api_access_to_account_metadata' => 'getAllowApiAccessToAccountMetadata',
        'allow_api_sending_on_behalf_of_others' => 'getAllowApiSendingOnBehalfOfOthers',
        'allow_api_sending_on_behalf_of_others_metadata' => 'getAllowApiSendingOnBehalfOfOthersMetadata',
        'allow_api_sequential_signing' => 'getAllowApiSequentialSigning',
        'allow_api_sequential_signing_metadata' => 'getAllowApiSequentialSigningMetadata',
        'allow_auto_tagging' => 'getAllowAutoTagging',
        'allow_auto_tagging_metadata' => 'getAllowAutoTaggingMetadata',
        'allow_bulk_sending' => 'getAllowBulkSending',
        'allow_bulk_sending_metadata' => 'getAllowBulkSendingMetadata',
        'allow_docu_sign_desktop_client' => 'getAllowDocuSignDesktopClient',
        'allow_docu_sign_desktop_client_metadata' => 'getAllowDocuSignDesktopClientMetadata',
        'allowed_address_book_access' => 'getAllowedAddressBookAccess',
        'allowed_address_book_access_metadata' => 'getAllowedAddressBookAccessMetadata',
        'allowed_clickwraps_access' => 'getAllowedClickwrapsAccess',
        'allowed_clickwraps_access_metadata' => 'getAllowedClickwrapsAccessMetadata',
        'allowed_orchestration_access' => 'getAllowedOrchestrationAccess',
        'allowed_orchestration_access_metadata' => 'getAllowedOrchestrationAccessMetadata',
        'allowed_template_access' => 'getAllowedTemplateAccess',
        'allowed_template_access_metadata' => 'getAllowedTemplateAccessMetadata',
        'allowed_to_be_envelope_transfer_recipient' => 'getAllowedToBeEnvelopeTransferRecipient',
        'allowed_to_be_envelope_transfer_recipient_metadata' => 'getAllowedToBeEnvelopeTransferRecipientMetadata',
        'allow_envelope_sending' => 'getAllowEnvelopeSending',
        'allow_envelope_sending_metadata' => 'getAllowEnvelopeSendingMetadata',
        'allow_e_seal_recipients' => 'getAllowESealRecipients',
        'allow_e_seal_recipients_metadata' => 'getAllowESealRecipientsMetadata',
        'allow_power_forms_admin_to_access_all_power_form_envelopes' => 'getAllowPowerFormsAdminToAccessAllPowerFormEnvelopes',
        'allow_power_forms_admin_to_access_all_power_form_envelopes_metadata' => 'getAllowPowerFormsAdminToAccessAllPowerFormEnvelopesMetadata',
        'allow_senders_to_set_recipient_email_language' => 'getAllowSendersToSetRecipientEmailLanguage',
        'allow_senders_to_set_recipient_email_language_metadata' => 'getAllowSendersToSetRecipientEmailLanguageMetadata',
        'allow_signer_attachments' => 'getAllowSignerAttachments',
        'allow_signer_attachments_metadata' => 'getAllowSignerAttachmentsMetadata',
        'allow_supplemental_documents' => 'getAllowSupplementalDocuments',
        'allow_supplemental_documents_metadata' => 'getAllowSupplementalDocumentsMetadata',
        'allow_tagging_in_send_and_correct' => 'getAllowTaggingInSendAndCorrect',
        'allow_tagging_in_send_and_correct_metadata' => 'getAllowTaggingInSendAndCorrectMetadata',
        'allow_transactions' => 'getAllowTransactions',
        'allow_transactions_metadata' => 'getAllowTransactionsMetadata',
        'allow_vaulting' => 'getAllowVaulting',
        'allow_vaulting_metadata' => 'getAllowVaultingMetadata',
        'allow_wet_signing_override' => 'getAllowWetSigningOverride',
        'allow_wet_signing_override_metadata' => 'getAllowWetSigningOverrideMetadata',
        'can_create_transaction' => 'getCanCreateTransaction',
        'can_create_transaction_metadata' => 'getCanCreateTransactionMetadata',
        'can_create_workspaces' => 'getCanCreateWorkspaces',
        'can_create_workspaces_metadata' => 'getCanCreateWorkspacesMetadata',
        'can_delete_documents_in_transaction' => 'getCanDeleteDocumentsInTransaction',
        'can_delete_documents_in_transaction_metadata' => 'getCanDeleteDocumentsInTransactionMetadata',
        'can_delete_transaction' => 'getCanDeleteTransaction',
        'can_delete_transaction_metadata' => 'getCanDeleteTransactionMetadata',
        'can_send_envelopes_via_sms' => 'getCanSendEnvelopesViaSms',
        'can_send_envelopes_via_sms_metadata' => 'getCanSendEnvelopesViaSmsMetadata',
        'disable_document_upload' => 'getDisableDocumentUpload',
        'disable_document_upload_metadata' => 'getDisableDocumentUploadMetadata',
        'disable_other_actions' => 'getDisableOtherActions',
        'disable_other_actions_metadata' => 'getDisableOtherActionsMetadata',
        'enable_api_request_logging' => 'getEnableApiRequestLogging',
        'enable_api_request_logging_metadata' => 'getEnableApiRequestLoggingMetadata',
        'enable_key_terms_suggestions_by_document_type' => 'getEnableKeyTermsSuggestionsByDocumentType',
        'enable_key_terms_suggestions_by_document_type_metadata' => 'getEnableKeyTermsSuggestionsByDocumentTypeMetadata',
        'enable_recipient_viewing_notifications' => 'getEnableRecipientViewingNotifications',
        'enable_recipient_viewing_notifications_metadata' => 'getEnableRecipientViewingNotificationsMetadata',
        'enable_sequential_signing_interface' => 'getEnableSequentialSigningInterface',
        'enable_sequential_signing_interface_metadata' => 'getEnableSequentialSigningInterfaceMetadata',
        'enable_transaction_point_integration' => 'getEnableTransactionPointIntegration',
        'enable_transaction_point_integration_metadata' => 'getEnableTransactionPointIntegrationMetadata',
        'power_form_role' => 'getPowerFormRole',
        'power_form_role_metadata' => 'getPowerFormRoleMetadata',
        'receive_completed_self_signed_documents_as_email_links' => 'getReceiveCompletedSelfSignedDocumentsAsEmailLinks',
        'receive_completed_self_signed_documents_as_email_links_metadata' => 'getReceiveCompletedSelfSignedDocumentsAsEmailLinksMetadata',
        'signing_ui_version_metadata' => 'getSigningUiVersionMetadata',
        'supplemental_documents_must_accept' => 'getSupplementalDocumentsMustAccept',
        'supplemental_documents_must_accept_metadata' => 'getSupplementalDocumentsMustAcceptMetadata',
        'supplemental_documents_must_read' => 'getSupplementalDocumentsMustRead',
        'supplemental_documents_must_read_metadata' => 'getSupplementalDocumentsMustReadMetadata',
        'supplemental_documents_must_view' => 'getSupplementalDocumentsMustView',
        'supplemental_documents_must_view_metadata' => 'getSupplementalDocumentsMustViewMetadata',
        'use_new_docu_sign_experience_interface' => 'getUseNewDocuSignExperienceInterface',
        'use_new_docu_sign_experience_interface_metadata' => 'getUseNewDocuSignExperienceInterfaceMetadata',
        'use_new_sending_interface' => 'getUseNewSendingInterface',
        'use_new_sending_interface_metadata' => 'getUseNewSendingInterfaceMetadata',
        'vaulting_mode' => 'getVaultingMode',
        'vaulting_mode_metadata' => 'getVaultingModeMetadata',
        'web_forms' => 'getWebForms',
        'web_forms_metadata' => 'getWebFormsMetadata'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['allow_account_management'] = isset($data['allow_account_management']) ? $data['allow_account_management'] : null;
        $this->container['allow_account_management_metadata'] = isset($data['allow_account_management_metadata']) ? $data['allow_account_management_metadata'] : null;
        $this->container['allow_api_access'] = isset($data['allow_api_access']) ? $data['allow_api_access'] : null;
        $this->container['allow_api_access_metadata'] = isset($data['allow_api_access_metadata']) ? $data['allow_api_access_metadata'] : null;
        $this->container['allow_api_access_to_account'] = isset($data['allow_api_access_to_account']) ? $data['allow_api_access_to_account'] : null;
        $this->container['allow_api_access_to_account_metadata'] = isset($data['allow_api_access_to_account_metadata']) ? $data['allow_api_access_to_account_metadata'] : null;
        $this->container['allow_api_sending_on_behalf_of_others'] = isset($data['allow_api_sending_on_behalf_of_others']) ? $data['allow_api_sending_on_behalf_of_others'] : null;
        $this->container['allow_api_sending_on_behalf_of_others_metadata'] = isset($data['allow_api_sending_on_behalf_of_others_metadata']) ? $data['allow_api_sending_on_behalf_of_others_metadata'] : null;
        $this->container['allow_api_sequential_signing'] = isset($data['allow_api_sequential_signing']) ? $data['allow_api_sequential_signing'] : null;
        $this->container['allow_api_sequential_signing_metadata'] = isset($data['allow_api_sequential_signing_metadata']) ? $data['allow_api_sequential_signing_metadata'] : null;
        $this->container['allow_auto_tagging'] = isset($data['allow_auto_tagging']) ? $data['allow_auto_tagging'] : null;
        $this->container['allow_auto_tagging_metadata'] = isset($data['allow_auto_tagging_metadata']) ? $data['allow_auto_tagging_metadata'] : null;
        $this->container['allow_bulk_sending'] = isset($data['allow_bulk_sending']) ? $data['allow_bulk_sending'] : null;
        $this->container['allow_bulk_sending_metadata'] = isset($data['allow_bulk_sending_metadata']) ? $data['allow_bulk_sending_metadata'] : null;
        $this->container['allow_docu_sign_desktop_client'] = isset($data['allow_docu_sign_desktop_client']) ? $data['allow_docu_sign_desktop_client'] : null;
        $this->container['allow_docu_sign_desktop_client_metadata'] = isset($data['allow_docu_sign_desktop_client_metadata']) ? $data['allow_docu_sign_desktop_client_metadata'] : null;
        $this->container['allowed_address_book_access'] = isset($data['allowed_address_book_access']) ? $data['allowed_address_book_access'] : null;
        $this->container['allowed_address_book_access_metadata'] = isset($data['allowed_address_book_access_metadata']) ? $data['allowed_address_book_access_metadata'] : null;
        $this->container['allowed_clickwraps_access'] = isset($data['allowed_clickwraps_access']) ? $data['allowed_clickwraps_access'] : null;
        $this->container['allowed_clickwraps_access_metadata'] = isset($data['allowed_clickwraps_access_metadata']) ? $data['allowed_clickwraps_access_metadata'] : null;
        $this->container['allowed_orchestration_access'] = isset($data['allowed_orchestration_access']) ? $data['allowed_orchestration_access'] : null;
        $this->container['allowed_orchestration_access_metadata'] = isset($data['allowed_orchestration_access_metadata']) ? $data['allowed_orchestration_access_metadata'] : null;
        $this->container['allowed_template_access'] = isset($data['allowed_template_access']) ? $data['allowed_template_access'] : null;
        $this->container['allowed_template_access_metadata'] = isset($data['allowed_template_access_metadata']) ? $data['allowed_template_access_metadata'] : null;
        $this->container['allowed_to_be_envelope_transfer_recipient'] = isset($data['allowed_to_be_envelope_transfer_recipient']) ? $data['allowed_to_be_envelope_transfer_recipient'] : null;
        $this->container['allowed_to_be_envelope_transfer_recipient_metadata'] = isset($data['allowed_to_be_envelope_transfer_recipient_metadata']) ? $data['allowed_to_be_envelope_transfer_recipient_metadata'] : null;
        $this->container['allow_envelope_sending'] = isset($data['allow_envelope_sending']) ? $data['allow_envelope_sending'] : null;
        $this->container['allow_envelope_sending_metadata'] = isset($data['allow_envelope_sending_metadata']) ? $data['allow_envelope_sending_metadata'] : null;
        $this->container['allow_e_seal_recipients'] = isset($data['allow_e_seal_recipients']) ? $data['allow_e_seal_recipients'] : null;
        $this->container['allow_e_seal_recipients_metadata'] = isset($data['allow_e_seal_recipients_metadata']) ? $data['allow_e_seal_recipients_metadata'] : null;
        $this->container['allow_power_forms_admin_to_access_all_power_form_envelopes'] = isset($data['allow_power_forms_admin_to_access_all_power_form_envelopes']) ? $data['allow_power_forms_admin_to_access_all_power_form_envelopes'] : null;
        $this->container['allow_power_forms_admin_to_access_all_power_form_envelopes_metadata'] = isset($data['allow_power_forms_admin_to_access_all_power_form_envelopes_metadata']) ? $data['allow_power_forms_admin_to_access_all_power_form_envelopes_metadata'] : null;
        $this->container['allow_senders_to_set_recipient_email_language'] = isset($data['allow_senders_to_set_recipient_email_language']) ? $data['allow_senders_to_set_recipient_email_language'] : null;
        $this->container['allow_senders_to_set_recipient_email_language_metadata'] = isset($data['allow_senders_to_set_recipient_email_language_metadata']) ? $data['allow_senders_to_set_recipient_email_language_metadata'] : null;
        $this->container['allow_signer_attachments'] = isset($data['allow_signer_attachments']) ? $data['allow_signer_attachments'] : null;
        $this->container['allow_signer_attachments_metadata'] = isset($data['allow_signer_attachments_metadata']) ? $data['allow_signer_attachments_metadata'] : null;
        $this->container['allow_supplemental_documents'] = isset($data['allow_supplemental_documents']) ? $data['allow_supplemental_documents'] : null;
        $this->container['allow_supplemental_documents_metadata'] = isset($data['allow_supplemental_documents_metadata']) ? $data['allow_supplemental_documents_metadata'] : null;
        $this->container['allow_tagging_in_send_and_correct'] = isset($data['allow_tagging_in_send_and_correct']) ? $data['allow_tagging_in_send_and_correct'] : null;
        $this->container['allow_tagging_in_send_and_correct_metadata'] = isset($data['allow_tagging_in_send_and_correct_metadata']) ? $data['allow_tagging_in_send_and_correct_metadata'] : null;
        $this->container['allow_transactions'] = isset($data['allow_transactions']) ? $data['allow_transactions'] : null;
        $this->container['allow_transactions_metadata'] = isset($data['allow_transactions_metadata']) ? $data['allow_transactions_metadata'] : null;
        $this->container['allow_vaulting'] = isset($data['allow_vaulting']) ? $data['allow_vaulting'] : null;
        $this->container['allow_vaulting_metadata'] = isset($data['allow_vaulting_metadata']) ? $data['allow_vaulting_metadata'] : null;
        $this->container['allow_wet_signing_override'] = isset($data['allow_wet_signing_override']) ? $data['allow_wet_signing_override'] : null;
        $this->container['allow_wet_signing_override_metadata'] = isset($data['allow_wet_signing_override_metadata']) ? $data['allow_wet_signing_override_metadata'] : null;
        $this->container['can_create_transaction'] = isset($data['can_create_transaction']) ? $data['can_create_transaction'] : null;
        $this->container['can_create_transaction_metadata'] = isset($data['can_create_transaction_metadata']) ? $data['can_create_transaction_metadata'] : null;
        $this->container['can_create_workspaces'] = isset($data['can_create_workspaces']) ? $data['can_create_workspaces'] : null;
        $this->container['can_create_workspaces_metadata'] = isset($data['can_create_workspaces_metadata']) ? $data['can_create_workspaces_metadata'] : null;
        $this->container['can_delete_documents_in_transaction'] = isset($data['can_delete_documents_in_transaction']) ? $data['can_delete_documents_in_transaction'] : null;
        $this->container['can_delete_documents_in_transaction_metadata'] = isset($data['can_delete_documents_in_transaction_metadata']) ? $data['can_delete_documents_in_transaction_metadata'] : null;
        $this->container['can_delete_transaction'] = isset($data['can_delete_transaction']) ? $data['can_delete_transaction'] : null;
        $this->container['can_delete_transaction_metadata'] = isset($data['can_delete_transaction_metadata']) ? $data['can_delete_transaction_metadata'] : null;
        $this->container['can_send_envelopes_via_sms'] = isset($data['can_send_envelopes_via_sms']) ? $data['can_send_envelopes_via_sms'] : null;
        $this->container['can_send_envelopes_via_sms_metadata'] = isset($data['can_send_envelopes_via_sms_metadata']) ? $data['can_send_envelopes_via_sms_metadata'] : null;
        $this->container['disable_document_upload'] = isset($data['disable_document_upload']) ? $data['disable_document_upload'] : null;
        $this->container['disable_document_upload_metadata'] = isset($data['disable_document_upload_metadata']) ? $data['disable_document_upload_metadata'] : null;
        $this->container['disable_other_actions'] = isset($data['disable_other_actions']) ? $data['disable_other_actions'] : null;
        $this->container['disable_other_actions_metadata'] = isset($data['disable_other_actions_metadata']) ? $data['disable_other_actions_metadata'] : null;
        $this->container['enable_api_request_logging'] = isset($data['enable_api_request_logging']) ? $data['enable_api_request_logging'] : null;
        $this->container['enable_api_request_logging_metadata'] = isset($data['enable_api_request_logging_metadata']) ? $data['enable_api_request_logging_metadata'] : null;
        $this->container['enable_key_terms_suggestions_by_document_type'] = isset($data['enable_key_terms_suggestions_by_document_type']) ? $data['enable_key_terms_suggestions_by_document_type'] : null;
        $this->container['enable_key_terms_suggestions_by_document_type_metadata'] = isset($data['enable_key_terms_suggestions_by_document_type_metadata']) ? $data['enable_key_terms_suggestions_by_document_type_metadata'] : null;
        $this->container['enable_recipient_viewing_notifications'] = isset($data['enable_recipient_viewing_notifications']) ? $data['enable_recipient_viewing_notifications'] : null;
        $this->container['enable_recipient_viewing_notifications_metadata'] = isset($data['enable_recipient_viewing_notifications_metadata']) ? $data['enable_recipient_viewing_notifications_metadata'] : null;
        $this->container['enable_sequential_signing_interface'] = isset($data['enable_sequential_signing_interface']) ? $data['enable_sequential_signing_interface'] : null;
        $this->container['enable_sequential_signing_interface_metadata'] = isset($data['enable_sequential_signing_interface_metadata']) ? $data['enable_sequential_signing_interface_metadata'] : null;
        $this->container['enable_transaction_point_integration'] = isset($data['enable_transaction_point_integration']) ? $data['enable_transaction_point_integration'] : null;
        $this->container['enable_transaction_point_integration_metadata'] = isset($data['enable_transaction_point_integration_metadata']) ? $data['enable_transaction_point_integration_metadata'] : null;
        $this->container['power_form_role'] = isset($data['power_form_role']) ? $data['power_form_role'] : null;
        $this->container['power_form_role_metadata'] = isset($data['power_form_role_metadata']) ? $data['power_form_role_metadata'] : null;
        $this->container['receive_completed_self_signed_documents_as_email_links'] = isset($data['receive_completed_self_signed_documents_as_email_links']) ? $data['receive_completed_self_signed_documents_as_email_links'] : null;
        $this->container['receive_completed_self_signed_documents_as_email_links_metadata'] = isset($data['receive_completed_self_signed_documents_as_email_links_metadata']) ? $data['receive_completed_self_signed_documents_as_email_links_metadata'] : null;
        $this->container['signing_ui_version_metadata'] = isset($data['signing_ui_version_metadata']) ? $data['signing_ui_version_metadata'] : null;
        $this->container['supplemental_documents_must_accept'] = isset($data['supplemental_documents_must_accept']) ? $data['supplemental_documents_must_accept'] : null;
        $this->container['supplemental_documents_must_accept_metadata'] = isset($data['supplemental_documents_must_accept_metadata']) ? $data['supplemental_documents_must_accept_metadata'] : null;
        $this->container['supplemental_documents_must_read'] = isset($data['supplemental_documents_must_read']) ? $data['supplemental_documents_must_read'] : null;
        $this->container['supplemental_documents_must_read_metadata'] = isset($data['supplemental_documents_must_read_metadata']) ? $data['supplemental_documents_must_read_metadata'] : null;
        $this->container['supplemental_documents_must_view'] = isset($data['supplemental_documents_must_view']) ? $data['supplemental_documents_must_view'] : null;
        $this->container['supplemental_documents_must_view_metadata'] = isset($data['supplemental_documents_must_view_metadata']) ? $data['supplemental_documents_must_view_metadata'] : null;
        $this->container['use_new_docu_sign_experience_interface'] = isset($data['use_new_docu_sign_experience_interface']) ? $data['use_new_docu_sign_experience_interface'] : null;
        $this->container['use_new_docu_sign_experience_interface_metadata'] = isset($data['use_new_docu_sign_experience_interface_metadata']) ? $data['use_new_docu_sign_experience_interface_metadata'] : null;
        $this->container['use_new_sending_interface'] = isset($data['use_new_sending_interface']) ? $data['use_new_sending_interface'] : null;
        $this->container['use_new_sending_interface_metadata'] = isset($data['use_new_sending_interface_metadata']) ? $data['use_new_sending_interface_metadata'] : null;
        $this->container['vaulting_mode'] = isset($data['vaulting_mode']) ? $data['vaulting_mode'] : null;
        $this->container['vaulting_mode_metadata'] = isset($data['vaulting_mode_metadata']) ? $data['vaulting_mode_metadata'] : null;
        $this->container['web_forms'] = isset($data['web_forms']) ? $data['web_forms'] : null;
        $this->container['web_forms_metadata'] = isset($data['web_forms_metadata']) ? $data['web_forms_metadata'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets allow_account_management
     *
     * @return ?string
     */
    public function getAllowAccountManagement()
    {
        return $this->container['allow_account_management'];
    }

    /**
     * Sets allow_account_management
     *
     * @param ?string $allow_account_management 
     *
     * @return $this
     */
    public function setAllowAccountManagement($allow_account_management)
    {
        $this->container['allow_account_management'] = $allow_account_management;

        return $this;
    }

    /**
     * Gets allow_account_management_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowAccountManagementMetadata()
    {
        return $this->container['allow_account_management_metadata'];
    }

    /**
     * Sets allow_account_management_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_account_management_metadata Metadata that indicates whether the `allowAccountManagement` property is editable.
     *
     * @return $this
     */
    public function setAllowAccountManagementMetadata($allow_account_management_metadata)
    {
        $this->container['allow_account_management_metadata'] = $allow_account_management_metadata;

        return $this;
    }

    /**
     * Gets allow_api_access
     *
     * @return ?string
     */
    public function getAllowApiAccess()
    {
        return $this->container['allow_api_access'];
    }

    /**
     * Sets allow_api_access
     *
     * @param ?string $allow_api_access 
     *
     * @return $this
     */
    public function setAllowApiAccess($allow_api_access)
    {
        $this->container['allow_api_access'] = $allow_api_access;

        return $this;
    }

    /**
     * Gets allow_api_access_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowApiAccessMetadata()
    {
        return $this->container['allow_api_access_metadata'];
    }

    /**
     * Sets allow_api_access_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_api_access_metadata Metadata that indicates whether the `allowApiAccess` property is editable.
     *
     * @return $this
     */
    public function setAllowApiAccessMetadata($allow_api_access_metadata)
    {
        $this->container['allow_api_access_metadata'] = $allow_api_access_metadata;

        return $this;
    }

    /**
     * Gets allow_api_access_to_account
     *
     * @return ?string
     */
    public function getAllowApiAccessToAccount()
    {
        return $this->container['allow_api_access_to_account'];
    }

    /**
     * Sets allow_api_access_to_account
     *
     * @param ?string $allow_api_access_to_account 
     *
     * @return $this
     */
    public function setAllowApiAccessToAccount($allow_api_access_to_account)
    {
        $this->container['allow_api_access_to_account'] = $allow_api_access_to_account;

        return $this;
    }

    /**
     * Gets allow_api_access_to_account_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowApiAccessToAccountMetadata()
    {
        return $this->container['allow_api_access_to_account_metadata'];
    }

    /**
     * Sets allow_api_access_to_account_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_api_access_to_account_metadata Metadata that indicates whether the `allowApiAccessToAccount` property is editable.
     *
     * @return $this
     */
    public function setAllowApiAccessToAccountMetadata($allow_api_access_to_account_metadata)
    {
        $this->container['allow_api_access_to_account_metadata'] = $allow_api_access_to_account_metadata;

        return $this;
    }

    /**
     * Gets allow_api_sending_on_behalf_of_others
     *
     * @return ?string
     */
    public function getAllowApiSendingOnBehalfOfOthers()
    {
        return $this->container['allow_api_sending_on_behalf_of_others'];
    }

    /**
     * Sets allow_api_sending_on_behalf_of_others
     *
     * @param ?string $allow_api_sending_on_behalf_of_others 
     *
     * @return $this
     */
    public function setAllowApiSendingOnBehalfOfOthers($allow_api_sending_on_behalf_of_others)
    {
        $this->container['allow_api_sending_on_behalf_of_others'] = $allow_api_sending_on_behalf_of_others;

        return $this;
    }

    /**
     * Gets allow_api_sending_on_behalf_of_others_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowApiSendingOnBehalfOfOthersMetadata()
    {
        return $this->container['allow_api_sending_on_behalf_of_others_metadata'];
    }

    /**
     * Sets allow_api_sending_on_behalf_of_others_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_api_sending_on_behalf_of_others_metadata Metadata that indicates whether the `allowApiSendingOnBehalfOfOthers` property is editable.
     *
     * @return $this
     */
    public function setAllowApiSendingOnBehalfOfOthersMetadata($allow_api_sending_on_behalf_of_others_metadata)
    {
        $this->container['allow_api_sending_on_behalf_of_others_metadata'] = $allow_api_sending_on_behalf_of_others_metadata;

        return $this;
    }

    /**
     * Gets allow_api_sequential_signing
     *
     * @return ?string
     */
    public function getAllowApiSequentialSigning()
    {
        return $this->container['allow_api_sequential_signing'];
    }

    /**
     * Sets allow_api_sequential_signing
     *
     * @param ?string $allow_api_sequential_signing 
     *
     * @return $this
     */
    public function setAllowApiSequentialSigning($allow_api_sequential_signing)
    {
        $this->container['allow_api_sequential_signing'] = $allow_api_sequential_signing;

        return $this;
    }

    /**
     * Gets allow_api_sequential_signing_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowApiSequentialSigningMetadata()
    {
        return $this->container['allow_api_sequential_signing_metadata'];
    }

    /**
     * Sets allow_api_sequential_signing_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_api_sequential_signing_metadata Metadata that indicates whether the `allowApiSequentialSigning` property is editable.
     *
     * @return $this
     */
    public function setAllowApiSequentialSigningMetadata($allow_api_sequential_signing_metadata)
    {
        $this->container['allow_api_sequential_signing_metadata'] = $allow_api_sequential_signing_metadata;

        return $this;
    }

    /**
     * Gets allow_auto_tagging
     *
     * @return ?string
     */
    public function getAllowAutoTagging()
    {
        return $this->container['allow_auto_tagging'];
    }

    /**
     * Sets allow_auto_tagging
     *
     * @param ?string $allow_auto_tagging 
     *
     * @return $this
     */
    public function setAllowAutoTagging($allow_auto_tagging)
    {
        $this->container['allow_auto_tagging'] = $allow_auto_tagging;

        return $this;
    }

    /**
     * Gets allow_auto_tagging_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowAutoTaggingMetadata()
    {
        return $this->container['allow_auto_tagging_metadata'];
    }

    /**
     * Sets allow_auto_tagging_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_auto_tagging_metadata Metadata that indicates whether the `allowAutoTagging` property is editable.
     *
     * @return $this
     */
    public function setAllowAutoTaggingMetadata($allow_auto_tagging_metadata)
    {
        $this->container['allow_auto_tagging_metadata'] = $allow_auto_tagging_metadata;

        return $this;
    }

    /**
     * Gets allow_bulk_sending
     *
     * @return ?string
     */
    public function getAllowBulkSending()
    {
        return $this->container['allow_bulk_sending'];
    }

    /**
     * Sets allow_bulk_sending
     *
     * @param ?string $allow_bulk_sending 
     *
     * @return $this
     */
    public function setAllowBulkSending($allow_bulk_sending)
    {
        $this->container['allow_bulk_sending'] = $allow_bulk_sending;

        return $this;
    }

    /**
     * Gets allow_bulk_sending_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowBulkSendingMetadata()
    {
        return $this->container['allow_bulk_sending_metadata'];
    }

    /**
     * Sets allow_bulk_sending_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_bulk_sending_metadata Metadata that indicates whether the `allowBulkSending` property is editable.
     *
     * @return $this
     */
    public function setAllowBulkSendingMetadata($allow_bulk_sending_metadata)
    {
        $this->container['allow_bulk_sending_metadata'] = $allow_bulk_sending_metadata;

        return $this;
    }

    /**
     * Gets allow_docu_sign_desktop_client
     *
     * @return ?string
     */
    public function getAllowDocuSignDesktopClient()
    {
        return $this->container['allow_docu_sign_desktop_client'];
    }

    /**
     * Sets allow_docu_sign_desktop_client
     *
     * @param ?string $allow_docu_sign_desktop_client 
     *
     * @return $this
     */
    public function setAllowDocuSignDesktopClient($allow_docu_sign_desktop_client)
    {
        $this->container['allow_docu_sign_desktop_client'] = $allow_docu_sign_desktop_client;

        return $this;
    }

    /**
     * Gets allow_docu_sign_desktop_client_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowDocuSignDesktopClientMetadata()
    {
        return $this->container['allow_docu_sign_desktop_client_metadata'];
    }

    /**
     * Sets allow_docu_sign_desktop_client_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_docu_sign_desktop_client_metadata Metadata that indicates whether the `allowDocuSignDesktopClient` property is editable.
     *
     * @return $this
     */
    public function setAllowDocuSignDesktopClientMetadata($allow_docu_sign_desktop_client_metadata)
    {
        $this->container['allow_docu_sign_desktop_client_metadata'] = $allow_docu_sign_desktop_client_metadata;

        return $this;
    }

    /**
     * Gets allowed_address_book_access
     *
     * @return ?string
     */
    public function getAllowedAddressBookAccess()
    {
        return $this->container['allowed_address_book_access'];
    }

    /**
     * Sets allowed_address_book_access
     *
     * @param ?string $allowed_address_book_access 
     *
     * @return $this
     */
    public function setAllowedAddressBookAccess($allowed_address_book_access)
    {
        $this->container['allowed_address_book_access'] = $allowed_address_book_access;

        return $this;
    }

    /**
     * Gets allowed_address_book_access_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowedAddressBookAccessMetadata()
    {
        return $this->container['allowed_address_book_access_metadata'];
    }

    /**
     * Sets allowed_address_book_access_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allowed_address_book_access_metadata Metadata that indicates whether the `allowedAddressBookAccess` property is editable.
     *
     * @return $this
     */
    public function setAllowedAddressBookAccessMetadata($allowed_address_book_access_metadata)
    {
        $this->container['allowed_address_book_access_metadata'] = $allowed_address_book_access_metadata;

        return $this;
    }

    /**
     * Gets allowed_clickwraps_access
     *
     * @return ?string
     */
    public function getAllowedClickwrapsAccess()
    {
        return $this->container['allowed_clickwraps_access'];
    }

    /**
     * Sets allowed_clickwraps_access
     *
     * @param ?string $allowed_clickwraps_access 
     *
     * @return $this
     */
    public function setAllowedClickwrapsAccess($allowed_clickwraps_access)
    {
        $this->container['allowed_clickwraps_access'] = $allowed_clickwraps_access;

        return $this;
    }

    /**
     * Gets allowed_clickwraps_access_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowedClickwrapsAccessMetadata()
    {
        return $this->container['allowed_clickwraps_access_metadata'];
    }

    /**
     * Sets allowed_clickwraps_access_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allowed_clickwraps_access_metadata 
     *
     * @return $this
     */
    public function setAllowedClickwrapsAccessMetadata($allowed_clickwraps_access_metadata)
    {
        $this->container['allowed_clickwraps_access_metadata'] = $allowed_clickwraps_access_metadata;

        return $this;
    }

    /**
     * Gets allowed_orchestration_access
     *
     * @return ?string
     */
    public function getAllowedOrchestrationAccess()
    {
        return $this->container['allowed_orchestration_access'];
    }

    /**
     * Sets allowed_orchestration_access
     *
     * @param ?string $allowed_orchestration_access 
     *
     * @return $this
     */
    public function setAllowedOrchestrationAccess($allowed_orchestration_access)
    {
        $this->container['allowed_orchestration_access'] = $allowed_orchestration_access;

        return $this;
    }

    /**
     * Gets allowed_orchestration_access_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowedOrchestrationAccessMetadata()
    {
        return $this->container['allowed_orchestration_access_metadata'];
    }

    /**
     * Sets allowed_orchestration_access_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allowed_orchestration_access_metadata 
     *
     * @return $this
     */
    public function setAllowedOrchestrationAccessMetadata($allowed_orchestration_access_metadata)
    {
        $this->container['allowed_orchestration_access_metadata'] = $allowed_orchestration_access_metadata;

        return $this;
    }

    /**
     * Gets allowed_template_access
     *
     * @return ?string
     */
    public function getAllowedTemplateAccess()
    {
        return $this->container['allowed_template_access'];
    }

    /**
     * Sets allowed_template_access
     *
     * @param ?string $allowed_template_access 
     *
     * @return $this
     */
    public function setAllowedTemplateAccess($allowed_template_access)
    {
        $this->container['allowed_template_access'] = $allowed_template_access;

        return $this;
    }

    /**
     * Gets allowed_template_access_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowedTemplateAccessMetadata()
    {
        return $this->container['allowed_template_access_metadata'];
    }

    /**
     * Sets allowed_template_access_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allowed_template_access_metadata Metadata that indicates whether the `allowedTemplateAccess` property is editable.
     *
     * @return $this
     */
    public function setAllowedTemplateAccessMetadata($allowed_template_access_metadata)
    {
        $this->container['allowed_template_access_metadata'] = $allowed_template_access_metadata;

        return $this;
    }

    /**
     * Gets allowed_to_be_envelope_transfer_recipient
     *
     * @return ?string
     */
    public function getAllowedToBeEnvelopeTransferRecipient()
    {
        return $this->container['allowed_to_be_envelope_transfer_recipient'];
    }

    /**
     * Sets allowed_to_be_envelope_transfer_recipient
     *
     * @param ?string $allowed_to_be_envelope_transfer_recipient 
     *
     * @return $this
     */
    public function setAllowedToBeEnvelopeTransferRecipient($allowed_to_be_envelope_transfer_recipient)
    {
        $this->container['allowed_to_be_envelope_transfer_recipient'] = $allowed_to_be_envelope_transfer_recipient;

        return $this;
    }

    /**
     * Gets allowed_to_be_envelope_transfer_recipient_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowedToBeEnvelopeTransferRecipientMetadata()
    {
        return $this->container['allowed_to_be_envelope_transfer_recipient_metadata'];
    }

    /**
     * Sets allowed_to_be_envelope_transfer_recipient_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allowed_to_be_envelope_transfer_recipient_metadata Metadata that indicates whether the `allowedToBeEnvelopeTransferRecipient` property is editable.
     *
     * @return $this
     */
    public function setAllowedToBeEnvelopeTransferRecipientMetadata($allowed_to_be_envelope_transfer_recipient_metadata)
    {
        $this->container['allowed_to_be_envelope_transfer_recipient_metadata'] = $allowed_to_be_envelope_transfer_recipient_metadata;

        return $this;
    }

    /**
     * Gets allow_envelope_sending
     *
     * @return ?string
     */
    public function getAllowEnvelopeSending()
    {
        return $this->container['allow_envelope_sending'];
    }

    /**
     * Sets allow_envelope_sending
     *
     * @param ?string $allow_envelope_sending 
     *
     * @return $this
     */
    public function setAllowEnvelopeSending($allow_envelope_sending)
    {
        $this->container['allow_envelope_sending'] = $allow_envelope_sending;

        return $this;
    }

    /**
     * Gets allow_envelope_sending_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowEnvelopeSendingMetadata()
    {
        return $this->container['allow_envelope_sending_metadata'];
    }

    /**
     * Sets allow_envelope_sending_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_envelope_sending_metadata Metadata that indicates whether the `allowEnvelopeSending` property is editable.
     *
     * @return $this
     */
    public function setAllowEnvelopeSendingMetadata($allow_envelope_sending_metadata)
    {
        $this->container['allow_envelope_sending_metadata'] = $allow_envelope_sending_metadata;

        return $this;
    }

    /**
     * Gets allow_e_seal_recipients
     *
     * @return ?string
     */
    public function getAllowESealRecipients()
    {
        return $this->container['allow_e_seal_recipients'];
    }

    /**
     * Sets allow_e_seal_recipients
     *
     * @param ?string $allow_e_seal_recipients 
     *
     * @return $this
     */
    public function setAllowESealRecipients($allow_e_seal_recipients)
    {
        $this->container['allow_e_seal_recipients'] = $allow_e_seal_recipients;

        return $this;
    }

    /**
     * Gets allow_e_seal_recipients_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowESealRecipientsMetadata()
    {
        return $this->container['allow_e_seal_recipients_metadata'];
    }

    /**
     * Sets allow_e_seal_recipients_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_e_seal_recipients_metadata Metadata that indicates whether the `allowESealRecipients` property is editable.
     *
     * @return $this
     */
    public function setAllowESealRecipientsMetadata($allow_e_seal_recipients_metadata)
    {
        $this->container['allow_e_seal_recipients_metadata'] = $allow_e_seal_recipients_metadata;

        return $this;
    }

    /**
     * Gets allow_power_forms_admin_to_access_all_power_form_envelopes
     *
     * @return ?string
     */
    public function getAllowPowerFormsAdminToAccessAllPowerFormEnvelopes()
    {
        return $this->container['allow_power_forms_admin_to_access_all_power_form_envelopes'];
    }

    /**
     * Sets allow_power_forms_admin_to_access_all_power_form_envelopes
     *
     * @param ?string $allow_power_forms_admin_to_access_all_power_form_envelopes 
     *
     * @return $this
     */
    public function setAllowPowerFormsAdminToAccessAllPowerFormEnvelopes($allow_power_forms_admin_to_access_all_power_form_envelopes)
    {
        $this->container['allow_power_forms_admin_to_access_all_power_form_envelopes'] = $allow_power_forms_admin_to_access_all_power_form_envelopes;

        return $this;
    }

    /**
     * Gets allow_power_forms_admin_to_access_all_power_form_envelopes_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowPowerFormsAdminToAccessAllPowerFormEnvelopesMetadata()
    {
        return $this->container['allow_power_forms_admin_to_access_all_power_form_envelopes_metadata'];
    }

    /**
     * Sets allow_power_forms_admin_to_access_all_power_form_envelopes_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_power_forms_admin_to_access_all_power_form_envelopes_metadata Metadata that indicates whether the `allowPowerFormsAdminToAccessAllPowerFormEnvelopes` property is editable.
     *
     * @return $this
     */
    public function setAllowPowerFormsAdminToAccessAllPowerFormEnvelopesMetadata($allow_power_forms_admin_to_access_all_power_form_envelopes_metadata)
    {
        $this->container['allow_power_forms_admin_to_access_all_power_form_envelopes_metadata'] = $allow_power_forms_admin_to_access_all_power_form_envelopes_metadata;

        return $this;
    }

    /**
     * Gets allow_senders_to_set_recipient_email_language
     *
     * @return ?string
     */
    public function getAllowSendersToSetRecipientEmailLanguage()
    {
        return $this->container['allow_senders_to_set_recipient_email_language'];
    }

    /**
     * Sets allow_senders_to_set_recipient_email_language
     *
     * @param ?string $allow_senders_to_set_recipient_email_language 
     *
     * @return $this
     */
    public function setAllowSendersToSetRecipientEmailLanguage($allow_senders_to_set_recipient_email_language)
    {
        $this->container['allow_senders_to_set_recipient_email_language'] = $allow_senders_to_set_recipient_email_language;

        return $this;
    }

    /**
     * Gets allow_senders_to_set_recipient_email_language_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSendersToSetRecipientEmailLanguageMetadata()
    {
        return $this->container['allow_senders_to_set_recipient_email_language_metadata'];
    }

    /**
     * Sets allow_senders_to_set_recipient_email_language_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_senders_to_set_recipient_email_language_metadata Metadata that indicates whether the `allowSendersToSetRecipientEmailLanguage` property is editable.
     *
     * @return $this
     */
    public function setAllowSendersToSetRecipientEmailLanguageMetadata($allow_senders_to_set_recipient_email_language_metadata)
    {
        $this->container['allow_senders_to_set_recipient_email_language_metadata'] = $allow_senders_to_set_recipient_email_language_metadata;

        return $this;
    }

    /**
     * Gets allow_signer_attachments
     *
     * @return ?string
     */
    public function getAllowSignerAttachments()
    {
        return $this->container['allow_signer_attachments'];
    }

    /**
     * Sets allow_signer_attachments
     *
     * @param ?string $allow_signer_attachments 
     *
     * @return $this
     */
    public function setAllowSignerAttachments($allow_signer_attachments)
    {
        $this->container['allow_signer_attachments'] = $allow_signer_attachments;

        return $this;
    }

    /**
     * Gets allow_signer_attachments_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSignerAttachmentsMetadata()
    {
        return $this->container['allow_signer_attachments_metadata'];
    }

    /**
     * Sets allow_signer_attachments_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_signer_attachments_metadata Metadata that indicates whether the `allowSignerAttachments` property is editable.
     *
     * @return $this
     */
    public function setAllowSignerAttachmentsMetadata($allow_signer_attachments_metadata)
    {
        $this->container['allow_signer_attachments_metadata'] = $allow_signer_attachments_metadata;

        return $this;
    }

    /**
     * Gets allow_supplemental_documents
     *
     * @return ?string
     */
    public function getAllowSupplementalDocuments()
    {
        return $this->container['allow_supplemental_documents'];
    }

    /**
     * Sets allow_supplemental_documents
     *
     * @param ?string $allow_supplemental_documents 
     *
     * @return $this
     */
    public function setAllowSupplementalDocuments($allow_supplemental_documents)
    {
        $this->container['allow_supplemental_documents'] = $allow_supplemental_documents;

        return $this;
    }

    /**
     * Gets allow_supplemental_documents_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSupplementalDocumentsMetadata()
    {
        return $this->container['allow_supplemental_documents_metadata'];
    }

    /**
     * Sets allow_supplemental_documents_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_supplemental_documents_metadata Metadata that indicates whether the `allowSupplementalDocuments` property is editable.
     *
     * @return $this
     */
    public function setAllowSupplementalDocumentsMetadata($allow_supplemental_documents_metadata)
    {
        $this->container['allow_supplemental_documents_metadata'] = $allow_supplemental_documents_metadata;

        return $this;
    }

    /**
     * Gets allow_tagging_in_send_and_correct
     *
     * @return ?string
     */
    public function getAllowTaggingInSendAndCorrect()
    {
        return $this->container['allow_tagging_in_send_and_correct'];
    }

    /**
     * Sets allow_tagging_in_send_and_correct
     *
     * @param ?string $allow_tagging_in_send_and_correct 
     *
     * @return $this
     */
    public function setAllowTaggingInSendAndCorrect($allow_tagging_in_send_and_correct)
    {
        $this->container['allow_tagging_in_send_and_correct'] = $allow_tagging_in_send_and_correct;

        return $this;
    }

    /**
     * Gets allow_tagging_in_send_and_correct_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowTaggingInSendAndCorrectMetadata()
    {
        return $this->container['allow_tagging_in_send_and_correct_metadata'];
    }

    /**
     * Sets allow_tagging_in_send_and_correct_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_tagging_in_send_and_correct_metadata Metadata that indicates whether the `allowTaggingInSendAndCorrect` property is editable.
     *
     * @return $this
     */
    public function setAllowTaggingInSendAndCorrectMetadata($allow_tagging_in_send_and_correct_metadata)
    {
        $this->container['allow_tagging_in_send_and_correct_metadata'] = $allow_tagging_in_send_and_correct_metadata;

        return $this;
    }

    /**
     * Gets allow_transactions
     *
     * @return ?string
     */
    public function getAllowTransactions()
    {
        return $this->container['allow_transactions'];
    }

    /**
     * Sets allow_transactions
     *
     * @param ?string $allow_transactions 
     *
     * @return $this
     */
    public function setAllowTransactions($allow_transactions)
    {
        $this->container['allow_transactions'] = $allow_transactions;

        return $this;
    }

    /**
     * Gets allow_transactions_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowTransactionsMetadata()
    {
        return $this->container['allow_transactions_metadata'];
    }

    /**
     * Sets allow_transactions_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_transactions_metadata 
     *
     * @return $this
     */
    public function setAllowTransactionsMetadata($allow_transactions_metadata)
    {
        $this->container['allow_transactions_metadata'] = $allow_transactions_metadata;

        return $this;
    }

    /**
     * Gets allow_vaulting
     *
     * @return ?string
     */
    public function getAllowVaulting()
    {
        return $this->container['allow_vaulting'];
    }

    /**
     * Sets allow_vaulting
     *
     * @param ?string $allow_vaulting 
     *
     * @return $this
     */
    public function setAllowVaulting($allow_vaulting)
    {
        $this->container['allow_vaulting'] = $allow_vaulting;

        return $this;
    }

    /**
     * Gets allow_vaulting_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowVaultingMetadata()
    {
        return $this->container['allow_vaulting_metadata'];
    }

    /**
     * Sets allow_vaulting_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_vaulting_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setAllowVaultingMetadata($allow_vaulting_metadata)
    {
        $this->container['allow_vaulting_metadata'] = $allow_vaulting_metadata;

        return $this;
    }

    /**
     * Gets allow_wet_signing_override
     *
     * @return ?string
     */
    public function getAllowWetSigningOverride()
    {
        return $this->container['allow_wet_signing_override'];
    }

    /**
     * Sets allow_wet_signing_override
     *
     * @param ?string $allow_wet_signing_override 
     *
     * @return $this
     */
    public function setAllowWetSigningOverride($allow_wet_signing_override)
    {
        $this->container['allow_wet_signing_override'] = $allow_wet_signing_override;

        return $this;
    }

    /**
     * Gets allow_wet_signing_override_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowWetSigningOverrideMetadata()
    {
        return $this->container['allow_wet_signing_override_metadata'];
    }

    /**
     * Sets allow_wet_signing_override_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_wet_signing_override_metadata Metadata that indicates whether the `allowWetSigningOverride` property is editable.
     *
     * @return $this
     */
    public function setAllowWetSigningOverrideMetadata($allow_wet_signing_override_metadata)
    {
        $this->container['allow_wet_signing_override_metadata'] = $allow_wet_signing_override_metadata;

        return $this;
    }

    /**
     * Gets can_create_transaction
     *
     * @return ?string
     */
    public function getCanCreateTransaction()
    {
        return $this->container['can_create_transaction'];
    }

    /**
     * Sets can_create_transaction
     *
     * @param ?string $can_create_transaction 
     *
     * @return $this
     */
    public function setCanCreateTransaction($can_create_transaction)
    {
        $this->container['can_create_transaction'] = $can_create_transaction;

        return $this;
    }

    /**
     * Gets can_create_transaction_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanCreateTransactionMetadata()
    {
        return $this->container['can_create_transaction_metadata'];
    }

    /**
     * Sets can_create_transaction_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_create_transaction_metadata 
     *
     * @return $this
     */
    public function setCanCreateTransactionMetadata($can_create_transaction_metadata)
    {
        $this->container['can_create_transaction_metadata'] = $can_create_transaction_metadata;

        return $this;
    }

    /**
     * Gets can_create_workspaces
     *
     * @return ?string
     */
    public function getCanCreateWorkspaces()
    {
        return $this->container['can_create_workspaces'];
    }

    /**
     * Sets can_create_workspaces
     *
     * @param ?string $can_create_workspaces 
     *
     * @return $this
     */
    public function setCanCreateWorkspaces($can_create_workspaces)
    {
        $this->container['can_create_workspaces'] = $can_create_workspaces;

        return $this;
    }

    /**
     * Gets can_create_workspaces_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanCreateWorkspacesMetadata()
    {
        return $this->container['can_create_workspaces_metadata'];
    }

    /**
     * Sets can_create_workspaces_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_create_workspaces_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setCanCreateWorkspacesMetadata($can_create_workspaces_metadata)
    {
        $this->container['can_create_workspaces_metadata'] = $can_create_workspaces_metadata;

        return $this;
    }

    /**
     * Gets can_delete_documents_in_transaction
     *
     * @return ?string
     */
    public function getCanDeleteDocumentsInTransaction()
    {
        return $this->container['can_delete_documents_in_transaction'];
    }

    /**
     * Sets can_delete_documents_in_transaction
     *
     * @param ?string $can_delete_documents_in_transaction 
     *
     * @return $this
     */
    public function setCanDeleteDocumentsInTransaction($can_delete_documents_in_transaction)
    {
        $this->container['can_delete_documents_in_transaction'] = $can_delete_documents_in_transaction;

        return $this;
    }

    /**
     * Gets can_delete_documents_in_transaction_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanDeleteDocumentsInTransactionMetadata()
    {
        return $this->container['can_delete_documents_in_transaction_metadata'];
    }

    /**
     * Sets can_delete_documents_in_transaction_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_delete_documents_in_transaction_metadata 
     *
     * @return $this
     */
    public function setCanDeleteDocumentsInTransactionMetadata($can_delete_documents_in_transaction_metadata)
    {
        $this->container['can_delete_documents_in_transaction_metadata'] = $can_delete_documents_in_transaction_metadata;

        return $this;
    }

    /**
     * Gets can_delete_transaction
     *
     * @return ?string
     */
    public function getCanDeleteTransaction()
    {
        return $this->container['can_delete_transaction'];
    }

    /**
     * Sets can_delete_transaction
     *
     * @param ?string $can_delete_transaction 
     *
     * @return $this
     */
    public function setCanDeleteTransaction($can_delete_transaction)
    {
        $this->container['can_delete_transaction'] = $can_delete_transaction;

        return $this;
    }

    /**
     * Gets can_delete_transaction_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanDeleteTransactionMetadata()
    {
        return $this->container['can_delete_transaction_metadata'];
    }

    /**
     * Sets can_delete_transaction_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_delete_transaction_metadata 
     *
     * @return $this
     */
    public function setCanDeleteTransactionMetadata($can_delete_transaction_metadata)
    {
        $this->container['can_delete_transaction_metadata'] = $can_delete_transaction_metadata;

        return $this;
    }

    /**
     * Gets can_send_envelopes_via_sms
     *
     * @return ?string
     */
    public function getCanSendEnvelopesViaSms()
    {
        return $this->container['can_send_envelopes_via_sms'];
    }

    /**
     * Sets can_send_envelopes_via_sms
     *
     * @param ?string $can_send_envelopes_via_sms 
     *
     * @return $this
     */
    public function setCanSendEnvelopesViaSms($can_send_envelopes_via_sms)
    {
        $this->container['can_send_envelopes_via_sms'] = $can_send_envelopes_via_sms;

        return $this;
    }

    /**
     * Gets can_send_envelopes_via_sms_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanSendEnvelopesViaSmsMetadata()
    {
        return $this->container['can_send_envelopes_via_sms_metadata'];
    }

    /**
     * Sets can_send_envelopes_via_sms_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_send_envelopes_via_sms_metadata 
     *
     * @return $this
     */
    public function setCanSendEnvelopesViaSmsMetadata($can_send_envelopes_via_sms_metadata)
    {
        $this->container['can_send_envelopes_via_sms_metadata'] = $can_send_envelopes_via_sms_metadata;

        return $this;
    }

    /**
     * Gets disable_document_upload
     *
     * @return ?string
     */
    public function getDisableDocumentUpload()
    {
        return $this->container['disable_document_upload'];
    }

    /**
     * Sets disable_document_upload
     *
     * @param ?string $disable_document_upload 
     *
     * @return $this
     */
    public function setDisableDocumentUpload($disable_document_upload)
    {
        $this->container['disable_document_upload'] = $disable_document_upload;

        return $this;
    }

    /**
     * Gets disable_document_upload_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableDocumentUploadMetadata()
    {
        return $this->container['disable_document_upload_metadata'];
    }

    /**
     * Sets disable_document_upload_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_document_upload_metadata Metadata that indicates whether the `disableDocumentUpload` property is editable.
     *
     * @return $this
     */
    public function setDisableDocumentUploadMetadata($disable_document_upload_metadata)
    {
        $this->container['disable_document_upload_metadata'] = $disable_document_upload_metadata;

        return $this;
    }

    /**
     * Gets disable_other_actions
     *
     * @return ?string
     */
    public function getDisableOtherActions()
    {
        return $this->container['disable_other_actions'];
    }

    /**
     * Sets disable_other_actions
     *
     * @param ?string $disable_other_actions 
     *
     * @return $this
     */
    public function setDisableOtherActions($disable_other_actions)
    {
        $this->container['disable_other_actions'] = $disable_other_actions;

        return $this;
    }

    /**
     * Gets disable_other_actions_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableOtherActionsMetadata()
    {
        return $this->container['disable_other_actions_metadata'];
    }

    /**
     * Sets disable_other_actions_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_other_actions_metadata Metadata that indicates whether the `disableOtherActions` property is editable.
     *
     * @return $this
     */
    public function setDisableOtherActionsMetadata($disable_other_actions_metadata)
    {
        $this->container['disable_other_actions_metadata'] = $disable_other_actions_metadata;

        return $this;
    }

    /**
     * Gets enable_api_request_logging
     *
     * @return ?string
     */
    public function getEnableApiRequestLogging()
    {
        return $this->container['enable_api_request_logging'];
    }

    /**
     * Sets enable_api_request_logging
     *
     * @param ?string $enable_api_request_logging 
     *
     * @return $this
     */
    public function setEnableApiRequestLogging($enable_api_request_logging)
    {
        $this->container['enable_api_request_logging'] = $enable_api_request_logging;

        return $this;
    }

    /**
     * Gets enable_api_request_logging_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableApiRequestLoggingMetadata()
    {
        return $this->container['enable_api_request_logging_metadata'];
    }

    /**
     * Sets enable_api_request_logging_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_api_request_logging_metadata Metadata that indicates whether the `enableApiRequestLogging` property is editable.
     *
     * @return $this
     */
    public function setEnableApiRequestLoggingMetadata($enable_api_request_logging_metadata)
    {
        $this->container['enable_api_request_logging_metadata'] = $enable_api_request_logging_metadata;

        return $this;
    }

    /**
     * Gets enable_key_terms_suggestions_by_document_type
     *
     * @return ?string
     */
    public function getEnableKeyTermsSuggestionsByDocumentType()
    {
        return $this->container['enable_key_terms_suggestions_by_document_type'];
    }

    /**
     * Sets enable_key_terms_suggestions_by_document_type
     *
     * @param ?string $enable_key_terms_suggestions_by_document_type 
     *
     * @return $this
     */
    public function setEnableKeyTermsSuggestionsByDocumentType($enable_key_terms_suggestions_by_document_type)
    {
        $this->container['enable_key_terms_suggestions_by_document_type'] = $enable_key_terms_suggestions_by_document_type;

        return $this;
    }

    /**
     * Gets enable_key_terms_suggestions_by_document_type_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableKeyTermsSuggestionsByDocumentTypeMetadata()
    {
        return $this->container['enable_key_terms_suggestions_by_document_type_metadata'];
    }

    /**
     * Sets enable_key_terms_suggestions_by_document_type_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_key_terms_suggestions_by_document_type_metadata 
     *
     * @return $this
     */
    public function setEnableKeyTermsSuggestionsByDocumentTypeMetadata($enable_key_terms_suggestions_by_document_type_metadata)
    {
        $this->container['enable_key_terms_suggestions_by_document_type_metadata'] = $enable_key_terms_suggestions_by_document_type_metadata;

        return $this;
    }

    /**
     * Gets enable_recipient_viewing_notifications
     *
     * @return ?string
     */
    public function getEnableRecipientViewingNotifications()
    {
        return $this->container['enable_recipient_viewing_notifications'];
    }

    /**
     * Sets enable_recipient_viewing_notifications
     *
     * @param ?string $enable_recipient_viewing_notifications 
     *
     * @return $this
     */
    public function setEnableRecipientViewingNotifications($enable_recipient_viewing_notifications)
    {
        $this->container['enable_recipient_viewing_notifications'] = $enable_recipient_viewing_notifications;

        return $this;
    }

    /**
     * Gets enable_recipient_viewing_notifications_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableRecipientViewingNotificationsMetadata()
    {
        return $this->container['enable_recipient_viewing_notifications_metadata'];
    }

    /**
     * Sets enable_recipient_viewing_notifications_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_recipient_viewing_notifications_metadata Metadata that indicates whether the `enableRecipientViewingNotifications` property is editable.
     *
     * @return $this
     */
    public function setEnableRecipientViewingNotificationsMetadata($enable_recipient_viewing_notifications_metadata)
    {
        $this->container['enable_recipient_viewing_notifications_metadata'] = $enable_recipient_viewing_notifications_metadata;

        return $this;
    }

    /**
     * Gets enable_sequential_signing_interface
     *
     * @return ?string
     */
    public function getEnableSequentialSigningInterface()
    {
        return $this->container['enable_sequential_signing_interface'];
    }

    /**
     * Sets enable_sequential_signing_interface
     *
     * @param ?string $enable_sequential_signing_interface 
     *
     * @return $this
     */
    public function setEnableSequentialSigningInterface($enable_sequential_signing_interface)
    {
        $this->container['enable_sequential_signing_interface'] = $enable_sequential_signing_interface;

        return $this;
    }

    /**
     * Gets enable_sequential_signing_interface_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSequentialSigningInterfaceMetadata()
    {
        return $this->container['enable_sequential_signing_interface_metadata'];
    }

    /**
     * Sets enable_sequential_signing_interface_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_sequential_signing_interface_metadata Metadata that indicates whether the `enableSequentialSigningInterface` property is editable.
     *
     * @return $this
     */
    public function setEnableSequentialSigningInterfaceMetadata($enable_sequential_signing_interface_metadata)
    {
        $this->container['enable_sequential_signing_interface_metadata'] = $enable_sequential_signing_interface_metadata;

        return $this;
    }

    /**
     * Gets enable_transaction_point_integration
     *
     * @return ?string
     */
    public function getEnableTransactionPointIntegration()
    {
        return $this->container['enable_transaction_point_integration'];
    }

    /**
     * Sets enable_transaction_point_integration
     *
     * @param ?string $enable_transaction_point_integration 
     *
     * @return $this
     */
    public function setEnableTransactionPointIntegration($enable_transaction_point_integration)
    {
        $this->container['enable_transaction_point_integration'] = $enable_transaction_point_integration;

        return $this;
    }

    /**
     * Gets enable_transaction_point_integration_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableTransactionPointIntegrationMetadata()
    {
        return $this->container['enable_transaction_point_integration_metadata'];
    }

    /**
     * Sets enable_transaction_point_integration_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_transaction_point_integration_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setEnableTransactionPointIntegrationMetadata($enable_transaction_point_integration_metadata)
    {
        $this->container['enable_transaction_point_integration_metadata'] = $enable_transaction_point_integration_metadata;

        return $this;
    }

    /**
     * Gets power_form_role
     *
     * @return ?string
     */
    public function getPowerFormRole()
    {
        return $this->container['power_form_role'];
    }

    /**
     * Sets power_form_role
     *
     * @param ?string $power_form_role 
     *
     * @return $this
     */
    public function setPowerFormRole($power_form_role)
    {
        $this->container['power_form_role'] = $power_form_role;

        return $this;
    }

    /**
     * Gets power_form_role_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getPowerFormRoleMetadata()
    {
        return $this->container['power_form_role_metadata'];
    }

    /**
     * Sets power_form_role_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $power_form_role_metadata Metadata that indicates whether the `powerFormRole` property is editable.
     *
     * @return $this
     */
    public function setPowerFormRoleMetadata($power_form_role_metadata)
    {
        $this->container['power_form_role_metadata'] = $power_form_role_metadata;

        return $this;
    }

    /**
     * Gets receive_completed_self_signed_documents_as_email_links
     *
     * @return ?string
     */
    public function getReceiveCompletedSelfSignedDocumentsAsEmailLinks()
    {
        return $this->container['receive_completed_self_signed_documents_as_email_links'];
    }

    /**
     * Sets receive_completed_self_signed_documents_as_email_links
     *
     * @param ?string $receive_completed_self_signed_documents_as_email_links 
     *
     * @return $this
     */
    public function setReceiveCompletedSelfSignedDocumentsAsEmailLinks($receive_completed_self_signed_documents_as_email_links)
    {
        $this->container['receive_completed_self_signed_documents_as_email_links'] = $receive_completed_self_signed_documents_as_email_links;

        return $this;
    }

    /**
     * Gets receive_completed_self_signed_documents_as_email_links_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getReceiveCompletedSelfSignedDocumentsAsEmailLinksMetadata()
    {
        return $this->container['receive_completed_self_signed_documents_as_email_links_metadata'];
    }

    /**
     * Sets receive_completed_self_signed_documents_as_email_links_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $receive_completed_self_signed_documents_as_email_links_metadata Metadata that indicates whether the `receiveCompletedSelfSignedDocumentsAsEmailLinks` property is editable.
     *
     * @return $this
     */
    public function setReceiveCompletedSelfSignedDocumentsAsEmailLinksMetadata($receive_completed_self_signed_documents_as_email_links_metadata)
    {
        $this->container['receive_completed_self_signed_documents_as_email_links_metadata'] = $receive_completed_self_signed_documents_as_email_links_metadata;

        return $this;
    }

    /**
     * Gets signing_ui_version_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSigningUiVersionMetadata()
    {
        return $this->container['signing_ui_version_metadata'];
    }

    /**
     * Sets signing_ui_version_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $signing_ui_version_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setSigningUiVersionMetadata($signing_ui_version_metadata)
    {
        $this->container['signing_ui_version_metadata'] = $signing_ui_version_metadata;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_accept
     *
     * @return ?string
     */
    public function getSupplementalDocumentsMustAccept()
    {
        return $this->container['supplemental_documents_must_accept'];
    }

    /**
     * Sets supplemental_documents_must_accept
     *
     * @param ?string $supplemental_documents_must_accept 
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustAccept($supplemental_documents_must_accept)
    {
        $this->container['supplemental_documents_must_accept'] = $supplemental_documents_must_accept;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_accept_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSupplementalDocumentsMustAcceptMetadata()
    {
        return $this->container['supplemental_documents_must_accept_metadata'];
    }

    /**
     * Sets supplemental_documents_must_accept_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $supplemental_documents_must_accept_metadata Metadata that indicates whether the `supplementalDocumentsMustAccept` property is editable.
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustAcceptMetadata($supplemental_documents_must_accept_metadata)
    {
        $this->container['supplemental_documents_must_accept_metadata'] = $supplemental_documents_must_accept_metadata;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_read
     *
     * @return ?string
     */
    public function getSupplementalDocumentsMustRead()
    {
        return $this->container['supplemental_documents_must_read'];
    }

    /**
     * Sets supplemental_documents_must_read
     *
     * @param ?string $supplemental_documents_must_read 
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustRead($supplemental_documents_must_read)
    {
        $this->container['supplemental_documents_must_read'] = $supplemental_documents_must_read;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_read_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSupplementalDocumentsMustReadMetadata()
    {
        return $this->container['supplemental_documents_must_read_metadata'];
    }

    /**
     * Sets supplemental_documents_must_read_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $supplemental_documents_must_read_metadata Metadata that indicates whether the `supplementalDocumentsMustRead` property is editable.
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustReadMetadata($supplemental_documents_must_read_metadata)
    {
        $this->container['supplemental_documents_must_read_metadata'] = $supplemental_documents_must_read_metadata;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_view
     *
     * @return ?string
     */
    public function getSupplementalDocumentsMustView()
    {
        return $this->container['supplemental_documents_must_view'];
    }

    /**
     * Sets supplemental_documents_must_view
     *
     * @param ?string $supplemental_documents_must_view 
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustView($supplemental_documents_must_view)
    {
        $this->container['supplemental_documents_must_view'] = $supplemental_documents_must_view;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_view_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSupplementalDocumentsMustViewMetadata()
    {
        return $this->container['supplemental_documents_must_view_metadata'];
    }

    /**
     * Sets supplemental_documents_must_view_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $supplemental_documents_must_view_metadata Metadata that indicates whether the `supplementalDocumentsMustView` property is editable.
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustViewMetadata($supplemental_documents_must_view_metadata)
    {
        $this->container['supplemental_documents_must_view_metadata'] = $supplemental_documents_must_view_metadata;

        return $this;
    }

    /**
     * Gets use_new_docu_sign_experience_interface
     *
     * @return ?string
     */
    public function getUseNewDocuSignExperienceInterface()
    {
        return $this->container['use_new_docu_sign_experience_interface'];
    }

    /**
     * Sets use_new_docu_sign_experience_interface
     *
     * @param ?string $use_new_docu_sign_experience_interface 
     *
     * @return $this
     */
    public function setUseNewDocuSignExperienceInterface($use_new_docu_sign_experience_interface)
    {
        $this->container['use_new_docu_sign_experience_interface'] = $use_new_docu_sign_experience_interface;

        return $this;
    }

    /**
     * Gets use_new_docu_sign_experience_interface_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseNewDocuSignExperienceInterfaceMetadata()
    {
        return $this->container['use_new_docu_sign_experience_interface_metadata'];
    }

    /**
     * Sets use_new_docu_sign_experience_interface_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_new_docu_sign_experience_interface_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setUseNewDocuSignExperienceInterfaceMetadata($use_new_docu_sign_experience_interface_metadata)
    {
        $this->container['use_new_docu_sign_experience_interface_metadata'] = $use_new_docu_sign_experience_interface_metadata;

        return $this;
    }

    /**
     * Gets use_new_sending_interface
     *
     * @return ?string
     */
    public function getUseNewSendingInterface()
    {
        return $this->container['use_new_sending_interface'];
    }

    /**
     * Sets use_new_sending_interface
     *
     * @param ?string $use_new_sending_interface 
     *
     * @return $this
     */
    public function setUseNewSendingInterface($use_new_sending_interface)
    {
        $this->container['use_new_sending_interface'] = $use_new_sending_interface;

        return $this;
    }

    /**
     * Gets use_new_sending_interface_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseNewSendingInterfaceMetadata()
    {
        return $this->container['use_new_sending_interface_metadata'];
    }

    /**
     * Sets use_new_sending_interface_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_new_sending_interface_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setUseNewSendingInterfaceMetadata($use_new_sending_interface_metadata)
    {
        $this->container['use_new_sending_interface_metadata'] = $use_new_sending_interface_metadata;

        return $this;
    }

    /**
     * Gets vaulting_mode
     *
     * @return ?string
     */
    public function getVaultingMode()
    {
        return $this->container['vaulting_mode'];
    }

    /**
     * Sets vaulting_mode
     *
     * @param ?string $vaulting_mode 
     *
     * @return $this
     */
    public function setVaultingMode($vaulting_mode)
    {
        $this->container['vaulting_mode'] = $vaulting_mode;

        return $this;
    }

    /**
     * Gets vaulting_mode_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getVaultingModeMetadata()
    {
        return $this->container['vaulting_mode_metadata'];
    }

    /**
     * Sets vaulting_mode_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $vaulting_mode_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setVaultingModeMetadata($vaulting_mode_metadata)
    {
        $this->container['vaulting_mode_metadata'] = $vaulting_mode_metadata;

        return $this;
    }

    /**
     * Gets web_forms
     *
     * @return ?string
     */
    public function getWebForms()
    {
        return $this->container['web_forms'];
    }

    /**
     * Sets web_forms
     *
     * @param ?string $web_forms 
     *
     * @return $this
     */
    public function setWebForms($web_forms)
    {
        $this->container['web_forms'] = $web_forms;

        return $this;
    }

    /**
     * Gets web_forms_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getWebFormsMetadata()
    {
        return $this->container['web_forms_metadata'];
    }

    /**
     * Sets web_forms_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $web_forms_metadata 
     *
     * @return $this
     */
    public function setWebFormsMetadata($web_forms_metadata)
    {
        $this->container['web_forms_metadata'] = $web_forms_metadata;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

