<?php
declare(strict_types=1);

/**
 * CloudStorageApi.
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Docusign eSignature REST API
 *
 * The Docusign eSignature REST API provides you with a powerful, convenient, and simple Web services API for interacting with Docusign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\CloudStorageApi;


/**
 * ListOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListOptions
{
    /**
      * $cloud_storage_folder_path 
      * @var ?string
      */
    protected ?string $cloud_storage_folder_path = null;

    /**
     * Gets cloud_storage_folder_path
     *
     * @return ?string
     */
    public function getCloudStorageFolderPath(): ?string
    {
        return $this->cloud_storage_folder_path;
    }

    /**
     * Sets cloud_storage_folder_path
     * @param ?string $cloud_storage_folder_path 
     *
     * @return self
     */
    public function setCloudStorageFolderPath(?string $cloud_storage_folder_path): self
    {
        $this->cloud_storage_folder_path = $cloud_storage_folder_path;
        return $this;
    }
    /**
      * $cloud_storage_folderid_plain 
      * @var ?string
      */
    protected ?string $cloud_storage_folderid_plain = null;

    /**
     * Gets cloud_storage_folderid_plain
     *
     * @return ?string
     */
    public function getCloudStorageFolderidPlain(): ?string
    {
        return $this->cloud_storage_folderid_plain;
    }

    /**
     * Sets cloud_storage_folderid_plain
     * @param ?string $cloud_storage_folderid_plain 
     *
     * @return self
     */
    public function setCloudStorageFolderidPlain(?string $cloud_storage_folderid_plain): self
    {
        $this->cloud_storage_folderid_plain = $cloud_storage_folderid_plain;
        return $this;
    }
    /**
      * $count An optional value that sets how many items are included in the response.   The default setting for this is 25.
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count An optional value that sets how many items are included in the response.   The default setting for this is 25.
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $order An optional value that sets the direction order used to sort the item list.   Valid values are:   * asc = ascending sort order * desc = descending sort order
      * @var ?string
      */
    protected ?string $order = null;

    /**
     * Gets order
     *
     * @return ?string
     */
    public function getOrder(): ?string
    {
        return $this->order;
    }

    /**
     * Sets order
     * @param ?string $order An optional value that sets the direction order used to sort the item list.   Valid values are:   * asc = ascending sort order * desc = descending sort order
     *
     * @return self
     */
    public function setOrder(?string $order): self
    {
        $this->order = $order;
        return $this;
    }
    /**
      * $order_by An optional value that sets the file attribute used to sort the item list.   Valid values are:   * modified * name
      * @var ?string
      */
    protected ?string $order_by = null;

    /**
     * Gets order_by
     *
     * @return ?string
     */
    public function getOrderBy(): ?string
    {
        return $this->order_by;
    }

    /**
     * Sets order_by
     * @param ?string $order_by An optional value that sets the file attribute used to sort the item list.   Valid values are:   * modified * name
     *
     * @return self
     */
    public function setOrderBy(?string $order_by): self
    {
        $this->order_by = $order_by;
        return $this;
    }
    /**
      * $search_text 
      * @var ?string
      */
    protected ?string $search_text = null;

    /**
     * Gets search_text
     *
     * @return ?string
     */
    public function getSearchText(): ?string
    {
        return $this->search_text;
    }

    /**
     * Sets search_text
     * @param ?string $search_text 
     *
     * @return self
     */
    public function setSearchText(?string $search_text): self
    {
        $this->search_text = $search_text;
        return $this;
    }
    /**
      * $start_position Indicates the starting point of the first item included in the response set. It uses a 0-based index. The default setting for this is 0.
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position Indicates the starting point of the first item included in the response set. It uses a 0-based index. The default setting for this is 0.
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
}


/**
 * GetProviderOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetProviderOptions
{
    /**
      * $redirect_url The URL the user is redirected to after the cloud storage provider authenticates the user. Using this will append the redirectUrl to the authenticationUrl.  The redirectUrl is restricted to URLs in the docusign.com or docusign.net domains.
      * @var ?string
      */
    protected ?string $redirect_url = null;

    /**
     * Gets redirect_url
     *
     * @return ?string
     */
    public function getRedirectUrl(): ?string
    {
        return $this->redirect_url;
    }

    /**
     * Sets redirect_url
     * @param ?string $redirect_url The URL the user is redirected to after the cloud storage provider authenticates the user. Using this will append the redirectUrl to the authenticationUrl.  The redirectUrl is restricted to URLs in the docusign.com or docusign.net domains.
     *
     * @return self
     */
    public function setRedirectUrl(?string $redirect_url): self
    {
        $this->redirect_url = $redirect_url;
        return $this;
    }
}


/**
 * ListFoldersOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListFoldersOptions
{
    /**
      * $cloud_storage_folder_path A comma separated list of folder IDs included in the request.
      * @var ?string
      */
    protected ?string $cloud_storage_folder_path = null;

    /**
     * Gets cloud_storage_folder_path
     *
     * @return ?string
     */
    public function getCloudStorageFolderPath(): ?string
    {
        return $this->cloud_storage_folder_path;
    }

    /**
     * Sets cloud_storage_folder_path
     * @param ?string $cloud_storage_folder_path A comma separated list of folder IDs included in the request.
     *
     * @return self
     */
    public function setCloudStorageFolderPath(?string $cloud_storage_folder_path): self
    {
        $this->cloud_storage_folder_path = $cloud_storage_folder_path;
        return $this;
    }
    /**
      * $count An optional value that sets how many items are included in the response.   The default setting for this is 25.
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count An optional value that sets how many items are included in the response.   The default setting for this is 25.
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $order An optional value that sets the direction order used to sort the item list.   Valid values are:   * asc = ascending sort order * desc = descending sort order
      * @var ?string
      */
    protected ?string $order = null;

    /**
     * Gets order
     *
     * @return ?string
     */
    public function getOrder(): ?string
    {
        return $this->order;
    }

    /**
     * Sets order
     * @param ?string $order An optional value that sets the direction order used to sort the item list.   Valid values are:   * asc = ascending sort order * desc = descending sort order
     *
     * @return self
     */
    public function setOrder(?string $order): self
    {
        $this->order = $order;
        return $this;
    }
    /**
      * $order_by An optional value that sets the file attribute used to sort the item list.   Valid values are:   * modified * name
      * @var ?string
      */
    protected ?string $order_by = null;

    /**
     * Gets order_by
     *
     * @return ?string
     */
    public function getOrderBy(): ?string
    {
        return $this->order_by;
    }

    /**
     * Sets order_by
     * @param ?string $order_by An optional value that sets the file attribute used to sort the item list.   Valid values are:   * modified * name
     *
     * @return self
     */
    public function setOrderBy(?string $order_by): self
    {
        $this->order_by = $order_by;
        return $this;
    }
    /**
      * $search_text 
      * @var ?string
      */
    protected ?string $search_text = null;

    /**
     * Gets search_text
     *
     * @return ?string
     */
    public function getSearchText(): ?string
    {
        return $this->search_text;
    }

    /**
     * Sets search_text
     * @param ?string $search_text 
     *
     * @return self
     */
    public function setSearchText(?string $search_text): self
    {
        $this->search_text = $search_text;
        return $this;
    }
    /**
      * $start_position Indicates the starting point of the first item included in the response set. It uses a 0-based index. The default setting for this is 0.
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position Indicates the starting point of the first item included in the response set. It uses a 0-based index. The default setting for this is 0.
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
}


/**
 * ListProvidersOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListProvidersOptions
{
    /**
      * $redirect_url The URL the user is redirected to after the cloud storage provider authenticates the user. Using this will append the redirectUrl to the authenticationUrl.  The redirectUrl is restricted to URLs in the docusign.com or docusign.net domains.
      * @var ?string
      */
    protected ?string $redirect_url = null;

    /**
     * Gets redirect_url
     *
     * @return ?string
     */
    public function getRedirectUrl(): ?string
    {
        return $this->redirect_url;
    }

    /**
     * Sets redirect_url
     * @param ?string $redirect_url The URL the user is redirected to after the cloud storage provider authenticates the user. Using this will append the redirectUrl to the authenticationUrl.  The redirectUrl is restricted to URLs in the docusign.com or docusign.net domains.
     *
     * @return self
     */
    public function setRedirectUrl(?string $redirect_url): self
    {
        $this->redirect_url = $redirect_url;
        return $this;
    }
}



namespace DocuSign\eSign\Api;

use DocuSign\eSign\Client\ApiClient;
use DocuSign\eSign\Client\ApiException;
use DocuSign\eSign\Configuration;
use DocuSign\eSign\ObjectSerializer;

/**
 * CloudStorageApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class CloudStorageApi
{
    /**
     * API Client
     *
     * @var ApiClient instance of the ApiClient
     */
    protected ApiClient $apiClient;

    /**
     * Constructor
     *
     * @param ApiClient|null $apiClient The api client to use
     *
     * @return void
     */
    public function __construct(ApiClient $apiClient = null)
    {
        $this->apiClient = $apiClient ?? new ApiClient();
    }

    /**
     * Get API client
     *
     * @return ApiClient get the API client
     */
    public function getApiClient(): ApiClient
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param ApiClient $apiClient set the API client
     *
     * @return self
     */
    public function setApiClient(ApiClient $apiClient): self
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
    * Update $resourcePath with $
    *
    * @param string $resourcePath the resource path to use
    * @param string $baseName the base name param
    * @param string $paramName the parameter name
    *
    * @return string
    */
    public function updateResourcePath(string $resourcePath, string $baseName, string $paramName): string
    {
        return str_replace(
            "{" . $baseName . "}",
            $this->apiClient->getSerializer()->toPathValue($paramName),
            $resourcePath
        );
    }


    /**
     * Operation callList
     *
     * Gets a list of all the items from the specified cloud storage provider.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $folder_id The ID of the folder being accessed.
     * @param ?string $service_id The ID of the service to access.   Valid values are the service name (\&quot;Box\&quot;) or the numerical serviceId (\&quot;4136\&quot;).
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\CloudStorageApi\ListOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ExternalFolder
     */
    public function callList($account_id, $folder_id, $service_id, $user_id, \DocuSign\eSign\Api\CloudStorageApi\ListOptions $options = null)
    {
        list($response) = $this->callListWithHttpInfo($account_id, $folder_id, $service_id, $user_id, $options);
        return $response;
    }

    /**
     * Operation callListWithHttpInfo
     *
     * Gets a list of all the items from the specified cloud storage provider.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $folder_id The ID of the folder being accessed.
     * @param ?string $service_id The ID of the service to access.   Valid values are the service name (\&quot;Box\&quot;) or the numerical serviceId (\&quot;4136\&quot;).
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\CloudStorageApi\ListOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ExternalFolder, HTTP status code, HTTP response headers (array of strings)
     */
    public function callListWithHttpInfo($account_id, $folder_id, $service_id, $user_id, \DocuSign\eSign\Api\CloudStorageApi\ListOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling callList');
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $folder_id when calling callList');
        }
        // verify the required parameter 'service_id' is set
        if ($service_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $service_id when calling callList');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling callList');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}/folders/{folderId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCloudStorageFolderPath() != 'null') {
                $queryParams['cloud_storage_folder_path'] = $this->apiClient->getSerializer()->toQueryValue($options->getCloudStorageFolderPath());
            }
            if ($options->getCloudStorageFolderidPlain() != 'null') {
                $queryParams['cloud_storage_folderid_plain'] = $this->apiClient->getSerializer()->toQueryValue($options->getCloudStorageFolderidPlain());
            }
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getOrder() != 'null') {
                $queryParams['order'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrder());
            }
            if ($options->getOrderBy() != 'null') {
                $queryParams['order_by'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrderBy());
            }
            if ($options->getSearchText() != 'null') {
                $queryParams['search_text'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchText());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "folderId", $folder_id);
        }
        // path params
        if ($service_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "serviceId", $service_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ExternalFolder',
                '/v2.1/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}/folders/{folderId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ExternalFolder', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ExternalFolder', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createProvider
     *
     * Configures the redirect URL information  for one or more cloud storage providers for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\CloudStorageProviders $cloud_storage_providers  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CloudStorageProviders
     */
    public function createProvider($account_id, $user_id, $cloud_storage_providers = null)
    {
        list($response) = $this->createProviderWithHttpInfo($account_id, $user_id, $cloud_storage_providers);
        return $response;
    }

    /**
     * Operation createProviderWithHttpInfo
     *
     * Configures the redirect URL information  for one or more cloud storage providers for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\CloudStorageProviders $cloud_storage_providers  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CloudStorageProviders, HTTP status code, HTTP response headers (array of strings)
     */
    public function createProviderWithHttpInfo($account_id, $user_id, $cloud_storage_providers = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createProvider');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling createProvider');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/cloud_storage";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($cloud_storage_providers)) {
            $_tempBody = $cloud_storage_providers;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CloudStorageProviders',
                '/v2.1/accounts/{accountId}/users/{userId}/cloud_storage'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CloudStorageProviders', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CloudStorageProviders', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProvider
     *
     * Deletes the user authentication information for the specified cloud storage provider.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $service_id The ID of the service to access.   Valid values are the service name (\&quot;Box\&quot;) or the numerical serviceId (\&quot;4136\&quot;).
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CloudStorageProviders
     */
    public function deleteProvider($account_id, $service_id, $user_id)
    {
        list($response) = $this->deleteProviderWithHttpInfo($account_id, $service_id, $user_id);
        return $response;
    }

    /**
     * Operation deleteProviderWithHttpInfo
     *
     * Deletes the user authentication information for the specified cloud storage provider.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $service_id The ID of the service to access.   Valid values are the service name (\&quot;Box\&quot;) or the numerical serviceId (\&quot;4136\&quot;).
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CloudStorageProviders, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProviderWithHttpInfo($account_id, $service_id, $user_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteProvider');
        }
        // verify the required parameter 'service_id' is set
        if ($service_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $service_id when calling deleteProvider');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling deleteProvider');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($service_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "serviceId", $service_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CloudStorageProviders',
                '/v2.1/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CloudStorageProviders', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CloudStorageProviders', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteProviders
     *
     * Deletes the user authentication information for one or more cloud storage providers.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\CloudStorageProviders $cloud_storage_providers  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CloudStorageProviders
     */
    public function deleteProviders($account_id, $user_id, $cloud_storage_providers = null)
    {
        list($response) = $this->deleteProvidersWithHttpInfo($account_id, $user_id, $cloud_storage_providers);
        return $response;
    }

    /**
     * Operation deleteProvidersWithHttpInfo
     *
     * Deletes the user authentication information for one or more cloud storage providers.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param \DocuSign\eSign\Model\CloudStorageProviders $cloud_storage_providers  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CloudStorageProviders, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProvidersWithHttpInfo($account_id, $user_id, $cloud_storage_providers = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteProviders');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling deleteProviders');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/cloud_storage";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($cloud_storage_providers)) {
            $_tempBody = $cloud_storage_providers;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CloudStorageProviders',
                '/v2.1/accounts/{accountId}/users/{userId}/cloud_storage'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CloudStorageProviders', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CloudStorageProviders', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProvider
     *
     * Gets the specified Cloud Storage Provider configuration for the User.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $service_id The ID of the service to access.   Valid values are the service name (\&quot;Box\&quot;) or the numerical serviceId (\&quot;4136\&quot;).
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\CloudStorageApi\GetProviderOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CloudStorageProviders
     */
    public function getProvider($account_id, $service_id, $user_id, \DocuSign\eSign\Api\CloudStorageApi\GetProviderOptions $options = null)
    {
        list($response) = $this->getProviderWithHttpInfo($account_id, $service_id, $user_id, $options);
        return $response;
    }

    /**
     * Operation getProviderWithHttpInfo
     *
     * Gets the specified Cloud Storage Provider configuration for the User.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $service_id The ID of the service to access.   Valid values are the service name (\&quot;Box\&quot;) or the numerical serviceId (\&quot;4136\&quot;).
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\CloudStorageApi\GetProviderOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CloudStorageProviders, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProviderWithHttpInfo($account_id, $service_id, $user_id, \DocuSign\eSign\Api\CloudStorageApi\GetProviderOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getProvider');
        }
        // verify the required parameter 'service_id' is set
        if ($service_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $service_id when calling getProvider');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling getProvider');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getRedirectUrl() != 'null') {
                $queryParams['redirectUrl'] = $this->apiClient->getSerializer()->toQueryValue($options->getRedirectUrl());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($service_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "serviceId", $service_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CloudStorageProviders',
                '/v2.1/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CloudStorageProviders', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CloudStorageProviders', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listFolders
     *
     * Retrieves a list of all the items in a specified folder from the specified cloud storage provider.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $service_id The ID of the service to access.   Valid values are the service name (\&quot;Box\&quot;) or the numerical serviceId (\&quot;4136\&quot;).
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\CloudStorageApi\ListFoldersOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ExternalFolder
     */
    public function listFolders($account_id, $service_id, $user_id, \DocuSign\eSign\Api\CloudStorageApi\ListFoldersOptions $options = null)
    {
        list($response) = $this->listFoldersWithHttpInfo($account_id, $service_id, $user_id, $options);
        return $response;
    }

    /**
     * Operation listFoldersWithHttpInfo
     *
     * Retrieves a list of all the items in a specified folder from the specified cloud storage provider.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $service_id The ID of the service to access.   Valid values are the service name (\&quot;Box\&quot;) or the numerical serviceId (\&quot;4136\&quot;).
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\CloudStorageApi\ListFoldersOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ExternalFolder, HTTP status code, HTTP response headers (array of strings)
     */
    public function listFoldersWithHttpInfo($account_id, $service_id, $user_id, \DocuSign\eSign\Api\CloudStorageApi\ListFoldersOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listFolders');
        }
        // verify the required parameter 'service_id' is set
        if ($service_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $service_id when calling listFolders');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling listFolders');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}/folders";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCloudStorageFolderPath() != 'null') {
                $queryParams['cloud_storage_folder_path'] = $this->apiClient->getSerializer()->toQueryValue($options->getCloudStorageFolderPath());
            }
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getOrder() != 'null') {
                $queryParams['order'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrder());
            }
            if ($options->getOrderBy() != 'null') {
                $queryParams['order_by'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrderBy());
            }
            if ($options->getSearchText() != 'null') {
                $queryParams['search_text'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchText());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($service_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "serviceId", $service_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ExternalFolder',
                '/v2.1/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}/folders'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ExternalFolder', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ExternalFolder', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listProviders
     *
     * Get the Cloud Storage Provider configuration for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\CloudStorageApi\ListProvidersOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CloudStorageProviders
     */
    public function listProviders($account_id, $user_id, \DocuSign\eSign\Api\CloudStorageApi\ListProvidersOptions $options = null)
    {
        list($response) = $this->listProvidersWithHttpInfo($account_id, $user_id, $options);
        return $response;
    }

    /**
     * Operation listProvidersWithHttpInfo
     *
     * Get the Cloud Storage Provider configuration for the specified user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $user_id The user ID of the user being accessed. Generally this is the user ID of the authenticated user, but if the authenticated user is an Admin on the account, this may be another user the Admin user is accessing.
     * @param  \DocuSign\eSign\Api\CloudStorageApi\ListProvidersOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CloudStorageProviders, HTTP status code, HTTP response headers (array of strings)
     */
    public function listProvidersWithHttpInfo($account_id, $user_id, \DocuSign\eSign\Api\CloudStorageApi\ListProvidersOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listProviders');
        }
        // verify the required parameter 'user_id' is set
        if ($user_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $user_id when calling listProviders');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/users/{userId}/cloud_storage";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getRedirectUrl() != 'null') {
                $queryParams['redirectUrl'] = $this->apiClient->getSerializer()->toQueryValue($options->getRedirectUrl());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "userId", $user_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CloudStorageProviders',
                '/v2.1/accounts/{accountId}/users/{userId}/cloud_storage'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CloudStorageProviders', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CloudStorageProviders', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
