<?php
$config = new \Config\App();
$appName = $config->appName . " - Profile";
include('header.php')?>

<style>
    .profile-tab .image-details {
    height: 100px;
}
</style>

        <main>
                <div class="container-fluid">
                    <!-- Breadcrumb start -->
                    <div class="row m-1">
                        <div class="col-12 ">
                            <h4 class="main-title">Profile</h4>
                            <ul class="app-line-breadcrumbs mb-3">
                                <li class="">
                                    <a class="f-s-14 f-w-500" href="#">
                                    <span>
                                       Manage your Profile and settings.
                                    </span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <!-- Breadcrumb end -->

                    <!-- setting-app start -->
                    <div class="row">
                        <div class="col-lg-4 col-xxl-3">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Settings</h5>
                                </div>
                                <div class="card-body">
                                    <div class="vertical-tab setting-tab">
                                        <ul class="nav nav-tabs tab-light-primary " id="v-bg" role="tablist">
                                            <li class="nav-item" role="presentation">
                                                <button aria-controls="profile-tab-pane" aria-selected="true"
                                                        class="nav-link active" data-bs-target="#profile-tab-pane"
                                                        data-bs-toggle="tab" id="profile-tab" role="tab"
                                                        type="button"><i
                                                        class="ph-bold  ph-user-circle-gear pe-2"></i>
                                                    Profile
                                                </button>
                                            </li>

                                            <!--<li class="nav-item" role="presentation">-->
                                            <!--    <button aria-controls="activity-tab-pane" aria-selected="true"-->
                                            <!--            class="nav-link"-->
                                            <!--            data-bs-target="#activity-tab-pane" data-bs-toggle="tab"-->
                                            <!--            id="activity-tab"-->
                                            <!--            role="tab" type="button"><i-->
                                            <!--            class="ph-bold  ph-alarm pe-2"></i>-->
                                            <!--        Activity-->
                                            <!--    </button>-->
                                            <!--</li>-->

                                            <li class="nav-item" role="presentation">
                                                <button aria-controls="security-tab-pane" aria-selected="false"
                                                        class="nav-link"
                                                        data-bs-target="#security-tab-pane" data-bs-toggle="tab"
                                                        id="security-tab"
                                                        role="tab" type="button"><i
                                                        class="ph-bold  ph-shield-check pe-2"></i>Security
                                                </button>
                                            </li>

                                            <!--<li class="nav-item" role="presentation">-->
                                            <!--    <button aria-controls="privacy-tab-pane" aria-selected="false"-->
                                            <!--            class="nav-link"-->
                                            <!--            data-bs-target="#privacy-tab-pane" data-bs-toggle="tab"-->
                                            <!--            id="privacy-tab"-->
                                            <!--            role="tab" type="button"><i-->
                                            <!--            class="ph-bold  ph-lock-open pe-2"></i>Privacy-->
                                            <!--    </button>-->
                                            <!--</li>-->

                                            <li class="nav-item" role="presentation">
                                                <button aria-controls="notification-tab-pane" aria-selected="false"
                                                        class="nav-link"
                                                        data-bs-target="#notification-tab-pane" data-bs-toggle="tab"
                                                        id="notification-tab"
                                                        role="tab" type="button"><i
                                                        class="ph-bold  ph-notification pe-2"></i>Notification
                                                </button>
                                            </li>

                                            <li class="nav-item" role="presentation">
                                                <button aria-controls="subscription-tab-pane" aria-selected="false"
                                                        class="nav-link"
                                                        data-bs-target="#subscription-tab-pane" data-bs-toggle="tab"
                                                        id="subscription-tab"
                                                        role="tab" type="button"><i
                                                        class="ph-bold  ph-wallet pe-2"></i>Billing
                                                </button>
                                            </li>

                                            <li class="nav-item" role="presentation">
                                                <a href="<?php echo base_url()?>accounts" class="nav-link"><i
                                                        class="ph-bold  ph-graph pe-2"></i>Accounts
                                                </a>
                                            </li>

                                            <!--<li class="nav-item" role="presentation">-->
                                            <!--    <button class="nav-link" id="account_delete" type="button"><i-->
                                            <!--            class="ph-bold  ph-trash pe-2"></i>Delete-->
                                            <!--    </button>-->
                                            <!--</li>-->
                                        </ul>
                                    </div>

                                </div>
                            </div>
                            
                            <div class="card">
                                <div class="card-body">
                                    <div class="card hover-effect card-light-primary mt-4">
                                        <div class="card-body">
                                            <h5>Used space</h5>
                                            <p class="mt-2 text-secondary f-s-16">Your team has used 80% of your
                                                available space.need more?</p>

                                            <div aria-valuemax="100" aria-valuemin="0"
                                                 aria-valuenow="0" class="progress w-100 mt-3 mb-3" role="progressbar">
                                                <div class="progress-bar bg-primary progress-bar-striped"
                                                     style="width: 78.5%"></div>
                                            </div>

                                            <span class="mt-4">
                                                    <a class="me-3 text-secondary" href="#">Dismiss</a>
                                                    <a class="text-d-underline" href="#">Upgrade plan</a>
                                                </span>

                                        </div>
                                    </div>
                                    <div class="app-divider-v"></div>
                                    <div class="d-flex align-items-center">
                                            <span class="h-45 w-45 d-flex-center bg-warning b-r-50 position-relative">
                                                <img alt="avtar" class="img-fluid b-r-50"
                                                     src="<?php echo base_url()?>assets/assets/images/avtar/9.png">
                                                <span
                                                        class="position-absolute top-0 end-0 p-1 bg-success border border-light rounded-circle"></span>
                                            </span>
                                        <div class="flex-grow-1 ps-2 log-out-profile">
                                            <div class="f-w-600 fs-6"> Ninfa Monaldo</div>
                                            <div class="text-secondary f-s-12">Web Developer</div>
                                        </div>
                                        <div>
                                            <a href="profile.html">
                                                <span>
                                                    <i class="ph-bold  ph-arrow-square-out f-s-20"></i>
                                                </span>
                                            </a>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8 col-xxl-9">
                            <div class="tab-content">
                                <div aria-labelledby="profile-tab" class="tab-pane fade active show"
                                     id="profile-tab-pane"
                                     role="tabpanel" tabindex="0">
                                    <div class="card setting-profile-tab">
                                        <div class="card-header">
                                            <h5>Profile</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="profile-tab profile-container">
                                                <div class="image-details">
                                                    <!--<div class="profile-image"></div>-->
                                                    <div class="profile-pic">
                                                        <div class="avatar-upload">
                                                            <form class="avatar-edit" id="uploadForm"  enctype="multipart/form-data">
                                                                <input accept=".png, .jpg, .jpeg" id="imageUpload"
                                                                       type="file" name="pimage">
                                                                <label for="imageUpload"><i
                                                                        class="ph-bold  ph-pencil"></i></label>
                                                            </form>
                                                            <div class="avatar-preview">
                                                                <div id="imgPreview" style="background-image: url(<?php echo base_url()?><?= esc($user->pimage) ?>);">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="person-details">
                                                    <h5 class="f-w-600"><?= esc($user->name) ?>
                                                        
                                                    </h5>
                                                    <p><?= esc($user->email) ?></p>
                                                </div>

                                                <form class="app-form" method="post" action="<?php echo base_url()?>home/updateprofile">
                                                    <h5 class="mb-2 text-dark f-w-600">User Info</h5>
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <div class="mb-3">
                                                                <label class="form-label">Username</label>
                                                                <input class="form-control" placeholder="Maria C. Eck" name="name" value="<?= esc($user->name) ?>"
                                                                       type="text">
                                                            </div>
                                                        </div>
                                                        <div class="col-6">
                                                            <div class="mb-3">
                                                                <label class="form-label">Email address</label>
                                                                <input class="form-control"
                                                                       placeholder="MariaCEck@teleworm.us" name="email" value="<?= esc($user->email) ?>"
                                                                       type="email">
                                                            </div>
                                                        </div>
                                                        
                                                         <div class="col-6">
                                                            <div class="mb-3">
                                                                <label class="form-label">Phone Number</label>
                                                                <input class="form-control"
                                                                       placeholder="+11234567890" name="phone" value="<?= esc($user->phone) ?>"
                                                                       type="number">
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="col-12">
                                                            <div class="app-divider-v dotted"></div>
                                                        </div>
                                                        <h5 class="mb-2 text-dark f-w-600">Personal Info</h5>
                                                        <div class="col-12">
                                                            <div class="mb-3">
                                                                <label class="form-label">Address</label>
                                                                <textarea class="form-control"
                                                                          placeholder="1098 Asylum Avenu New Haven, CT 06510" name="address"><?= esc($user->address) ?></textarea>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="mb-3">
                                                                <label class="form-label"
                                                                       for="city">City</label>
                                                                <input class="form-control" id="city" name="city" value="<?= esc($user->city) ?>"
                                                                       placeholder="" type="text">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="mb-3">
                                                                <label class="form-label"
                                                                       for="state">State</label>
                                                                <input class="form-control" id="state" name="state" value="<?= esc($user->state) ?>"
                                                                       placeholder="" type="text">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-2">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="pin">Zip</label>
                                                                <input class="form-control" id="pin"
                                                                       placeholder="CT 06510" type="number" name="pin" value="<?= esc($user->pin) ?>">
                                                            </div>
                                                        </div>
                                                    
                                                        <div class="col-12">
                                                            <div class="text-end">
                                                                <button class="btn btn-primary"
                                                                        type="submit">Submit
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div aria-labelledby="activity-tab" class="tab-pane fade" id="activity-tab-pane"
                                     role="tabpanel" tabindex="0">
                                    <div class="card equal-card month-timeline">
                                        <div class="card-header">
                                            <div class="activity-time">
                                                <h5>Activity</h5>
                                                <div class="activity-tab-section">
                                                    <ul class="nav nav-tabs tab-light-primary" id="Outline"
                                                        role="tablist">
                                                        <li class="nav-item" role="presentation">
                                                            <button aria-controls="today-tab-pane" aria-selected="true"
                                                                    class="nav-link active"
                                                                    data-bs-target="#today-tab-pane"
                                                                    data-bs-toggle="tab"
                                                                    id="today-tab" role="tab"
                                                                    type="button">Today
                                                            </button>

                                                        </li>
                                                        <li class="nav-item" role="presentation">
                                                            <button aria-controls="week-tab-pane" aria-selected="false"
                                                                    class="nav-link" data-bs-target="#week-tab-pane"
                                                                    data-bs-toggle="tab" id="week-tab"
                                                                    role="tab"
                                                                    type="button">Week
                                                            </button>
                                                        </li>
                                                        <li class="nav-item" role="presentation">
                                                            <button aria-controls="month-tab-pane" aria-selected="false"
                                                                    class="nav-link"
                                                                    data-bs-target="#month-tab-pane"
                                                                    data-bs-toggle="tab"
                                                                    id="month-tab" role="tab"
                                                                    type="button">Month
                                                            </button>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div class="tab-content" id="OutlineContent">
                                                <div aria-labelledby="today-tab" class="tab-pane fade show active"
                                                     id="today-tab-pane" role="tabpanel" tabindex="0">

                                                    <ul class="app-timeline-box activity-timeline">
                                                        <li class="timeline-section">
                                                            <div class="timeline-icon">
                              <span class="text-light-primary h-35 w-35 d-flex-center b-r-50">
                                W
                              </span>
                                                            </div>
                                                            <div class="timeline-content">
                                                                <div class="f-s-16">
                                                                    <span class="text-primary f-s-16 mb-0">Wilson<span
                                                                            class="text-secondary ms-2">added reaction in <span
                                                                            class="badge text-outline-primary me-2">#product website</span>post</span></span>
                                                                </div>
                                                                <p class="f-w-500 mt-2 mb-0">
                                                                    <i class="ph ph-clock me-1 align-middle"></i>09.00AM
                                                                </p>
                                                            </div>
                                                        </li>
                                                        <li class="timeline-section">
                                                            <div class="timeline-icon">
                              <span class="text-light-info h-35 w-35 d-flex-center b-r-50 icon-direction">
                                <i class="ph-duotone  ph-image f-s-18"></i>
                              </span>
                                                            </div>
                                                            <div class="timeline-content">
                                                                <p class=" f-s-16 text-info mb-0">2 image files and 2
                                                                    videos uploaded</p>

                                                                <div class="app-timeline-info-text timeline-border-box me-2 ms-0 mt-3 p-3">
                                                                    <div class="row">
                                                                        <div class="col-sm-4">
                                                                            <a class="glightbox img-hover-zoom"
                                                                               data-glightbox="type: image; zoomable: true;"
                                                                               href="<?php echo base_url()?>assets/assets/images/draggable/02.jpg">
                                                                                <img alt=""
                                                                                     class="w-100 rounded" src="<?php echo base_url()?>assets/assets/images/draggable/02.jpg">
                                                                            </a>
                                                                        </div>
                                                                        <div class="col-sm-4">
                                                                            <a class="glightbox img-hover-zoom"
                                                                               data-glightbox="type: image; zoomable: true;"
                                                                               href="<?php echo base_url()?>assets/assets/images/draggable/04.jpg">
                                                                                <img alt=""
                                                                                     class="w-100 rounded" src="<?php echo base_url()?>assets/assets/images/draggable/04.jpg">
                                                                            </a>
                                                                        </div>
                                                                        <div class="col-sm-4">
                                                                            <a class="glightbox img-hover-zoom"
                                                                               data-glightbox="type: image; zoomable: true;"
                                                                               href="<?php echo base_url()?>assets/assets/images/draggable/01.jpg">
                                                                                <img alt=""
                                                                                     class="w-100 rounded" src="<?php echo base_url()?>assets/assets/images/draggable/01.jpg">
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <p class="f-w-500 mt-2 mb-0">
                                                                    <i class="ph ph-clock me-1 align-middle"></i>Updated
                                                                    at 12:45 pm
                                                                </p>
                                                            </div>


                                                        </li>
                                                        <li class="timeline-section">
                                                            <div class="timeline-icon">
                              <span class="text-light-success  h-35 w-35 d-flex-center b-r-50">
                                D
                              </span>
                                                            </div>
                                                            <div class="timeline-content">
                                                                <div class="f-s-16">
                                                                    <span class="text-secondary"><span
                                                                            class="text-success f-s-16 mb-0">Dane Wiza</span> added reaction in <span
                                                                            class="badge text-outline-success me-2">#product website</span>post</span>
                                                                </div>
                                                                <div class="timeline-border-box me-2 ms-0 mt-3">
                                                                    <h6 class="mb-0">Need a feature</h6>
                                                                    <p class="mb-4 text-secondary">Hello everyone,
                                                                        question on email marketing. What are some
                                                                        tips/tricks to avoid going to promotion
                                                                        spam/ junk for automated marketing emails
                                                                        going to promotion spam/ junk for automated
                                                                        marketing emails</p>
                                                                    <span class="badge text-outline-success me-2 timeline-badge">#🙂❤10Reactions</span>
                                                                    <span class="badge text-outline-success me-2">#✨12Replies</span>
                                                                </div>
                                                                <p class="f-w-500 mt-2 mb-0">
                                                                    <i class="ph ph-clock me-1 align-middle"></i>09.00AM
                                                                </p>
                                                            </div>


                                                        </li>
                                                        <li class="timeline-section">
                                                            <div class="timeline-icon">
                              <span class="text-light-danger h-35 w-35 d-flex-center b-r-50">
                                B
                              </span>
                                                            </div>
                                                            <div class="timeline-content">
                                                                <div class="f-s-16">
                                                                    <span class="text-danger f-s-16 mb-0">Betty Mante <span
                                                                            class="text-secondary ms-2">Request joined <span
                                                                            class="badge text-outline-danger me-2">#reaserchteam</span>groups</span></span>
                                                                </div>
                                                                <div class="mt-3">
                                                                    <button class="btn btn-danger"
                                                                            type="button">Accept
                                                                    </button>
                                                                    <button class="btn btn-outline-danger"
                                                                            type="button">Rejects
                                                                    </button>
                                                                </div>
                                                                <p class="f-w-500 mt-2 mb-0">
                                                                    <i class="ph ph-clock me-1 align-middle"></i>4 days
                                                                    ago
                                                                </p>
                                                            </div>


                                                        </li>
                                                        <li class="timeline-section">
                                                            <div class="timeline-icon">
                              <span class="text-light-primary h-35 w-35 d-flex-center b-r-50">
                                P
                              </span>
                                                            </div>
                                                            <div class="timeline-content">
                                                                <div class=" f-s-16">
                                <span class="text-primary f-s-16 mb-0">Pinkie
                                <span class="text-secondary ms-2">uploaded
                                  <span class="text-dark f-w-600 me-2 ms-2">2</span>attachment <span
                                            class="badge text-outline-primary me-2">#reaserchteam</span></span>
                                </span>
                                                                </div>

                                                                <div class="mt-3">
                                                                    <button class="btn btn-primary"
                                                                            type="button">Accept
                                                                    </button>
                                                                    <button class="btn btn-outline-primary"
                                                                            type="button">Rejects
                                                                    </button>
                                                                </div>
                                                                <p class="f-w-500 mt-2 mb-0">
                                                                    <i class="ph ph-clock me-1 align-middle"></i>4 days
                                                                    ago
                                                                </p>
                                                            </div>


                                                        </li>
                                                    </ul>
                                                </div>
                                                <div aria-labelledby="week-tab-pane" class="tab-pane" id="week-tab-pane"
                                                     role="tabpanel" tabindex="0">

                                                    <ul class="app-timeline-box activity-timeline">
                                                        <li class="timeline-section">
                                                            <div class="timeline-icon">
                              <span class="text-light-success  h-35 w-35 d-flex-center b-r-50">
                                D
                              </span>
                                                            </div>
                                                            <div class="timeline-content">
                                                                <div class="f-s-16">
                                                                    <span class="text-secondary"><span
                                                                            class="text-success f-s-16 mb-0">Dane Wiza</span> added reaction in <span
                                                                            class="badge text-outline-success me-2">#product website</span>post</span>
                                                                </div>
                                                                <div class="timeline-border-box me-2 ms-0 mt-3">
                                                                    <h6 class="mb-0">Need a feature</h6>
                                                                    <p class="mb-4 text-secondary">Hello everyone,
                                                                        question on email marketing. What are some
                                                                        tips/tricks to avoid going to promotion
                                                                        spam/ junk for automated marketing emails
                                                                        going to promotion spam/ junk for automated
                                                                        marketing emails</p>
                                                                    <span class="badge text-outline-success me-2 timeline-badge">#🙂❤10Reactions</span>
                                                                    <span class="badge text-outline-success me-2">#✨12Replies</span>
                                                                </div>
                                                                <p class="f-w-500 mt-2 mb-0">
                                                                    <i class="ph ph-clock me-1 align-middle"></i>09.00AM
                                                                </p>
                                                            </div>


                                                        </li>
                                                        <li class="timeline-section">
                                                            <div class="timeline-icon">
                              <span class="text-light-danger h-35 w-35 d-flex-center b-r-50">
                                B
                              </span>
                                                            </div>
                                                            <div class="timeline-content">
                                                                <div class="f-s-16">
                                                                    <span class="text-danger f-s-16 mb-0">Betty Mante <span
                                                                            class="text-secondary ms-2">Request joined <span
                                                                            class="badge text-outline-danger me-2">#reaserchteam</span>groups</span></span>
                                                                </div>
                                                                <div class="mt-3">
                                                                    <button class="btn btn-danger"
                                                                            type="button">Accept
                                                                    </button>
                                                                    <button class="btn btn-outline-danger"
                                                                            type="button">Rejects
                                                                    </button>
                                                                </div>
                                                                <p class="f-w-500 mt-2 mb-0">
                                                                    <i class="ph ph-clock me-1 align-middle"></i>4 days
                                                                    ago
                                                                </p>
                                                            </div>


                                                        </li>
                                                        <li class="timeline-section">
                                                            <div class="timeline-icon">
                              <span class="text-light-primary h-35 w-35 d-flex-center b-r-50">
                                P
                              </span>
                                                            </div>
                                                            <div class="timeline-content">
                                                                <div class=" f-s-16">
                                <span class="text-primary f-s-16 mb-0">Pinkie
                                <span class="text-secondary ms-2">uploaded
                                  <span class="text-dark f-w-600 me-2 ms-2">2</span>attachment <span
                                            class="badge text-outline-primary me-2">#reaserchteam</span></span>
                                </span>
                                                                </div>

                                                                <div class="mt-3">
                                                                    <button class="btn btn-primary"
                                                                            type="button">Accept
                                                                    </button>
                                                                    <button class="btn btn-outline-primary"
                                                                            type="button">Rejects
                                                                    </button>
                                                                </div>
                                                                <p class="f-w-500 mt-2 mb-0">
                                                                    <i class="ph ph-clock me-1 align-middle"></i>4 days
                                                                    ago
                                                                </p>
                                                            </div>


                                                        </li>
                                                    </ul>
                                                </div>
                                                <div aria-labelledby="month-tab-pane" class="tab-pane"
                                                     id="month-tab-pane"
                                                     role="tabpanel" tabindex="0">
                                                    <ul class="app-timeline-box activity-timeline">
                                                        <li class="timeline-section">
                                                            <div class="timeline-icon">
                              <span class="text-light-success  h-35 w-35 d-flex-center b-r-50">
                                D
                              </span>
                                                            </div>
                                                            <div class="timeline-content">
                                                                <div class="f-s-16">
                                                                    <span class="text-secondary"><span
                                                                            class="text-success f-s-16 mb-0">Dane Wiza</span> added reaction in <span
                                                                            class="badge text-outline-success me-2">#product website</span>post</span>
                                                                </div>
                                                                <div class="timeline-border-box me-2 ms-0 mt-3">
                                                                    <h6 class="mb-0">Need a feature</h6>
                                                                    <p class="mb-4 text-secondary">Hello everyone,
                                                                        question on email marketing. What are some
                                                                        tips/tricks to avoid going to promotion
                                                                        spam/ junk for automated marketing emails
                                                                        going to promotion spam/ junk for automated
                                                                        marketing emails</p>
                                                                    <span class="badge text-outline-success me-2 timeline-badge">#🙂❤10Reactions</span>
                                                                    <span class="badge text-outline-success me-2">#✨12Replies</span>
                                                                </div>
                                                                <p class="f-w-500 mt-2 mb-0">
                                                                    <i class="ph ph-clock me-1 align-middle"></i>09.00AM
                                                                </p>
                                                            </div>


                                                        </li>
                                                        <li class="timeline-section">
                                                            <div class="timeline-icon">
                              <span class="text-light-info h-35 w-35 d-flex-center b-r-50 icon-direction">
                                <i class="ph-duotone  ph-image f-s-18"></i>
                              </span>
                                                            </div>
                                                            <div class="timeline-content">
                                                                <p class=" f-s-16 text-info mb-0">2 image files and 2
                                                                    videos uploaded</p>

                                                                <div class="app-timeline-info-text timeline-border-box me-2 ms-0 mt-3 p-3">
                                                                    <div class="row">
                                                                        <div class="col-sm-4">
                                                                            <a class="glightbox img-hover-zoom"
                                                                               data-glightbox="type: image; zoomable: true;"
                                                                               href="<?php echo base_url()?>assets/assets/images/draggable/02.jpg">
                                                                                <img alt=""
                                                                                     class="w-100 rounded" src="<?php echo base_url()?>assets/assets/images/draggable/02.jpg">
                                                                            </a>
                                                                        </div>
                                                                        <div class="col-sm-4">
                                                                            <div class="img-hover-zoom">
                                                                                <a class="glightbox img-hover-zoom"
                                                                                   data-glightbox="type: image; zoomable: true;"
                                                                                   href="<?php echo base_url()?>assets/assets/images/draggable/04.jpg">
                                                                                    <img alt=""
                                                                                         class="w-100 rounded" src="<?php echo base_url()?>assets/assets/images/draggable/04.jpg">
                                                                                </a>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-sm-4">
                                                                            <div class="img-hover-zoom">
                                                                                <a class="glightbox img-hover-zoom"
                                                                                   data-glightbox="type: image; zoomable: true;"
                                                                                   href="<?php echo base_url()?>assets/assets/images/draggable/01.jpg">
                                                                                    <img alt=""
                                                                                         class="w-100 rounded" src="<?php echo base_url()?>assets/assets/images/draggable/01.jpg">
                                                                                </a>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <p class="f-w-500 mt-2 mb-0">
                                                                    <i class="ph ph-clock me-1 align-middle"></i>Updated
                                                                    at 12:45 pm
                                                                </p>
                                                            </div>


                                                        </li>

                                                        <li class="timeline-section">
                                                            <div class="timeline-icon">
                              <span class="text-light-primary h-35 w-35 d-flex-center b-r-50">
                                P
                              </span>
                                                            </div>
                                                            <div class="timeline-content">
                                                                <div class=" f-s-16">
                                <span class="text-primary f-s-16 mb-0">Pinkie
                                <span class="text-secondary ms-2">uploaded
                                  <span class="text-dark f-w-600 me-2 ms-2">2</span>attachment <span
                                            class="badge text-outline-primary me-2">#reaserchteam</span></span>
                                </span>
                                                                </div>

                                                                <div class="mt-3">
                                                                    <button class="btn btn-primary"
                                                                            type="button">Accept
                                                                    </button>
                                                                    <button class="btn btn-outline-primary"
                                                                            type="button">Rejects
                                                                    </button>
                                                                </div>
                                                                <p class="f-w-500 mt-2 mb-0">
                                                                    <i class="ph ph-clock me-1 align-middle"></i>4 days
                                                                    ago
                                                                </p>
                                                            </div>


                                                        </li>
                                                    </ul>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div aria-labelledby="security-tab" class="tab-pane fade" id="security-tab-pane"
                                     role="tabpanel" tabindex="0">
                                    
                                    
                                    <div class="card security-card-content">
                                        <div class="card-body">
                                            <div class="account-security mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col-sm-9">
                                                        <h5 class="text-primary f-w-600">Change Password</h5>
                                                        <p class="account-discription text-secondary f-s-16 mt-3">To
                                                            change your password,
                                                            please fill in the fields below. your password must
                                                            contain at least 8 caracter, it must also include at
                                                            least one upper case letter, one lower case letter, one
                                                            number and one special character.</p>
                                                    </div>
                                                    <div class="col-sm-3 account-security-img">
                                                        <img alt="" class="w-150"
                                                             src="<?php echo base_url()?>assets/assets/images/setting-app/password.png">
                                                    </div>
                                                </div>
                                            </div>

                                            <form class="app-form" method="post" action="<?= base_url('home/updatepassword') ?>">
                                                <div class="row">
                                                    <div class="col-sm-12">
                                                        <label class="form-label">Current Password</label>
                                                        <div class="input-group input-group-password mb-3">
                                                            <span class="input-group-text"><i class="ph-bold ph-lock f-s-20"></i></span>
                                                            <input class="form-control" id="currentPassword" name="current_password" placeholder="********" type="password">
                                                            <span class="input-group-text toggle-password" data-target="currentPassword"><i class="ph ph-eye-slash f-s-20"></i></span>
                                                        </div>
                                                    </div>
                                            
                                                    <div class="col-sm-12">
                                                        <label class="form-label">New Password</label>
                                                        <div class="input-group input-group-password mb-3">
                                                            <span class="input-group-text"><i class="ph-bold ph-lock f-s-20"></i></span>
                                                            <input class="form-control" id="newPassword" name="new_password" placeholder="********" type="password">
                                                            <span class="input-group-text toggle-password" data-target="newPassword"><i class="ph ph-eye-slash f-s-20"></i></span>
                                                        </div>
                                                    </div>
                                            
                                                    <div class="col-sm-12">
                                                        <label class="form-label">Confirm Password</label>
                                                        <div class="input-group input-group-password mb-3">
                                                            <span class="input-group-text"><i class="ph-bold ph-lock f-s-20"></i></span>
                                                            <input class="form-control" id="confirmPassword" name="confirm_password" placeholder="********" type="password">
                                                            <span class="input-group-text toggle-password" data-target="confirmPassword"><i class="ph ph-eye-slash f-s-20"></i></span>
                                                        </div>
                                                    </div>
                                            
                                                    <div class="col-12 text-end">
                                                        <button class="btn btn-primary" type="submit">Submit</button>
                                                    </div>
                                                </div>
                                            </form>

<script>
document.querySelectorAll('.toggle-password').forEach(function (eyeIcon) {
    eyeIcon.addEventListener('click', function () {
        const targetId = this.getAttribute('data-target');
        const targetInput = document.getElementById(targetId);
        const icon = this.querySelector('i');

        if (targetInput.type === "password") {
            targetInput.type = "text";
            icon.classList.remove('ph-eye-slash');
            icon.classList.add('ph-eye');
        } else {
            targetInput.type = "password";
            icon.classList.remove('ph-eye');
            icon.classList.add('ph-eye-slash');
        }
    });
});
</script>

                                        </div>

                                    </div>

                                </div>
                                <div aria-labelledby="privacy-tab" class="tab-pane fade" id="privacy-tab-pane"
                                     role="tabpanel" tabindex="0">
                                    <div class="card equal-card privacy-card">
                                        <div class="card-header">
                                            <h5>Privacy </h5>
                                        </div>
                                        <div class="card-body">
                                            <h6>ACCESS</h6>
                                            <div class="row">
                                                <div class="col-xxl-6">
                                                    <div class="setting-privacy-card form-selectgroup">
                                                        <div class="select-item">
                                                            <label class="form-check-label" for="inlineCheckbox1">
                                                                    <span class="d-flex align-items-center position-relative">
                                                                        <span
                                                                                class="privacy-img bg-success h-40 w-40 d-flex-center b-r-50 position-absolute">
                                                                            <i class="ph-bold  ph-lock f-s-18"></i>
                                                                        </span>
                                                                        <span class="privacy-content ms-5 me-2">
                                                                            <span class="mb-0 text-dark txt-ellipsis-1 f-s-16 f-w-500">Private</span>
                                                                            <span class="mb-0 text-secondary f-s-16"> only users you choose can access</span>
                                                                        </span>
                                                                    </span>
                                                            </label>

                                                            <input checked
                                                                   class="form-check-input form-check- b-r-100 w-25 h-25"
                                                                   id="inlineCheckbox1" name="option"
                                                                   type="radio" value="option1">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class=" col-xxl-6">
                                                    <div class="setting-privacy-card form-selectgroup">
                                                        <div class="select-item ">
                                                            <label class="form-check-label" for="inlineCheckbox2">
                                                                    <span
                                                                            class="d-flex align-items-center position-relative">
                                                                        <span
                                                                                class="privacy-img  bg-primary h-40 w-40 d-flex-center b-r-50 position-absolute">
                                                                            <i class="ph ph-globe f-s-18"></i>
                                                                        </span>
                                                                        <span class="privacy-content ms-5 me-2">
                                                                            <span class="mb-0 text-dark txt-ellipsis-1 f-s-16 f-w-500">Public</span>
                                                                            <span class="mb-0 text-secondary f-s-16">anyone
                                                                                with the link can access </span>
                                                                        </span>
                                                                    </span>
                                                            </label>

                                                            <input class="form-check-input b-r-100 w-25 h-25"
                                                                   id="inlineCheckbox2" name="option" type="radio"
                                                                   value="option2">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <h6>USERS</h6>
                                            <div class="row">
                                                <div class=" col-xxl-6">
                                                    <div class="setting-privacy-card form-selectgroup">
                                                        <div class="select-item">
                                                            <label class="form-check-label" for="inlineCheckbox3">
                                                                    <span
                                                                            class="d-flex align-items-center position-relative">
                                                                        <span
                                                                                class="privacy-img  bg-primary h-40 w-40 d-flex-center b-r-50 position-absolute">
                                                                            <i class="ph-bold  ph-lock f-s-18"></i>
                                                                        </span>
                                                                        <span class="privacy-content ms-5 me-2">
                                                                            <span class="mb-0 text-dark txt-ellipsis-1 f-s-16 f-w-500">users in the table
                                                                            </span>
                                                                            <span class="mb-0 text-secondary f-s-16">
                                                                                users in the table can sign in</span>
                                                                        </span>
                                                                    </span>
                                                            </label>

                                                            <input checked
                                                                   class="form-check-input b-r-100 w-25 h-25"
                                                                   id="inlineCheckbox3" name="useroption"
                                                                   type="radio" value="useroption1">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class=" col-xxl-6">
                                                    <div class="setting-privacy-card form-selectgroup">
                                                        <div class="select-item">
                                                            <label class="form-check-label" for="inlineCheckbox4">
                                                                    <span
                                                                            class="d-flex align-items-center position-relative">
                                                                        <span
                                                                                class=" privacy-img bg-secondary h-40 w-40 d-flex-center b-r-50 position-absolute">
                                                                            <i class="ph-bold  ph-lock f-s-18"></i>
                                                                        </span>
                                                                        <span class="privacy-content ms-5 me-2">
                                                                            <span class="mb-0 text-dark txt-ellipsis-1 f-s-16 f-w-500"> production team
                                                                            </span>
                                                                            <span class="mb-0 text-secondary f-s-16">
                                                                                team member can sign in
                                                                            </span>
                                                                        </span>
                                                                    </span>
                                                            </label>

                                                            <input checked
                                                                   class="form-check-input b-r-100 w-25 h-25"
                                                                   id="inlineCheckbox4" name="useroption"
                                                                   type="radio" value="useroption2">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class=" col-xxl-6">
                                                    <div class="setting-privacy-card form-selectgroup">
                                                        <div class="select-item">
                                                            <label class="form-check-label" for="inlineCheckbox5">
                                                                    <span
                                                                            class="d-flex align-items-center position-relative">
                                                                        <span
                                                                                class="privacy-img bg-info h-40 w-40 d-flex-center b-r-50 position-absolute">
                                                                            <i class="ph-bold  ph-lock f-s-18"></i>
                                                                        </span>
                                                                        <span class="privacy-content ms-5 me-2">
                                                                            <span class="mb-0 text-dark txt-ellipsis-1 f-s-16 f-w-500">Anyone from domain</span>
                                                                            <span class="mb-0 text-secondary f-s-16">
                                                                                users
                                                                                with your eamil domain</span>
                                                                        </span>
                                                                    </span>
                                                            </label>

                                                            <input checked
                                                                   class="form-check-input b-r-100 w-25 h-25"
                                                                   id="inlineCheckbox5" name="useroption"
                                                                   type="radio" value="useroption3">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class=" col-xxl-6">
                                                    <div class="setting-privacy-card form-selectgroup">
                                                        <div class="select-item">
                                                            <label class="form-check-label" for="inlineCheckbox6">
                                                                    <span
                                                                            class="d-flex align-items-center position-relative">
                                                                        <span
                                                                                class="privacy-img bg-danger h-40 w-40 d-flex-center b-r-50 position-absolute">
                                                                            <i class="ph-bold  ph-lock f-s-18"></i>
                                                                        </span>
                                                                        <span class="privacy-content ms-5 me-2">
                                                                            <span class="mb-0 text-dark txt-ellipsis-1 f-s-16 f-w-500">Any email in table</span>
                                                                            <span class="mb-0 text-secondary f-s-16">Anyone
                                                                                included email in a table</span>
                                                                        </span>
                                                                    </span>
                                                            </label>

                                                            <input checked
                                                                   class="form-check-input b-r-100 w-25 h-25"
                                                                   id="inlineCheckbox6" name="useroption"
                                                                   type="radio" value="useroption4">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class=" col-xxl-12">
                                                    <div class="publishe-card">
                                                        <div>
                                                            <h6 class="m-0">Publishing</h6>
                                                            <p class="mb-0 f-s-16 text-secondary">your project is
                                                                published</p>
                                                        </div>
                                                        <div>
                                                            <button class="btn btn-light-primary"
                                                                    type="button">Unpublish
                                                            </button>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div aria-labelledby="notification-tab" class="tab-pane fade" id="notification-tab-pane"
                                     role="tabpanel" tabindex="0">

                                    <div class="card">
                                        <div class="card-header">
                                            <h5>Notification</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="notification-content">
                                                
                                                <div class="col-12">
                                                    <ul class="notified-contet share-menu-list">

                                                        <li>
                                                            <div class="share-menu-item mb-4">
                                                                    <!--<span-->
                                                                    <!--        class="share-menu-img text-outline-primary h-45 w-45 d-flex-center b-r-10">-->
                                                                    <!--    <i-->
                                                                    <!--            class="ph-bold  ph-device-mobile-speaker f-s-30"></i>-->
                                                                    <!--</span>-->
                                                                <div class="share-menu-content m-0">
                                                                    <h6 class="mb-0 txt-ellipsis-1">Account Mails</h6>
                                                                    <p class="mb-0 txt-ellipsis-1 text-secondary">
                                                                        Receive the all your 
                                                                        notifications via Email</p>
                                                                </div>
                                                                <div class="form-check form-switch d-flex mt-1">

                                                                    <input checked
                                                                           class="form-check-input  form-check-primary ms-3 fs-3 me-3"
                                                                           id="basic-switch-6" type="checkbox">
                                                                    <label class="form-check-label pt-2"
                                                                           for="basic-switch-6"></label>
                                                                </div>
                                                            </div>


                                                        </li>
                                                        <li>
                                                            <div class="share-menu-item mb-4">
                                                                    <!--<span-->
                                                                    <!--        class="share-menu-img text-outline-success h-45 w-45 d-flex-center b-r-10">-->
                                                                    <!--    <i class="ph-bold  ph-desktop f-s-30"></i>-->
                                                                    <!--</span>-->
                                                                <div class="share-menu-content m-0">
                                                                    <h6 class="mb-0 txt-ellipsis-1">Promotional Mails</h6>
                                                                    <p class="mb-0 txt-ellipsis-1 text-secondary">
                                                                        Receive the all Promotional
                                                                        mails</p>
                                                                </div>
                                                                <div class="form-check form-switch d-flex mt-1">

                                                                    <input checked
                                                                           class="form-check-input  form-check-primary ms-3 fs-3 me-3"
                                                                           id="basic-switch-4" type="checkbox">
                                                                    <label class="form-check-label pt-2"
                                                                           for="basic-switch-4"></label>
                                                                </div>
                                                            </div>


                                                        </li>
                                                    </ul>
                                                </div>

                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div aria-labelledby="subscription-tab" class="tab-pane fade" id="subscription-tab-pane"
                                     role="tabpanel" tabindex="0">
                                    <div class="card">
                                        <div class="card-header">
                                            <h5>Subscription</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="subscription-plan">
                                                <div class="row">
                                                    <div class="col-xxl-6">
                                                        <div class="plan-choose">
                                                            <h6 class="mb-0">Choose plan</h6>
                                                            <div>
                                                                <button class="btn btn-light-primary"
                                                                        type="button">Quartely
                                                                </button>
                                                                <button class="btn btn-light-secondary"
                                                                        type="button">Yearly
                                                                </button>
                                                            </div>
                                                        </div>
                                                        <div class="form-selectgroup mt-5">
                                                            <div class="select-item">
                                                                <input checked
                                                                       class="form-check-input form-check-primary w-20 h-20"
                                                                       id="planCheckbox1"
                                                                       name="planoption" type="radio"
                                                                       value="planoption1">
                                                                <label class="form-check-label"
                                                                       for="planCheckbox1">
                                                                        <span class="d-flex align-items-center">
                                                                            <span class="ms-2">
                                                                                <span class="fs-6 mb-0">Mark Moen</span>
                                                                                <span class="d-block text-secondary mb-0">
                                                                                    UI/UX
                                                                                    Designer</span>
                                                                            </span>
                                                                        </span>
                                                                </label>
                                                                <div class="select-item-2 ms-2">
                                                                    <h6 class="fs-6 mb-0">$69.44</h6>
                                                                    <p class="text-secondary">1 users/quartly</p>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="form-selectgroup mt-4">
                                                            <div class="select-item">
                                                                <input class="form-check-input form-check-primary w-20 h-20"
                                                                       id="planCheckbox2" name="planoption"
                                                                       type="radio" value="planoption2">
                                                                <label class="form-check-label"
                                                                       for="planCheckbox2">
                                                                        <span class="d-flex align-items-center">
                                                                            <span class="ms-2">
                                                                                <span class="fs-6 mb-0">Mark Moen</span>
                                                                                <span class="d-block text-secondary">UI/UX
                                                                                    Designer</span>
                                                                            </span>
                                                                        </span>
                                                                </label>
                                                                <div class="select-item-2 ms-2">
                                                                    <h6 class="fs-6 mb-0">$69.44</h6>
                                                                    <p class="text-secondary">1 users/quartly</p>
                                                                </div>
                                                            </div>

                                                            <ul class="feachers-list">
                                                                <li class="f-s-16 text-secondary"><i
                                                                        class="ph-bold  ph-check-circle me-2 f-s-16 text-success"></i>40
                                                                    doenload per day.
                                                                </li>
                                                                <li class="f-s-16 text-secondary"><i
                                                                        class="ph-bold  ph-check-circle me-2 f-s-16 text-success"></i>access
                                                                    to all products or bundles.
                                                                </li>
                                                                <li class="f-s-16 text-secondary"><i
                                                                        class="ph-bold  ph-check-circle me-2 f-s-16 text-success"></i>early
                                                                    access to new/beta relese features.
                                                                </li>

                                                            </ul>
                                                            <div class="app-divider-v mt-4 mb-4"></div>
                                                            <div class="team-accounts mb-4">
                                                                    <span class="privacy-content">
                                                                        <span class="mb-0 f-s-16 f-w-500">Team Accounts</span>
                                                                        <span class="text-secondary f-s-14 mb-0">starting
                                                                            at 5
                                                                            users in team plan , you can increase.</span>
                                                                    </span>
                                                                <div class="simplespin ms-3">
                                                                    <button
                                                                            class="circle-btn btn-light-primary decrement">
                                                                        -
                                                                    </button>
                                                                    <input class="app-small-touchspin count"
                                                                           type="text"
                                                                           value="25">
                                                                    <button
                                                                            class="circle-btn btn-light-primary increment">
                                                                        +
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="form-selectgroup mt-4">
                                                            <div class="select-item">
                                                                <input class="form-check-input form-check-primary w-20 h-20"
                                                                       id="planCheckbox3" name="planoption"
                                                                       type="radio" value="planoption3">
                                                                <label class="form-check-label"
                                                                       for="planCheckbox3">
                                                                        <span class="d-flex align-items-center">
                                                                            <span class="ms-2">
                                                                                <span class="fs-6 mb-0">Business Pro</span>
                                                                                <span class="d-block text-secondary mb-0">
                                                                                    for
                                                                                    big teams</span>
                                                                            </span>
                                                                        </span>
                                                                </label>
                                                                <div class="feachers-list ms-2">
                                                                    <h6 class="fs-6 mb-0">$250.44</h6>
                                                                    <p class="text-secondary">31 users/quartly</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-6 mt-xxl-0 mt-5">
                                                        <div class="plan-choose">
                                                            <h6 class="mb-0">My Cards</h6>
                                                            
                                                        </div>
                                                        <div class="form-selectgroup mt-5">
                                                            <div class="select-item d-flex">
                                                                <input class="form-check-input form-check-primary w-20 h-20"
                                                                       id="paymentCheckbox1" name="paymentoption"
                                                                       type="radio" value="paymentoption1">
                                                                <label class="form-check-label"
                                                                       for="paymentCheckbox1">
                                                                        <span class="d-flex align-items-center">
                                                                            <span class="ms-2">
                                                                                <span class="f-s-16 mb-0 f-w-500">**** 4426</span>
                                                                                <span
                                                                                        class="d-block text-secondary f-s-16 mb-0">
                                                                                    visa card</span>
                                                                            </span>
                                                                        </span>
                                                                </label>
                                                                <div class="ms-2">
                                                                    <img alt=""
                                                                         src="<?php echo base_url()?>assets/assets/images/icons/visa-icon.png">
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="form-selectgroup mt-4">
                                                            <div class="select-item d-flex">
                                                                <input checked
                                                                       class="form-check-input form-check-primary w-20 h-20"
                                                                       id="paymentCheckbox2"
                                                                       name="paymentoption" type="radio"
                                                                       value="paymentoption2">
                                                                <label class="form-check-label"
                                                                       for="paymentCheckbox2">
                                                                        <span class="d-flex align-items-center">
                                                                            <span class="ms-2">
                                                                                <span class="f-s-16 mb-0 f-w-500">**** 6790</span>
                                                                                <span
                                                                                        class="d-block text-secondary f-s-16 mb-0">
                                                                                    Master card</span>
                                                                            </span>
                                                                        </span>
                                                                </label>
                                                                <div class="ms-2">
                                                                    <img alt=""
                                                                         src="<?php echo base_url()?>assets/assets/images/icons/master-icon.png">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <button class="btn btn-success w-100 mt-4" type="button">+
                                                            Add New Card
                                                        </button>


                                                        <div class="form-selectgroup p-3 mt-4">

                                                            <h6 class="mb-2">Discount code</h6>
                                                            <div class="input-group mb-3">
                                                                <input aria-describedby="button-addon2"
                                                                       aria-label="Recipient's username"
                                                                       class="form-control form-check-primary b-r-left"
                                                                       placeholder="20FGJKYSD"
                                                                       type="text">
                                                                <button class="btn btn-secondary b-r-right"
                                                                        id="button-addon2" type="button">Apply
                                                                </button>
                                                            </div>

                                                            <P class="text-success f-s-16 mb-0">30% discount code
                                                                applied
                                                            </P>
                                                            <div class="team-accounts mt-3 mb-4 p-0">
                                                                    <span class="privacy-content me-2">
                                                                        <span class="mb-0 f-s-16 f-w-500">Team Plan</span>
                                                                        <span class="text-secondary f-s-14 mb-0">5 Users
                                                                            Quartely</span>
                                                                    </span>
                                                                <h4>$789.0</h4>
                                                            </div>

                                                            <div class="app-divider-v mt-4 mb-4"></div>
                                                            <div class="plan-choose">
                                                                <h6 class="mb-0">Payment plan</h6>
                                                                <h5 class="text-success f-s-18">-$57.90</h5>
                                                            </div>
                                                            <div class="app-divider-v mt-4 "></div>
                                                            <div class="team-accounts mt-3 mb-4 p-0">
                                                                    <span class="privacy-content">
                                                                        <span class="mb-0 f-s-16 f-w-500">Total</span>
                                                                        <span class="text-secondary f-s-14 mb-0">Next
                                                                            payment
                                                                            will charge 10th of january 2030</span>
                                                                    </span>
                                                                <h6>$789.0</h6>
                                                            </div>
                                                            <div class="app-divider-v mt-4"></div>
                                                            <button class="btn btn-success w-100 " type="button">PAY
                                                                NOW
                                                            </button>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div aria-labelledby="Connection-tab" class="tab-pane fade" id="Connection-tab-pane"
                                     role="tabpanel" tabindex="0">
                                    <div class="card p-4">
                                    
                                    <form class="app-form" method="post" action="<?php echo base_url()?>home/updatecompany"   enctype="multipart/form-data">
                                    <h5 class="mb-2 text-dark f-w-600">Company Details</h5>
<div class="row">
    <!-- Company Name -->
    <div class="col-md-6">
        <div class="mb-3">
            <label class="form-label" for="cname">Business Name</label>
            <input class="form-control" id="cname" name="cname" placeholder="Your company name" type="text">
        </div>
    </div>

    <!-- Industry / Niche -->
    <div class="col-md-6">
        <div class="mb-3">
            <label class="form-label" for="industry">Industry / Niche</label>
            <input class="form-control" id="industry" name="industry" placeholder="e.g., Real Estate, Restaurant" type="text">
        </div>
    </div>
    
        <!-- Logo Upload -->
    <div class="col-md-6">
        <div class="mb-3">
            <label class="form-label" for="logo">Upload Logo</label>
            <input class="form-control" id="logo" name="logo" type="file">
        </div>
    </div>
    
    
    <!-- Preferred Colors -->
    <div class="col-md-6">
        <div class="mb-3">
            <label class="form-label" for="colors">Preferred Brand Colors / Style</label>
            <input class="form-control" id="colors" name="colors" placeholder="e.g., Blue and White, Minimal, Bold" type="text">
        </div>
    </div>

    <!-- Location -->
    <div class="col-md-6">
        <div class="mb-3">
            <label class="form-label" for="location">Location</label>
            <input class="form-control" id="location" name="location" placeholder="City & Country" type="text">
        </div>
    </div>

    <!-- Target Audience -->
    <div class="col-md-6">
        <div class="mb-3">
            <label class="form-label" for="audience">Target Audience</label>
            <input class="form-control" id="audience" name="audience" placeholder="e.g., college students, professionals" type="text">
        </div>
    </div>

    <!-- Marketing Goals -->
    <div class="col-md-12">
        <label class="form-label">What do you want to increase?</label>
        <div class="mb-3">
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" name="goals[]" value="Social Media Reach" id="goal1">
                <label class="form-check-label" for="goal1">Social Media Reach</label>
            </div>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" name="goals[]" value="Walk-ins / Footfall" id="goal2">
                <label class="form-check-label" for="goal2">Walk-ins / Footfall</label>
            </div>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" name="goals[]" value="Online Leads" id="goal3">
                <label class="form-check-label" for="goal3">Online Leads</label>
            </div>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" name="goals[]" value="Brand Awareness" id="goal4">
                <label class="form-check-label" for="goal4">Brand Awareness</label>
            </div>
        </div>
    </div>

    <!-- Competitors -->
    <div class="col-md-12">
        <div class="mb-3">
            <label class="form-label" for="competitors">Your Competitors (Links)</label>
            <textarea class="form-control" id="competitors" name="competitors" rows="2"></textarea>
        </div>
    </div>


    
    <!-- Tagline -->
    <div class="col-md-6">
        <div class="mb-3">
            <label class="form-label" for="tagline">Your Brand Tagline (optional)</label>
            <input class="form-control" id="tagline" name="tagline" type="text">
        </div>
    </div>
    
    <!-- Preferred Platforms -->
    <div class="col-md-6">
        <div class="mb-3">
            <label class="form-label" for="platforms">Preferred Platforms</label>
            <input class="form-control" id="platforms" name="platforms" type="text" placeholder="e.g., Instagram, Facebook, YouTube, WhatsApp">
        </div>
    </div>

    
    <!-- Business Vision -->
    <div class="col-md-12">
        <div class="mb-3">
            <label class="form-label" for="vision">Business Vision (Next 1–2 Years)</label>
            <textarea class="form-control" id="vision" name="vision" rows="2" placeholder="What's your dream or goal for your business?"></textarea>
        </div>
    </div>

    <!-- Customer Experience -->
    <div class="col-md-12">
        <div class="mb-3">
            <label class="form-label" for="experience">Expected Customer Experience</label>
            <textarea class="form-control" id="experience" name="experience" rows="2" placeholder="What should people feel when they visit your brand?"></textarea>
        </div>
    </div>

    <!-- Brand Uniqueness -->
    <div class="col-md-12">
        <div class="mb-3">
            <label class="form-label" for="uniqueness">Brand Uniqueness</label>
            <textarea class="form-control" id="uniqueness" name="uniqueness" rows="2" placeholder="What makes your business special to you?"></textarea>
        </div>
    </div>

    
</div>

                                    <div class="app-divider-v mt-0 mb-0 pt-0 "></div>
                                    <div class="row">
                                        
                                        <div class="col-lg-6 col-xxl-6">
                                            <div class="card conection-setting border">
                                                <div class="card-body">
                                                    <div class="conection-item">
                                                        <div class="position-relative">
                                                                <span class="position-absolute">
                                                                    <img alt=""
                                                                         class="w-35 h-35"
                                                                         src="<?php echo base_url()?>assets/assets/images/setting-app/facebook.png">
                                                                </span>
                                                            <h5 class="ms-5 mt-1">Facebook</h5>
                                                        </div>
                                                        <div class="form-check form-switch d-flex mt-1">

                                                            <input checked=""
                                                                   class="form-check-input  form-check-primary fs-3"
                                                                   id="basic-switch-13" type="checkbox">
                                                            <label class="form-check-label pt-2"
                                                                   for="basic-switch-13"></label>
                                                        </div>
                                                    </div>

                                                    
                                                </div>
                                                <div class="card-footer text-end  link-primary">
                                                   <div class="form-floating my-3">
                                                        <input class="form-control" name="fblink" placeholder="https://" required="" type="url">
                                                        <label class="form-label">Facebook Url</label>
                                                    </div>
                                                   <div class="form-floating mb-3">
                                                        <input class="form-control" name="fbapi" placeholder="" required="" type="text">
                                                        <label class="form-label">Facebook API</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6 col-xxl-6">
                                            <div class="card conection-setting border">
                                                <div class="card-body">
                                                    <div class="conection-item">
                                                        <div class="position-relative">
                                                                <span class="position-absolute">
                                                                    <img alt=""
                                                                         class="w-35 h-35"
                                                                         src="<?php echo base_url()?>assets/assets/images/setting-app/instagram.png">
                                                                </span>
                                                            <h5 class="ms-5 mt-1">Instagram</h5>
                                                        </div>
                                                        <div class="form-check form-switch d-flex mt-1">

                                                            <input checked=""
                                                                   class="form-check-input  form-check-primary fs-3"
                                                                   id="basic-switch-14" type="checkbox">
                                                            <label class="form-check-label pt-2"
                                                                   for="basic-switch-14"></label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card-footer text-end  link-primary">
                                                   <div class="form-floating my-3">
                                                        <input class="form-control" name="instalink" placeholder="https://" required="" type="url">
                                                        <label class="form-label">Instagram Url</label>
                                                    </div>
                                                   <div class="form-floating mb-3">
                                                        <input class="form-control" name="instaapi" placeholder="" required="" type="text">
                                                        <label class="form-label">Instagram API</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6 col-xxl-6">
                                            <div class="card conection-setting border">
                                                <div class="card-body">
                                                    <div class="conection-item">
                                                        <div class="position-relative">
                                                                <span class="position-absolute">
                                                                    <img alt=""
                                                                         class="w-35 h-35"
                                                                         src="<?php echo base_url()?>assets/assets/images/setting-app/twitter.png">
                                                                </span>
                                                            <h5 class="ms-5 mt-1">Twitter</h5>
                                                        </div>
                                                        <div class="form-check form-switch d-flex mt-1">

                                                            <input checked=""
                                                                   class="form-check-input  form-check-primary  fs-3"
                                                                   id="basic-switch-15" type="checkbox">
                                                            <label class="form-check-label pt-2"
                                                                   for="basic-switch-15"></label>
                                                        </div>
                                                    </div>

                                                    
                                                </div>
                                                <div class="card-footer text-end  link-primary">
                                                   <div class="form-floating my-3">
                                                        <input class="form-control" name="twitterlink" placeholder="https://" required="" type="url">
                                                        <label class="form-label">Twitter Url</label>
                                                    </div>
                                                   <div class="form-floating mb-3">
                                                        <input class="form-control" name="twitterapi" placeholder="" required="" type="text">
                                                        <label class="form-label">Twitter API</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6 col-xxl-6">
                                            <div class="card conection-setting border">
                                                <div class="card-body">
                                                    <div class="conection-item">
                                                        <div class="position-relative">
                                                                <span class="position-absolute">
                                                                    <img alt=""
                                                                         class="w-35 h-35"
                                                                         src="<?php echo base_url()?>assets/assets/images/setting-app/linkdin.png">
                                                                </span>
                                                            <h5 class="ms-5 mt-1">Linkedin</h5>
                                                        </div>
                                                        <div class="form-check form-switch d-flex mt-1">

                                                            <input checked=""
                                                                   class="form-check-input  form-check-primary fs-3"
                                                                   id="basic-switch-17" type="checkbox">
                                                            <label class="form-check-label pt-2"
                                                                   for="basic-switch-17"></label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card-footer text-end  link-primary">
                                                   <div class="form-floating my-3">
                                                        <input class="form-control" name="linkedinlink" placeholder="https://" required="" type="url">
                                                        <label class="form-label">Linkedin Url</label>
                                                    </div>
                                                   <div class="form-floating mb-3">
                                                        <input class="form-control" name="linkedinapi" placeholder="" required="" type="text">
                                                        <label class="form-label">Linkedin API</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-12">
                                            <div class="text-left">
                                                <button class="btn btn-primary"
                                                        type="submit">Submit
                                                </button>
                                            </div>
                                        </div>
                                        

                                    </div>
                                    </form>
                                    
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--setting app end -->
                </div>
            </main>
            
            

<?php include('footer.php')?>