<?php
$config  = new \Config\App();
$appName = $config->appName . " - Liberary";
include('header.php');
?>

<main>
  <div class="container-fluid">
                    <!-- Breadcrumb start -->
                    <div class="row m-1">
                        <div class="col-12 ">
                            <h4 class="main-title">Liberary</h4>
                            <ul class="app-line-breadcrumbs mb-3">
                                <li>
                                    <a class="f-s-14 f-w-500">List of all Posts </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <!-- Breadcrumb end -->

                    <!-- blog start -->
                    <div class="row blog-section">
                        
                    <?php foreach($calendar_plans as $post){ ?>
                        <!-- Technology start -->
                        <div class="col-md-6 col-lg-4 col-xxl-3">
                            <div class="card blog-card overflow-hidden">
                                <a class="glightbox img-hover-zoom" data-glightbox="type: image; zoomable: true;"
                                   href="<?= base_url('uploads/images/' . $post['image']) ?>">
                                    <img alt="..." class="card-img-top" src="<?= base_url('uploads/images/' . $post['image']) ?>">
                                </a>
                                <div class="tag-container">
                                    <span class="badge text-light-secondary"><?= $post['company_name'] ?></span>
                                </div>
                                <div class="card-body">
                                    <p class="text-body-secondary"><i class="ti ti-calendar-due"></i> <?= $post['date'] ?> <?php if(!empty($post['scheduled_at'])){ echo date('H:i', strtotime($post['scheduled_at'])); }?></p>
                                    
                                    <p class="card-text text-secondary">
                                        <?= $post['caption'] ?>
                                    </p>
                                    <div class="app-divider-v dashed pt-1 pb-2 "></div>
                                    <div class="d-flex justify-content-between align-items-center gap-2 position-relative">
                                        
                                        <div class="">
                                            <!--<h6 class="text-dark f-w-500 mb-0"> Bette Hagenes</h6>-->
                                            <p class="post-status text-secondary mb-0"> <?= $post['plan_status'] ?> </p>
                                        </div>
                                        <div>
                                            <div class="btn-group dropdown-icon-none">
                                                <button aria-expanded="false"
                                                        class="btn border-0 icon-btn b-r-4 dropdown-toggle w-100 h-100"
                                                        data-bs-auto-close="true"
                                                        data-bs-toggle="dropdown" type="button">
                                                    <i class="ti ti-dots-vertical f-s-18 text-dark"></i>
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <?php  if($post['plan_status'] == 'Posted' || $post['plan_status'] == 'Approved'){ ?>
                                                    <li ><button class="dropdown-item text-success post-btn" data-plan-id="<?= $post['id'] ?>" ><i
                                                            class="ti ti-send"></i> Post Now</button></li>
                                                    <?php } 
                                                    if($post['plan_status'] == 'Posted'){?>
                                                    <li data-bs-target="#editModal" data-bs-toggle="modal"><a
                                                            class="dropdown-item text-secondary" href="#"><i
                                                            class="ti ti-archive"></i> Edit Caption</a></li>
                                                    <li class="delete-btn"><a class="dropdown-item text-danger"
                                                                              href="#"><i class="ti ti-trash"></i>
                                                        Delete </a></li>
                                                    <?php } ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Technology end -->
                    <?php } ?>
                    
                    </div>
                    <!-- blog end -->
                </div>
</main>

<!-- Toast container (hidden by default) -->
<div class="position-fixed top-0 end-0 p-3" style="z-index: 1100;">
  <div id="scheduleToast" class="toast align-items-center text-white bg-primary border-0" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="d-flex">
      <div class="toast-body">
        <!-- message will be injected here -->
      </div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
  </div>
</div>

<script>
document.querySelectorAll('.post-btn').forEach(btn => {
  btn.addEventListener('click', async () => {
    const planId = btn.dataset.planId;
    const card = btn.closest('.blog-card');
    const statusEl = card.querySelector('.post-status');
    const originalText = btn.textContent;

    // disable & show posting text
    btn.disabled = true;
    btn.textContent = 'Posting…';

    try {
      const form = new FormData();
      form.append('plan_id', planId);

      const res  = await fetch('<?= base_url('home/postToSocialNow') ?>', {
        method: 'POST',
        headers: { 'X-Requested-With': 'XMLHttpRequest' },
        body: form
      });
      const json = await res.json();

      if (json.success) {
        // update UI on success
        btn.textContent = 'Posted';
        if (statusEl) statusEl.textContent = 'Posted';
      } else {
        throw new Error(json.error || 'Error posting');
      }
    } catch (err) {
      console.error(err);
      // revert on failure
      btn.disabled = false;
      btn.textContent = originalText;
      alert('❌ ' + err.message);
    }
  });
});
</script>

<?php include('footer.php'); ?>
