<?php
$config = new \Config\App();
$appName = $config->appName . " - Ai Planner";
include('header.php') ?>

<style>
    .tab-wrapper .tabs .tab-link:first-child {
    margin-left: 0;
}
.tab-wrapper .tabs .tab-link.active {
    border-radius: 1.5rem;
    border: 2px solid;
}
</style>
<main>
  <div class="container-fluid">
    <!-- Breadcrumb start -->
    <div class="row m-1">
      <div class="col-12 ">
        <h4 class="main-title">AI Planner</h4>
        <span>Generate AI-based Strategies and Company Reviews.</span>
      </div>
    </div>
    <!-- Breadcrumb end -->

    <!-- Projects start -->
    <div class="row">
      <div class="col-12">

        <div class="tab-wrapper mb-3">
          <ul class="tabs flex-wrap p-2">
            <?php if (!empty($accounts)): ?>
              <?php foreach ($accounts as $index => $acct): ?>
                <li class="tab-link py-2 <?= $index === 0 ? 'active' : '' ?>" data-tab="<?= $acct['id'] ?>">
                  <?= esc($acct['name']) ?>
                </li>
              <?php endforeach; ?>
            <?php else: ?>
              <li class="tab-link py-2 active">No Companies</li>
            <?php endif; ?>
          </ul>
        </div>

        <div class="content-wrapper" id="card-container">
          <?php foreach ($accounts as $index => $acct): ?>
            <?php
              $companyId = $acct['id'];
              $strategies = array_filter($planners, fn($p) => $p['cid'] == $companyId && $p['statigies']);
              $reviews    = array_filter($planners, fn($p) => $p['cid'] == $companyId && $p['reviews']);
            ?>
            <div class="tabs-content <?= $index === 0 ? 'active' : '' ?>" id="tab-<?= $acct['id'] ?>">
              <div class="row">

                <!-- Strategies Card -->
                <div class="col-md-6 col-xl-6 project-card">
                  <div class="card hover-effect">
                    <div class="card-header">
                      <div class="d-flex align-items-center">
                        <!--<div class="h-40 w-40 d-flex-center b-r-50 overflow-hidden">-->
                        <!--  <img alt="" class="img-fluid" src="<?= base_url() ?>assets/assets/images/icons/logo1.png">-->
                        <!--</div>-->
                        <div class="flex-grow-1 ps-2">
                          <h6 class="m-0 text-dark f-w-600"> <?= esc($acct['name']) ?></h6>
                          <div class="text-muted f-s-14 f-w-500">Strategies</div>
                        </div>
                        <div class="dropdown">
                          <button class="btn btn-primary  h-45 b-r-10 m-2 generate-btn" 
                                  data-cid="<?= $acct['id'] ?>" data-type="strategy">
                             Generate
                          </button>
                          <button class="btn btn-primary  h-45 b-r-10 m-2 ml-0 px-3 download-btn" 
                                  data-cid="<?= $acct['id'] ?>" data-type="strategy" data-name="<?= esc($acct['name']) ?>">
                             <i class="iconoir-download"></i>
                          </button>
                        </div>
                      </div>
                    </div>
                    <div class="card-body strategy-content-<?= $acct['id'] ?>">
                      <?php if (!empty($strategies)): ?>
                        <span class="text-muted f-s-14 text-secondary"> <?= reset($strategies)['statigies'] ?> </span>
                      <?php else: ?>
                        <div class="text-muted f-s-14 text-secondary"> No strategies available. Click Generate. </div>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>

                <!-- Reviews Card -->
                <div class="col-md-6 col-xl-6 project-card">
                  <div class="card hover-effect">
                    <div class="card-header">
                      <div class="d-flex align-items-center">
                        <!--<div class="h-40 w-40 d-flex-center b-r-50 overflow-hidden">-->
                        <!--  <img alt="" class="img-fluid" src="<?= base_url() ?>assets/assets/images/icons/logo1.png">-->
                        <!--</div>-->
                        <div class="flex-grow-1 ps-2">
                          <h6 class="m-0 text-dark f-w-600"> <?= esc($acct['name']) ?></h6>
                          <div class="text-muted f-s-14 f-w-500">Reviews</div>
                        </div>
                        <div class="dropdown">
                          <button class="btn btn-primary h-45 b-r-10 m-2 generate-btn" 
                                  data-cid="<?= $acct['id'] ?>" data-type="review">
                            Generate
                          </button>
                          <button class="btn btn-primary  h-45 b-r-10 m-2 ml-0 px-3 download-btn" 
                                  data-cid="<?= $acct['id'] ?>" data-type="review" data-name="<?= esc($acct['name']) ?>">
                             <i class="iconoir-download"></i>
                          </button>
                        </div>
                      </div>
                    </div>
                    <div class="card-body review-content-<?= $acct['id'] ?>">
                      <?php if (!empty($reviews)): ?>
                        <span class="text-muted f-s-14 text-secondary"> <?= reset($reviews)['reviews'] ?> </span>
                      <?php else: ?>
                        <div class="text-muted f-s-14 text-secondary"> No reviews available. Click Generate. </div>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>

              </div>
            </div>
          <?php endforeach; ?>
        </div>

      </div>
    </div>
    <!-- Projects end -->
  </div>
</main>

<script>
  document.querySelectorAll('.generate-btn').forEach(btn => {
    btn.addEventListener('click', function () {
      const cid = this.dataset.cid;
      const type = this.dataset.type;
      const contentBox = document.querySelector(`.${type}-content-${cid}`);
      const originalText = contentBox.innerHTML;

      this.disabled = true;
      contentBox.innerHTML = `<p class="card-text placeholder-glow">
        <span class="placeholder col-6 bg-secondary"></span>
        <span class="placeholder col-4 bg-secondary"></span>
        <span class="placeholder col-2 bg-secondary"></span>
        <span class="placeholder col-9 bg-secondary"></span>
        <span class="placeholder col-7 bg-secondary"></span>
      </p>`;

      const url = type === 'strategy' 
        ? "<?= base_url('home/generateStrategy') ?>"
        : "<?= base_url('home/generatereview') ?>";

      fetch(url, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify({ cid })
      })
      .then(res => res.json())
      .then(data => {
        contentBox.innerHTML = `<span class='text-muted f-s-14 text-secondary'>${data.generated}</span>`;
        this.disabled = false;
      })
      .catch(err => {
        contentBox.innerHTML = originalText;
        alert("Failed to generate. Please try again.");
        this.disabled = false;
      });
    });
  });
  
  
    // Download handlers
  document.querySelectorAll('.download-btn').forEach(btn => {
  btn.addEventListener('click', () => {
    const cid   = btn.dataset.cid;
    const type  = btn.dataset.type;
    const name  = btn.dataset.name;            // ← your company name
    const contentBox = document.querySelector(`.${type}-content-${cid}`);
    const text  = contentBox.innerText.trim();

    if (!text) {
      return alert("Nothing to download.");
    }

    // build the file
    const blob = new Blob([text], { type: 'text/plain' });
    const url  = URL.createObjectURL(blob);
    const a    = document.createElement('a');
    a.href     = url;
    a.download = `${name} - ${type}.txt`;       // ← company name - type.txt
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    URL.revokeObjectURL(url);
  });
});
</script>

<?php include('footer.php') ?>
