<?php
/**
 * BulkSendResponse
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The Docusign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Docusign eSignature REST API
 *
 * The Docusign eSignature REST API provides you with a powerful, convenient, and simple Web services API for interacting with Docusign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * BulkSendResponse Class Doc Comment
 *
 * @category    Class
 * @description The object contains the response to a bulk send request.
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The Docusign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BulkSendResponse implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'bulkSendResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'batch_id' => '?string',
        'batch_name' => '?string',
        'batch_size' => '?string',
        'envelope_or_template_id' => '?string',
        'error_details' => '?string[]',
        'errors' => '?string[]',
        'queue_limit' => '?string',
        'total_queued' => '?string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'batch_id' => null,
        'batch_name' => null,
        'batch_size' => null,
        'envelope_or_template_id' => null,
        'error_details' => null,
        'errors' => null,
        'queue_limit' => null,
        'total_queued' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'batch_id' => 'batchId',
        'batch_name' => 'batchName',
        'batch_size' => 'batchSize',
        'envelope_or_template_id' => 'envelopeOrTemplateId',
        'error_details' => 'errorDetails',
        'errors' => 'errors',
        'queue_limit' => 'queueLimit',
        'total_queued' => 'totalQueued'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'batch_id' => 'setBatchId',
        'batch_name' => 'setBatchName',
        'batch_size' => 'setBatchSize',
        'envelope_or_template_id' => 'setEnvelopeOrTemplateId',
        'error_details' => 'setErrorDetails',
        'errors' => 'setErrors',
        'queue_limit' => 'setQueueLimit',
        'total_queued' => 'setTotalQueued'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'batch_id' => 'getBatchId',
        'batch_name' => 'getBatchName',
        'batch_size' => 'getBatchSize',
        'envelope_or_template_id' => 'getEnvelopeOrTemplateId',
        'error_details' => 'getErrorDetails',
        'errors' => 'getErrors',
        'queue_limit' => 'getQueueLimit',
        'total_queued' => 'getTotalQueued'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['batch_id'] = isset($data['batch_id']) ? $data['batch_id'] : null;
        $this->container['batch_name'] = isset($data['batch_name']) ? $data['batch_name'] : null;
        $this->container['batch_size'] = isset($data['batch_size']) ? $data['batch_size'] : null;
        $this->container['envelope_or_template_id'] = isset($data['envelope_or_template_id']) ? $data['envelope_or_template_id'] : null;
        $this->container['error_details'] = isset($data['error_details']) ? $data['error_details'] : null;
        $this->container['errors'] = isset($data['errors']) ? $data['errors'] : null;
        $this->container['queue_limit'] = isset($data['queue_limit']) ? $data['queue_limit'] : null;
        $this->container['total_queued'] = isset($data['total_queued']) ? $data['total_queued'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets batch_id
     *
     * @return ?string
     */
    public function getBatchId()
    {
        return $this->container['batch_id'];
    }

    /**
     * Sets batch_id
     *
     * @param ?string $batch_id 
     *
     * @return $this
     */
    public function setBatchId($batch_id)
    {
        $this->container['batch_id'] = $batch_id;

        return $this;
    }

    /**
     * Gets batch_name
     *
     * @return ?string
     */
    public function getBatchName()
    {
        return $this->container['batch_name'];
    }

    /**
     * Sets batch_name
     *
     * @param ?string $batch_name 
     *
     * @return $this
     */
    public function setBatchName($batch_name)
    {
        $this->container['batch_name'] = $batch_name;

        return $this;
    }

    /**
     * Gets batch_size
     *
     * @return ?string
     */
    public function getBatchSize()
    {
        return $this->container['batch_size'];
    }

    /**
     * Sets batch_size
     *
     * @param ?string $batch_size 
     *
     * @return $this
     */
    public function setBatchSize($batch_size)
    {
        $this->container['batch_size'] = $batch_size;

        return $this;
    }

    /**
     * Gets envelope_or_template_id
     *
     * @return ?string
     */
    public function getEnvelopeOrTemplateId()
    {
        return $this->container['envelope_or_template_id'];
    }

    /**
     * Sets envelope_or_template_id
     *
     * @param ?string $envelope_or_template_id 
     *
     * @return $this
     */
    public function setEnvelopeOrTemplateId($envelope_or_template_id)
    {
        $this->container['envelope_or_template_id'] = $envelope_or_template_id;

        return $this;
    }

    /**
     * Gets error_details
     *
     * @return ?string[]
     */
    public function getErrorDetails()
    {
        return $this->container['error_details'];
    }

    /**
     * Sets error_details
     *
     * @param ?string[] $error_details Array or errors.
     *
     * @return $this
     */
    public function setErrorDetails($error_details)
    {
        $this->container['error_details'] = $error_details;

        return $this;
    }

    /**
     * Gets errors
     *
     * @return ?string[]
     */
    public function getErrors()
    {
        return $this->container['errors'];
    }

    /**
     * Sets errors
     *
     * @param ?string[] $errors 
     *
     * @return $this
     */
    public function setErrors($errors)
    {
        $this->container['errors'] = $errors;

        return $this;
    }

    /**
     * Gets queue_limit
     *
     * @return ?string
     */
    public function getQueueLimit()
    {
        return $this->container['queue_limit'];
    }

    /**
     * Sets queue_limit
     *
     * @param ?string $queue_limit 
     *
     * @return $this
     */
    public function setQueueLimit($queue_limit)
    {
        $this->container['queue_limit'] = $queue_limit;

        return $this;
    }

    /**
     * Gets total_queued
     *
     * @return ?string
     */
    public function getTotalQueued()
    {
        return $this->container['total_queued'];
    }

    /**
     * Sets total_queued
     *
     * @param ?string $total_queued 
     *
     * @return $this
     */
    public function setTotalQueued($total_queued)
    {
        $this->container['total_queued'] = $total_queued;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

