<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\Email\Email;
use App\Libraries\CSVReader;
use App\Models\UserModel; // Import the UserModel

use CodeIgniter\RESTful\ResourceController;
use Config\Services;

class Home extends BaseController
{
    protected $userModel;

    public function __construct()
    {
        $this->userModel = new UserModel(); // Initialize the model globally
    }

public function index()
{
    if (!session()->get('logged_in')) {
        return redirect()->to('/login');
    }

    $db = \Config\Database::connect();

$data = [];

        return view('home', $data);
  
}

    public function calender_plan()
    {
        // 1) Ensure logged in
        if (! session()->get('logged_in')) {
            return redirect()->to('/login');
        }

        $db     = \Config\Database::connect();
        $userId = session()->get('user_id');

        // 2) Fetch all companies for this user
        $owned = $db->table('company_profiles')
                    ->where('uid', $userId)
                    ->orderBy('name','ASC')
                    ->get()
                    ->getResultArray();

        // 3) Extract just the IDs
        $ownedIds = array_column($owned, 'id');

        // 4) Fetch *all* calendar_plans for any of those companies
        $plans = [];
        if (! empty($ownedIds)) {
            $plans = $db->table('calendar_plans')
                        ->whereIn('company_id', $ownedIds)
                        ->where('user_id',     $userId)
                        ->where('status',     '1')
                        ->orderBy('date',      'ASC')
                        ->get()
                        ->getResultArray();
        }

        // 5) Pass both arrays into the view
        return view('calender_plan', [
            'accounts' => $owned,
            'plans'    => $plans,
        ]);
    }
    
    
    
    public function liberary()
{
    if (!session()->get('logged_in')) {
        return redirect()->to('/login');
    }

    $db = \Config\Database::connect();
    $userId = session()->get('user_id');

    $calendar_plans = $db->table('calendar_plans AS cp')
        ->select('cp.*, c.name AS company_name')
        ->join('company_profiles AS c', 'c.id = cp.company_id')
        ->where('cp.user_id', $userId)
        ->where('cp.status', '1')
        ->where('cp.image IS NOT NULL', null, false)
        ->where('cp.image <>', '')
        ->orderBy("CAST(cp.date AS DATE)", 'DESC', false)
        ->get()
        ->getResultArray();

    return view('liberary', [
        'calendar_plans' => $calendar_plans,
    ]);

  
}

public function approvePlan()
{
    helper('session');
    $db     = \Config\Database::connect();
    $userId = session()->get('user_id');
    $body   = json_decode($this->request->getBody(), true) ?: [];

    // 1) Must be logged in
    if (! $userId) {
        return $this->response
                    ->setStatusCode(401)
                    ->setJSON(['success' => false, 'message' => 'Not logged in']);
    }

    // 2) Bulk‐approve only the submitted IDs
    if (! empty($body['plan_ids']) && is_array($body['plan_ids'])) {
        // Sanitize to integers
        $ids = array_map('intval', $body['plan_ids']);
        if (empty($ids)) {
            return $this->response
                        ->setStatusCode(400)
                        ->setJSON(['success' => false, 'message' => 'No valid plan_ids']);
        }

        // Ensure these belong to this user
        $owned = $db->table('calendar_plans')
                    ->select('id')
                    ->whereIn('id', $ids)
                    ->where('user_id', $userId)
                    ->get()
                    ->getResultArray();
        $ownedIds = array_column($owned, 'id');
        if (empty($ownedIds)) {
            return $this->response
                        ->setStatusCode(403)
                        ->setJSON(['success' => false, 'message' => 'Access denied']);
        }

        // Perform the update on just those owned IDs
        $updated = $db->table('calendar_plans')
                      ->whereIn('id', $ownedIds)
                      ->update(['status' => 1]);

        return $this->response
                    ->setJSON(['success' => (bool)$updated]);
    }

    // 3) Fallback: if single plan_id was sent
    if (! empty($body['plan_id'])) {
        $planId = intval($body['plan_id']);
        // verify ownership
        $owns = $db->table('calendar_plans')
                   ->where('id',      $planId)
                   ->where('user_id', $userId)
                   ->get()
                   ->getRow();
        if (! $owns) {
            return $this->response
                        ->setStatusCode(403)
                        ->setJSON(['success' => false, 'message' => 'Access denied']);
        }

        $updated = $db->table('calendar_plans')
                      ->where('id', $planId)
                      ->update(['status' => 1]);

        return $this->response
                    ->setJSON(['success' => (bool)$updated]);
    }

    // 4) Bad request if neither key present
    return $this->response
                ->setStatusCode(400)
                ->setJSON(['success' => false, 'message' => 'Missing plan_ids or plan_id']);
}


public function edit_plan()
{
    if (!session()->get('logged_in')) {
        return redirect()->to('/login');
    }

    $db = \Config\Database::connect();
    $userId = session()->get('user_id');

    // ✅ Correct way to get segment
    $id = $this->request->getUri()->getSegment(3);

    $plan = $db->table('calendar_plans')
               ->where('id', $id)
               ->where('user_id', $userId)
               ->get()
               ->getRow();

    if (! $plan) {
        return redirect()->back()->with('error', 'Plan not found or access denied.');
    }

    return view('edit_plan', ['plan' => $plan]);
}

public function update_plan()
{
    if (!session()->get('logged_in')) {
        return redirect()->to('/login');
    }

    $db     = \Config\Database::connect();
    $userId = session()->get('user_id');
    $request = service('request');

    // Retrieve POST data
    $id             = $request->getPost('id');
    $description    = $request->getPost('description');
    $designerBrief  = $request->getPost('designer_brief');
    $caption        = $request->getPost('caption');
    $content        = $request->getPost('content');

    // Verify that the calendar plan exists and belongs to the user
    $existing = $db->table('calendar_plans')
                   ->where('id', $id)
                   ->where('user_id', $userId)
                   ->get()
                   ->getRow();

    if (! $existing) {
        return redirect()->back()->with('error', 'Access denied or plan not found.');
    }

    // Update the plan
    $db->table('calendar_plans')
       ->where('id', $id)
       ->update([
           'description'    => $description,
           'designer_brief' => $designerBrief,
           'caption'        => $caption,
           'content'        => $content
       ]);

    // Get user email
    $user = $db->table('codeigniter_register')->where('id', $userId)->get()->getRow();

    if ($user && $user->email) {
        // Load PHPMailer
require_once APPPATH . 'ThirdParty/PHPMailer/src/PHPMailer.php';
require_once APPPATH . 'ThirdParty/PHPMailer/src/SMTP.php';
require_once APPPATH . 'ThirdParty/PHPMailer/src/Exception.php';


        $mail = new \PHPMailer\PHPMailer\PHPMailer(true);

        try {
            
            // SMTP config
            $mail->isSMTP();
            $mail->Host       = 'thebrandchimp.com';     // Change to your SMTP host
            $mail->SMTPAuth   = true;
            $mail->Username   = 'test@thebrandchimp.com';          // Your SMTP username
            $mail->Password   = 'Olivya7788@';            // Your SMTP password
            $mail->SMTPSecure = 'ssl';                     // Use 'ssl' or 'tls'
            $mail->Port       = 465;

            // Email settings
            $mail->setFrom('test@thebrandchimp.com', 'Ai Digital');
            $mail->addAddress($user->email, $user->name);

            $mail->isHTML(true);
            $mail->Subject = 'Calendar Plan Updated';
            $mail->Body    = "
                <h3>Hello {$user->name},</h3>
                <p>Your calendar plan titled <strong>{$existing->title}</strong> dated <strong>{$existing->date}</strong> has been updated.</p>
                <p><strong>Updated Details:</strong></p>
                <ul>
                    <li><strong>Description:</strong> {$description}</li>
                    <li><strong>Designer Brief:</strong> {$designerBrief}</li>
                    <li><strong>Caption:</strong> {$caption}</li>
                    <li><strong>Content:</strong> {$content}</li>
                </ul>
                <p>If you did not request this change, please contact support.</p>
                <br>
                <p>Regards,<br><strong>Ai digital</strong></p>
            ";

            $mail->send();

        } catch (\PHPMailer\PHPMailer\Exception $e) {
            log_message('error', 'PHPMailer Error: ' . $mail->ErrorInfo);
        }
    }

    return redirect()->to('image_generation')->with('success', 'Calendar plan updated and email sent.');
}

public function create_post($postId = null)
{
    helper('url');
    $db = \Config\Database::connect();

    if (! session()->get('logged_in')) {
        return redirect()->to('/login');
    }

    if ($postId === null) {
        $postId = $this->request->uri->getSegment(3);
    }

    if (! $postId) {
        return redirect()->back()->with('error','Plan ID is missing.');
    }

    $plans = $db->table('calendar_plans')
                ->where('id', $postId)
                ->get()
                ->getRowArray();

    $company = $db->table('company_profiles')
                  ->where('id',  $plans['company_id'])
                  ->where('uid', session()->get('user_id'))
                  ->get()
                  ->getRowArray();

    if (! $company) {
        return redirect()->back()->with('error','Company not found or access denied.');
    }

    $chats = $db->table('image_messages')
                ->where('post_id', $postId)
                ->orderBy('created_at','ASC')
                ->get()
                ->getResultArray();
                
    $images = $db->table('generated_images')
                ->where('plan_id', $postId)
                ->orderBy('created_at','DESC')
                ->get()
                ->getResultArray();

    return view('create_post', [
        'company' => $company,
        'chats'   => $chats,
        'plans'   => $plans,
        'images'  => $images
    ]);
}


public function create_plan($companyId = null)
{
    helper('url');
    // local DB connection
    $db = \Config\Database::connect();

    // auth check
    if (! session()->get('logged_in')) {
        return redirect()->to('/login');
    }

    // grab from URI if not passed
    if ($companyId === null) {
        $companyId = $this->request->uri->getSegment(3);
    }
    if (! $companyId) {
        return redirect()->back()->with('error','Company ID is missing.');
    }

    // now use $db instead of $this->db
    $company = $db
                ->table('company_profiles')
                ->where('id',  $companyId)
                ->where('uid', session()->get('user_id'))
                ->get()
                ->getRowArray();

    if (! $company) {
        return redirect()->back()->with('error','Company not found or access denied.');
    }

    // load past chats
    $chats = $db
              ->table('chat_messages')
              ->where('company_id', $companyId)
              ->orderBy('created_at','ASC')
              ->get()
              ->getResultArray();

    // load past plans
    $currentMonth = date('m');
    $currentYear  = date('Y');
    
    $plans = $db
        ->table('calendar_plans')
        ->where('company_id', $companyId)
        ->where('MONTH(date)', $currentMonth)
        ->where('YEAR(date)', $currentYear)
        ->orderBy('date', 'ASC')
        ->get()
        ->getResultArray();


    return view('create_plan', [
        'company' => $company,
        'chats'   => $chats,
        'plans'   => $plans,
    ]);
}


public function generateCalendarPlan()
{
    helper('text','session');

    // 1) Setup & auth
    $db      = \Config\Database::connect();
    $userId  = session()->get('user_id');
    if (! $userId) {
        return $this->response->setJSON([
            'ai_reply'      => '❗️ You must be logged in.',
            'calendar_plan' => []
        ]);
    }
    $companyId = $this->request->getPost('company_id');
    $userMsg   = trim($this->request->getPost('message'));

    // Load company for AI context
    $company = $db->table('company_profiles')
                  ->where('id',   $companyId)
                  ->where('uid',  $userId)
                  ->get()
                  ->getRowArray();
    if (! $company) {
        return $this->response->setJSON([
            'ai_reply'      => '❗️ Company not found or access denied.',
            'calendar_plan' => []
        ]);
    }

    // 2) Persist user message
    if ($companyId && $userId && $userMsg) {
        $db->table('chat_messages')->insert([
            'user_id'    => $userId,
            'company_id' => $companyId,
            'role'       => 'user',
            'message'    => $userMsg,
        ]);
    }

    // 3) Load this month's existing plan
    $firstOfMonth = date('Y-m-01');
    $lastOfMonth  = date('Y-m-t');
    $rows = $db->table('calendar_plans')
               ->where('company_id',$companyId)
               ->where('user_id',   $userId)
               ->where('date >=',   $firstOfMonth)
               ->where('date <=',   $lastOfMonth)
               ->orderBy('date','ASC')
               ->get()
               ->getResultArray();

    $existingPlan = [];
    foreach ($rows as $r) {
        $existingPlan[] = [
            'date'           => date('d-m-Y', strtotime($r['date'])),
            'type'           => $r['type'],
            'title'          => $r['title'],
            'content'        => $r['content'],
            'description'    => $r['description'],
            'designer_brief' => $r['designer_brief'],
            'caption'        => $r['caption'],
            'status'         => intval($r['status'] ?? 0),
        ];
    }

    // 4) Build AI prompts
    $today     = date('d-m-Y');
    $monthName = date('F');
    $year      = date('Y');
    $endDate   = date('t-m-Y');

    // 4a) Default instruction if user message is too short
    if (empty($userMsg) || strlen($userMsg) < 5) {
        $userMsg = "Create a detailed social media calendar plan for {$monthName} {$year}, " .
                   "from {$today} through {$endDate}, based on the company's profile.";
    }

    if (empty($existingPlan)) {
        // Initial creation
        $systemMessage = <<<SYS
You are a Senior Social Media manager. Create a social media calendar for {$monthName} {$year}, 
covering dates from {$today} through {$endDate}, based solely on the company's profile. 
Return exactly one JSON object with:
- ai_reply: one-sentence summary.
- calendar_plan: array of {date,type,title,content,description,designer_brief,caption}.
SYS;
        $userContent = <<<USR
Business Name: {$company['name']}
Industry:      {$company['industry']}
Tagline:       {$company['tagline']}
Unique Value:  {$company['uniqueness']}
Goals:         {$company['goals']}
Instruction: {$userMsg}
USR;
    } else {
        // Modification
        $planJson = json_encode($existingPlan, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
        $systemMessage = <<<SYS
You are a Senior Social media manager. Today's date: {$today}.
Current plan for {$monthName} {$year}:
{$planJson}

Instruction: "{$userMsg}"
Return exactly one JSON with ai_reply and calendar_plan.
SYS;
        $userContent = $userMsg;
    }

    // 5) Call AI
    try {
        $rawReply = $this->callChatGPT(
            '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',
            [
                ['role'=>'system','content'=>$systemMessage],
                ['role'=>'user',  'content'=>$userContent],
            ]
        );
    } catch (\Throwable $e) {
        // AI call failed: still return existing plan
        return $this->response->setJSON([
            'ai_reply'      => '❗️ AI error: '.$e->getMessage(),
            'calendar_plan' => $existingPlan,
        ]);
    }

    // 6) Extract JSON body
    $start = strpos($rawReply, '{');
    $end   = strrpos($rawReply, '}');
    if ($start === false || $end === false) {
        // Fallback if no JSON found
        return $this->response->setJSON([
            'ai_reply'      => '✅ Here is your current calendar plan.',
            'calendar_plan' => $existingPlan,
        ]);
    }
    $jsonStr = substr($rawReply, $start, $end - $start + 1);
    $data    = json_decode($jsonStr, true);

    // 7) Validate structure
    if (! is_array($data) || ! isset($data['calendar_plan']) || ! is_array($data['calendar_plan'])) {
        return $this->response->setJSON([
            'ai_reply'      => '✅ Here is your current calendar plan.',
            'calendar_plan' => $existingPlan,
        ]);
    }

    // 8) Handle empty plan array
    if (empty($data['calendar_plan'])) {
        return $this->response->setJSON([
            'ai_reply'      => $data['ai_reply'] ?? '✅ No changes needed; here is the existing plan.',
            'calendar_plan' => $existingPlan,
        ]);
    }

    // 9) Save and replace
    try {
        $db->table('chat_messages')->insert([
            'user_id'    => $userId,
            'company_id' => $companyId,
            'role'       => 'ai',
            'message'    => $data['ai_reply'],
        ]);
        $db->table('calendar_plans')
           ->where('company_id',$companyId)
           ->where('user_id',$userId)
           ->where('date >=',$firstOfMonth)
           ->where('date <=',$lastOfMonth)
           ->delete();
        foreach ($data['calendar_plan'] as $item) {
            $db->table('calendar_plans')->insert([
                'user_id'        => $userId,
                'company_id'     => $companyId,
                'date'           => date('Y-m-d', strtotime($item['date'])),
                'type'           => $item['type'] ?? 'Poster',
                'title'          => $item['title'] ?? '',
                'content'        => $item['content'] ?? ($item['description'] ?? ''),
                'description'    => $item['description'] ?? '',
                'designer_brief' => $item['designer_brief'] ?? '',
                'caption'        => $item['caption'] ?? '',
                'status'         => 0,
            ]);
        }
        $newRows = $db->table('calendar_plans')
                      ->where('company_id',$companyId)
                      ->where('user_id',$userId)
                      ->where('date >=',$firstOfMonth)
                      ->where('date <=',$lastOfMonth)
                      ->orderBy('date','ASC')
                      ->get()
                      ->getResultArray();
        $outPlan = [];
        foreach ($newRows as $r) {
            $outPlan[] = [
                'id'             => $r['id'],
                'date'           => date('d-m-Y', strtotime($r['date'])),
                'type'           => $r['type'],
                'title'          => $r['title'],
                'content'        => $r['content'],
                'description'    => $r['description'],
                'designer_brief' => $r['designer_brief'],
                'caption'        => $r['caption'],
                'status'         => intval($r['status']),
            ];
        }
    } catch (\Throwable $e) {
        // On save error, still return AI reply + existing plan
        return $this->response->setJSON([
            'ai_reply'      => $data['ai_reply'] ?? '✅ Here is your current calendar plan.',
            'calendar_plan' => $existingPlan,
        ]);
    }

    // 10) Return enriched plan
    return $this->response->setJSON([
        'ai_reply'      => $data['ai_reply'],
        'calendar_plan' => $outPlan,
    ]);
}




public function ai_planner()
{
    if (!session()->get('logged_in')) {
        return redirect()->to('/login');
    }

    $db      = \Config\Database::connect();
    $userId  = session()->get('user_id');
    $builder = $db->table('company_profiles');
    $planner = $db->table('planner');

    // Fetch all companies for this user
    $companies = $builder
        ->where('uid', $userId)
        ->get()
        ->getResultArray();

    // Extract company IDs
    $companyIds = array_column($companies, 'id');

    // Fetch planners only if there are company IDs
    $planners = [];
    if (!empty($companyIds)) {
        $planners = $planner
            ->whereIn('cid', $companyIds)
            ->get()
            ->getResultArray();
    }

    return view('ai_planner', [
        'accounts' => $companies,
        'planners' => $planners,
    ]);
}


public function image_generation()
{
    if (! session()->get('logged_in')) {
        return redirect()->to('/login');
    }

    $db     = \Config\Database::connect();
    $userId = session()->get('user_id');

    // Get selected month (from GET param) or default to current
    $selectedMonth = $this->request->getGet('month') ?? date('Y-m');
    [$year, $month] = explode('-', $selectedMonth);
    $startOfMonth = "$year-$month-01";
    $endOfMonth   = date("Y-m-t", strtotime($startOfMonth));

    // Fetch calendar plans in the selected month
    $calendar_plans = $db->table('calendar_plans AS cp')
        ->select('cp.*, c.name AS company_name')
        ->join('company_profiles AS c', 'c.id = cp.company_id')
        ->where('cp.user_id', $userId)
        ->where('cp.status', '1')
        ->where('cp.date >=', $startOfMonth)
        ->where('cp.date <=', $endOfMonth)
        ->orderBy('cp.date', 'ASC')
        ->get()
        ->getResultArray();

    return view('image_generation', [
        'calendar_plans' => $calendar_plans,
        'selectedMonth' => $selectedMonth,
    ]);
}












    public function saveChatMessage()
    {
        $json = $this->request->getJSON(true);
        $db   = \Config\Database::connect();

        $db->table('image_messages')->insert([
            'user_id'    => session()->get('user_id'),
            'post_id'    => $json['plan_id'],
            'role'       => $json['role'],       // should be 'user'
            'message'    => $json['message'],
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);

        return $this->response->setJSON(['success' => true]);
    }

    public function generateCalendarImage()
    {
        $db     = \Config\Database::connect();
        $userId = session()->get('user_id');
        if (! $userId) {
            return $this->response->setJSON(['error' => '❗️ You must be logged in.']);
        }

        $planId  = $this->request->getPost('plan_id');
        $message = trim($this->request->getPost('message'));

        // 1) Fetch & validate plan
        $plan = $db->table('calendar_plans')
                   ->where('id', $planId)
                   ->where('user_id', $userId)
                   ->get()
                   ->getRowArray();
        if (! $plan) {
            return $this->response->setJSON(['error' => '❗️ Plan not found.']);
        }

        // 2) Build DALL·E prompt using both designer_brief and content for a promotional Instagram post
        $designerBrief = trim($plan['designer_brief'] ?? '');
        $contentText   = trim($plan['content']      ?? '');

        // Ensure the exact content text appears on the graphic
        $textOverlayInstruction = $contentText
            ? "Please prominently display this text exactly as written in the image: \"{$contentText}\"."
            : "";

        // Style guidelines inspired by your references
        $styleNotes = "
• Clean, modern promotional layout with bold typography and minimalistic design.
• Focus on the core message and product with no extra space around the image.
• Use 2-3 color palette for a vibrant yet professional look.
• Include key information such as the event name, date, and location in a clear, concise format.
• No Instagram layout or borders, only the content, clean and focused.
";

        $dallePrompt = trim(implode(' ', array_filter([
            $designerBrief,
            'Create a high-quality promotional Instagram post graphic.',
            $styleNotes,
            $textOverlayInstruction,
            $message ? "Additional instructions: {$message}." : ''
        ])));

        try {
            // 3) Generate image via DALL·E
            $remoteUrl = $this->callDalleAPI($dallePrompt);
            if (! $remoteUrl) {
                throw new \Exception('No image returned');
            }

            // 4) Download remote image and save locally
            $imageData = file_get_contents($remoteUrl);
            if (! $imageData) {
                throw new \Exception('Failed to download image');
            }

            // Ensure uploads dir exists
            $uploadDir = FCPATH . 'uploads/images/';
            if (! is_dir($uploadDir)) {
                mkdir($uploadDir, 0755, true);
            }

            // Generate unique local filename
            $ext        = pathinfo(parse_url($remoteUrl, PHP_URL_PATH), PATHINFO_EXTENSION) ?: 'png';
            $imageName  = "plan_{$planId}_" . time() . ".{$ext}";
            $localPath  = $uploadDir . $imageName;

            // Save file
            file_put_contents($localPath, $imageData);

            // 5) Persist to generated_images and update calendar_plans.image
            $localUrl = base_url("uploads/images/{$imageName}");
            $db->table('generated_images')->insert([
                'plan_id'    => $planId,
                'image'      => $imageName,
                'created_at' => date('Y-m-d H:i:s'),
            ]);
            // $db->table('calendar_plans')
            //   ->where('id', $planId)
            //   ->update(['image' => $imageName]);

            // 6) Determine create vs modify
            $count  = $db->table('generated_images')
                         ->where('plan_id', $planId)
                         ->countAllResults();
            $action = $count > 1 ? 'modified' : 'created';

            // 7) Generate AI reply
            $apiKey       = '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';
            $systemPrompt = "You are a concise AI assistant. When given a design prompt, respond naturally with a single sentence stating what action you took. Use the actual prompt text in your response.";
            $messages     = [
                ['role' => 'system', 'content' => $systemPrompt],
                ['role' => 'user',   'content' => "Prompt: \"{$dallePrompt}\""]
            ];
            $aiReply      = $this->callChatGPT($apiKey, $messages);

            // 8) Log AI reply
            $db->table('image_messages')->insert([
                'user_id'    => $userId,
                'post_id'    => $planId,
                'role'       => 'ai',
                'message'    => $aiReply,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ]);

            // 9) Return JSON
            return $this->response->setJSON([
                'success'   => true,
                'image_url' => $localUrl,
                'ai_reply'  => $aiReply,
            ]);

        } catch (\Throwable $e) {
            return $this->response->setJSON([
                'error' => '❗️ AI generation failed: ' . $e->getMessage()
            ]);
        }
    }
 

    private function callDalleAPI(string $prompt): string
{
    $apiKey = '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'; // Make sure to store your API key securely in .env
    $client = \Config\Services::curlrequest();

    try {
        $response = $client->post('https://api.openai.com/v1/images/generations', [
            'headers' => [
                'Authorization' => 'Bearer ' . $apiKey,
                'Content-Type'  => 'application/json'
            ],
            'json' => [
                'model'   => 'dall-e-3',            // The current model for image generation
                'prompt'  => $prompt,              // Your design concept
                'n'       => 1,                    // One image per call
                'size'    => '1024x1024',          // Square image for Instagram
                // 'style'   => 'vivid',              // Makes colors pop — great for social media
                'quality' => 'hd'                  // High-definition for professional appearance
            ]
        ]);

        $body = json_decode($response->getBody(), true);
        return $body['data'][0]['url'] ?? '';

    } catch (\Exception $e) {
        log_message('error', 'OpenAI API Error: ' . $e->getMessage());
        return '';
    }
}


    public function update_plan_image()
    {
        $json = $this->request->getJSON(true);
        $db   = \Config\Database::connect();
        $db->table('calendar_plans')
           ->where('id', $json['plan_id'])
           ->update(['image'=>basename(parse_url($json['image_url'], PHP_URL_PATH))]);
        return $this->response->setJSON(['success'=>true]);
    }






public function profile()
{
    if (!session()->get('logged_in')) {
        return redirect()->to('/login');
    }

    $db = \Config\Database::connect();

    // Get the user ID from session
    $userId = session()->get('user_id');

    // Fetch user data
    $builder = $db->table('codeigniter_register');
    $user = $builder->where('id', $userId)->get()->getRow();

    // Pass to view
    $data = [
        'user' => $user
    ];

    return view('profile', $data);
}

public function accounts()
{
    if (! session()->get('logged_in')) {
        return redirect()->to('/login');
    }

    $db      = \Config\Database::connect();
    $userId  = session()->get('user_id');
    $builder = $db->table('company_profiles');

    // Fetch all companies for this user as an array
    $companies = $builder
        ->where('uid', $userId)
        ->get()
        ->getResultArray();  // <— returns an array of associative arrays

    return view('accounts', [
        'accounts' => $companies
    ]);
}


public function updateProfile()
{
    if (!session()->get('logged_in')) {
        return redirect()->to('/login');
    }

    $db = \Config\Database::connect();
    $userId = session()->get('user_id');

    // Get all posted data
    $postData = $this->request->getPost();

    // Update directly
    $builder = $db->table('codeigniter_register');
    $builder->where('id', $userId)->update($postData);

    return redirect()->to('/profile')->with('success', 'Profile updated successfully!');
}

public function updatePassword()
{
    if (!session()->get('logged_in')) {
        return redirect()->to('/login');
    }

    $db = \Config\Database::connect();
    $userId = session()->get('user_id');

    $currentPassword = $this->request->getPost('current_password');
    $newPassword = $this->request->getPost('new_password');
    $confirmPassword = $this->request->getPost('confirm_password');

    // Fetch the existing password
    $builder = $db->table('codeigniter_register');
    $user = $builder->where('id', $userId)->get()->getRow();

    if (!$user) {
        return redirect()->to('/profile')->with('error', 'User not found.');
    }

    if (md5($currentPassword) !== $user->password) {
        return redirect()->to('/profile')->with('error', 'Current password is incorrect.');
    }

    if ($newPassword !== $confirmPassword) {
        return redirect()->to('/profile')->with('error', 'New password and confirmation do not match.');
    }

    // Update the password
    $builder->where('id', $userId)->update([
        'password' => md5($newPassword)
    ]);

    return redirect()->to('/profile')->with('success', 'Password updated successfully.');
}

public function uploadImageAjax()
{
    if (!session()->get('logged_in')) {
        return $this->response->setJSON(['status' => 'error', 'message' => 'Unauthorized']);
    }

    $userId = session()->get('user_id');
    $imageFile = $this->request->getFile('pimage');

    if (!$imageFile || !$imageFile->isValid()) {
        return $this->response->setJSON(['status' => 'error', 'message' => 'Invalid file']);
    }

    // Upload to public/uploads/users/
    $uploadPath = FCPATH . 'uploads/users/';

    // Create the folder if it doesn't exist
    if (!is_dir($uploadPath)) {
        mkdir($uploadPath, 0755, true);
    }

    $newName = $imageFile->getRandomName();

    // Move the file
    if (!$imageFile->move($uploadPath, $newName)) {
        return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to move uploaded file']);
    }

    // Save relative file path for public access
    $db = \Config\Database::connect();
    $builder = $db->table('codeigniter_register');
    $builder->where('id', $userId)->update([
        'pimage' => 'uploads/users/' . $newName
    ]);

    return $this->response->setJSON(['status' => 'success', 'message' => 'Image uploaded']);
}

    public function updatecompany()
    {
        // 1) connect to the DB and get the builder
        $db      = \Config\Database::connect();
        $builder = $db->table('company_profiles');

        // 2) grab all POST data
        $data = $this->request->getPost();

        // 3) handle 'goals' checkbox array => JSON
        if (isset($data['goals']) && is_array($data['goals'])) {
            $data['goals'] = implode(',', $data['goals']);
        }

        // 4) handle logo upload into public/uploads/logos
        $logo = $this->request->getFile('logo');
        if ($logo && $logo->isValid() && ! $logo->hasMoved()) {
            // ensure folder exists: /public/uploads/logos
            $newName = $logo->getRandomName();
            $logo->move(FCPATH . 'uploads/logos', $newName);
            $data['logo'] = 'uploads/logos/' . $newName;
        }

        $data['uid'] = session()->get('user_id');

        // 6) insert vs update
        if (! empty($data['id'])) {
            // update existing
            $builder->where('id', $data['id'])
                    ->update($data);
            session()->setFlashdata('success', 'Company updated.');
        } else {
            // insert new
            unset($data['id']);  // just in case
            $builder->insert($data);
            session()->setFlashdata('success', 'Company added.');
        }

        return redirect()->back();
    }
    
    
    
    
    public function scheduleSocialPost()
{
    helper(['form','url']);

    $planId = (int)$this->request->getPost('plan_id');
    
    if (! $planId) {
        return $this->response
                    ->setJSON(['success' => false, 'error' => 'Plan ID is required'])
                    ->setStatusCode(400);
    }

    $db      = \Config\Database::connect();
    $builder = $db->table('calendar_plans');

    // ensure plan exists
    $plan = $builder->where('id', $planId)->get()->getRowArray();
    if (! $plan) {
        return $this->response
                    ->setJSON(['success' => false, 'error' => 'Plan not found'])
                    ->setStatusCode(404);
    }

    // simply use now() for scheduled_at
    $now = $this->request->getPost('scheduled_at');
    $scheduledAt = $plan['date'] . ' ' . $now;

    $updated = $builder
        ->where('id', $planId)
        ->update([
            'scheduled_at' => $scheduledAt,
            'plan_status'    => 'Scheduled',
        ]);

    if ($updated) {
        return $this->response->setJSON([
            'success'        => true,
            'message'        => '',
            'scheduled_at' => $now
        ]);
    } else {
        return $this->response
                    ->setJSON(['success' => false, 'error' => 'Failed to update database'])
                    ->setStatusCode(500);
    }
}
// public function scheduleSocialPost()
// {
//     helper(['form','url']);

//     // --- Your App credentials ---
//     $appId     = '654667127337480';
//     $appSecret = '7f35ef02dc0c5537a2669c19da448d98';

//     // 1) Get inputs
//     $planId = (int)$this->request->getPost('plan_id');
//     if (! $planId) {
//         return $this->response->setJSON(['success' => false, 'error' => 'Plan ID is required'])->setStatusCode(400);
//     }

//     $db = \Config\Database::connect();

//     // 2) Get calendar plan
//     $plan = $db->table('calendar_plans')->where('id', $planId)->get()->getRowArray();
//     if (! $plan) {
//         return $this->response->setJSON(['success' => false, 'error' => 'Plan not found'])->setStatusCode(404);
//     }

//     // 3) Get company profile
//     $company = $db->table('company_profiles')->where('id', $plan['company_id'])->get()->getRowArray();
//     if (! $company) {
//         return $this->response->setJSON(['success' => false, 'error' => 'Company not found'])->setStatusCode(404);
//     }

//     $doInstagram = $company['instagram_enabled'] == '1';
//     $doFacebook  = $company['facebook_enabled'] == '1';

//     // Tokens / IDs
//     $igUserId      = $company['instagram_link'];
//     $igAccessToken = $company['instagram_api'];
//     // $fbPageId      = $company['facebook_page_id'];
//     // $fbAccessToken = $company['facebook_access_token'];

//     // 4) Prepare post details
//     $imageName     = $plan['image'];
//     $relativePath  = 'uploads/posts/' . $imageName;
//     $imageUrl      = base_url($relativePath);
//     $caption       = $plan['caption'];
//     $scheduledDate = $plan['date'] . ' 09:00:00';
//     $timestamp     = strtotime($scheduledDate);
//     if (! $timestamp) {
//         return $this->response->setJSON(['success' => false, 'error' => 'Invalid date'])->setStatusCode(400);
//     }

//     $client = \Config\Services::curlrequest();

//     // 5) Exchange Instagram token if needed
//     if ($doInstagram && $igAccessToken) {
//         try {
//             $tokenExchangeUrl = "https://graph.facebook.com/v18.0/oauth/access_token?" . http_build_query([
//                 'grant_type'        => 'fb_exchange_token',
//                 'client_id'         => $appId,
//                 'client_secret'     => $appSecret,
//                 'fb_exchange_token' => $igAccessToken,
//             ]);
//             $res = $client->get($tokenExchangeUrl);
//             $body = json_decode($res->getBody(), true);
//             if (!empty($body['access_token'])) {
//                 $igAccessToken = $body['access_token'];
//                 $db->table('company_profiles')->where('id', $company['id'])->update(['instagram_api' => $igAccessToken]);
//             }
//         } catch (\Exception $e) {
//             return $this->response->setJSON(['success' => false, 'error' => 'IG token exchange failed: ' . $e->getMessage()]);
//         }
//     }

//     // 6) Instagram scheduling
//     $instagramId = null;
//     if ($doInstagram && $igUserId && $igAccessToken) {
//         try {
//             // Step 1: Create container
//             $res = $client->post("https://graph.facebook.com/v18.0/{$igUserId}/media", [
//                 'form_params' => [
//                     'image_url'              => $imageUrl,
//                     'caption'                => $caption,
//                     'published'              => false,
//                     'scheduled_publish_time' => $timestamp,
//                     'access_token'           => $igAccessToken
//                 ]
//             ]);
//             $body = json_decode($res->getBody(), true);
//             if (!empty($body['id'])) {
//                 $instagramId = $body['id'];
//                 // Step 2: Publish
//                 $client->post("https://graph.facebook.com/v18.0/{$igUserId}/media_publish", [
//                     'form_params' => [
//                         'creation_id'  => $instagramId,
//                         'access_token' => $igAccessToken
//                     ]
//                 ]);
//             }
//         } catch (\Exception $e) {
//             return $this->response->setJSON(['success' => false, 'error' => 'Instagram error: ' . $e->getMessage()]);
//         }
//     }

//     // 7) Facebook scheduling (optional)
//     /*
//     $facebookId = null;
//     if ($doFacebook && $fbPageId && $fbAccessToken) {
//         try {
//             $res = $client->post("https://graph.facebook.com/v18.0/{$fbPageId}/photos", [
//                 'form_params' => [
//                     'url'                     => $imageUrl,
//                     'caption'                 => $caption,
//                     'published'               => false,
//                     'scheduled_publish_time'  => $timestamp,
//                     'access_token'            => $fbAccessToken
//                 ]
//             ]);
//             $body = json_decode($res->getBody(), true);
//             if (!empty($body['id'])) {
//                 $facebookId = $body['id'];
//             }
//         } catch (\Exception $e) {
//             // return $this->response->setJSON(['success' => false, 'error' => 'Facebook error: ' . $e->getMessage()]);
//         }
//     }
//     */

//     // 8) Return response
//     return $this->response->setJSON([
//         'success'      => true,
//         'message'      => 'Post scheduled successfully.',
//         'instagram_id' => $instagramId,
//         // 'facebook_id'  => $facebookId,
//     ]);
// }

    
public function postToSocialNow()
{
    $db     = \Config\Database::connect();
    $planId = (int)$this->request->getPost('plan_id');
    if (! $planId) {
        return $this->response
            ->setJSON(['success' => false, 'error' => 'Plan ID is required'])
            ->setStatusCode(400);
    }

    // Fetch plan
    $plan = $db->table('calendar_plans')
               ->where('id', $planId)
               ->get()
               ->getRowArray();
    if (! $plan) {
        return $this->response
            ->setJSON(['success' => false, 'error' => 'Plan not found'])
            ->setStatusCode(404);
    }

    // Fetch company
    $company = $db->table('company_profiles')
                  ->where('id', $plan['company_id'])
                  ->get()
                  ->getRowArray();
    if (! $company) {
        return $this->response
            ->setJSON(['success' => false, 'error' => 'Company not found'])
            ->setStatusCode(404);
    }

    // Determine enabled platforms
    $igEnabled = ! empty($company['instagram_enabled']);
    $fbEnabled = ! empty($company['facebook_enabled']);
    if (! $igEnabled && ! $fbEnabled) {
        return $this->response
            ->setJSON(['success' => false, 'error' => 'Neither Instagram nor Facebook is enabled'])
            ->setStatusCode(400);
    }

    // Refresh user token
    $refreshUrl  = "https://graph.facebook.com/v19.0/oauth/access_token?" .
        http_build_query([
            'grant_type'        => 'fb_exchange_token',
            'client_id'         => $company['meta_id'],
            'client_secret'     => $company['meta_key'],
            'fb_exchange_token' => $company['meta_token'],
        ]);
    $refreshData = json_decode(file_get_contents($refreshUrl), true);
    if (empty($refreshData['access_token'])) {
        return $this->response
            ->setJSON([
                'success' => false,
                'error'   => 'Token refresh failed',
                'details' => $refreshData
            ])
            ->setStatusCode(500);
    }
    $accessToken = $refreshData['access_token'];

    $results = [];

    // Instagram flow
    if ($igEnabled) {
        // 1) Create media container
        $ch = curl_init("https://graph.facebook.com/v19.0/{$company['instagram_id']}/media");
        curl_setopt_array($ch, [
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => http_build_query([
                'image_url'    => base_url('uploads/images/' . $plan['image']),
                'caption'      => $plan['caption'],
                'access_token' => $accessToken,
            ]),
            CURLOPT_RETURNTRANSFER => true,
        ]);
        $mediaData = json_decode(curl_exec($ch), true);
        curl_close($ch);

        if (empty($mediaData['id'])) {
            return $this->response
                ->setJSON([
                    'success' => false,
                    'error'   => 'Instagram media creation failed',
                    'details' => $mediaData
                ])
                ->setStatusCode(500);
        }

        sleep(5); // allow media processing

        // 2) Publish media
        $ch = curl_init("https://graph.facebook.com/v19.0/{$company['instagram_id']}/media_publish");
        curl_setopt_array($ch, [
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => http_build_query([
                'creation_id'  => $mediaData['id'],
                'access_token' => $accessToken,
            ]),
            CURLOPT_RETURNTRANSFER => true,
        ]);
        $publishData = json_decode(curl_exec($ch), true);
        curl_close($ch);

        if (empty($publishData['id'])) {
            return $this->response
                ->setJSON([
                    'success' => false,
                    'error'   => 'Instagram publish failed',
                    'details' => $publishData
                ])
                ->setStatusCode(500);
        }

        $results['instagram_post_id'] = $publishData['id'];
    }

    // Facebook flow
    if ($fbEnabled) {
        // 1) Get Page access token
        $pages     = json_decode(
            file_get_contents("https://graph.facebook.com/v19.0/me/accounts?access_token={$accessToken}"),
            true
        );
        $pageToken = null;
        foreach ($pages['data'] ?? [] as $p) {
            if ($p['id'] == $company['facebook_id']) {
                $pageToken = $p['access_token'];
                break;
            }
        }
        if (! $pageToken) {
            return $this->response
                ->setJSON([
                    'success' => false,
                    'error'   => 'Facebook page token not found',
                    'details' => $pages
                ])
                ->setStatusCode(500);
        }

        // 2) Post photo to Page
        $ch = curl_init("https://graph.facebook.com/v19.0/{$company['facebook_id']}/photos");
        curl_setopt_array($ch, [
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => http_build_query([
                'url'          => base_url('uploads/images/' . $plan['image']),
                'caption'      => $plan['caption'],
                'access_token' => $pageToken,
            ]),
            CURLOPT_RETURNTRANSFER => true,
        ]);
        $fbPost = json_decode(curl_exec($ch), true);
        curl_close($ch);

        // Accept either 'post_id' or 'id' from Graph API
        $fbPostKey = $fbPost['post_id'] ?? $fbPost['id'] ?? null;
        if (! $fbPostKey) {
            return $this->response
                ->setJSON([
                    'success' => false,
                    'error'   => 'Facebook post failed',
                    'details' => $fbPost
                ])
                ->setStatusCode(500);
        }

        $results['facebook_post_id'] = $fbPostKey;
    }

    // Update plan status
    $db->table('calendar_plans')
       ->where('id', $planId)
       ->update(['plan_status' => 'Posted']);

    // Success response
    return $this->response
        ->setJSON([
            'success' => true,
            'post_id' => $results,
            'scheduled_at' => date('H:i'),
            'message' => 'Posted successfully',
        ]);
}

    
    
    
    
    

public function generateStrategy()
{
    helper('text');

    // Connect to DB & get request data
    $db       = \Config\Database::connect();
    $request  = service('request');
    $data     = $request->getJSON(true);
    $cid      = isset($data['cid']) ? (int) $data['cid'] : 0;

    if (!$cid) {
        return $this->response
                    ->setJSON(['error' => 'Invalid company ID'])
                    ->setStatusCode(400);
    }

    // Fetch company details
    $company = $db->table('company_profiles')
                  ->where('id', $cid)
                  ->get()
                  ->getRowArray();

    if (!$company) {
        return $this->response
                    ->setJSON(['error' => 'Company not found'])
                    ->setStatusCode(404);
    }

    // ✅ GPT prompt
    $messages = [
        [
            'role'    => 'system',
            'content' => <<<'PROMPT'
You are a world-class marketing strategist with 15+ years of experience helping businesses grow using digital, local, and psychological marketing techniques. Prepare a personalized marketing strategy divided into 5 core sections, each with 2–3 relevant subsections.

Inputs provided: business name, niche, location, target audience, goals, emotional vision and values.

Structure:
1. Online Reach Strategy
   - Content & Design Approach
   - Influencer or Community Marketing
2. Footfall / Lead Generation Strategy
   - In-Store Engagement Tactics
   - Local Audience Targeting
3. Meta & Google Ads Strategy
   - Campaign Structure & Creative Angles
   - Targeting & Retargeting Plan
4. SEO Strategy (On-site & Off-site)
   - Content Opportunities & Keywords
   - Local & Niche SEO Enhancements
5. Website & Chatbot Strategy
   - Site Experience & Layout Suggestions
   - Chatbot Role & Automations

For each subsection, include detailed bullet points with:
- What to do
- Why it helps
- Examples (e.g., color palette, hook line, influencer idea)

Important:
- Tailor to the business's niche, tone, and values.
- Avoid generic advice; specify exactly what to do and why.
- Reflect the brand's emotional tone (e.g., fun, warm, luxury).

End with: "This strategy is more than a plan — it’s a step closer to your dream. Let’s make it real."

Output Requirements:
- Return only HTML (no markdown).
- Use <h4> for main sections, <h5> for subsections, <p> for paragraphs, <b> for inline labels, and <br> for spacing.
- Do not include any other HTML tags or wrapper elements.

PROMPT

        ],
        [
            'role'    => 'user',
            'content' => "
Business Name: {$company['name']}
Business Niche: {$company['industry']}
Target Audience: {$company['audience']}
Location: {$company['location']}
Tagline / Brand Message: {$company['tagline']}
Main Business Goal: {$company['goals']}

What’s your dream for your business in the next year or two?
{$company['vision']}

If someone visits your store or page, what’s the feeling you want them to have?
{$company['experience']}

What makes your business or brand special in your eyes?
{$company['uniqueness']}

Which platforms or ways do you enjoy reaching people the most?
{$company['platforms']}
"
        ]
    ];

    // 🔑 API key (use securely in prod)
    $apiKey   = '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';
    $response = $this->callChatGPT($apiKey, $messages);

    // Insert or update in planner table
    $planner = $db->table('planner');
    $exists  = $planner->where('cid', $cid)->get()->getRowArray();
    if ($exists) {
        $planner->where('cid', $cid)
                ->update(['statigies' => $response]);
    } else {
        $planner->insert(['cid' => $cid, 'statigies' => $response]);
    }

    return $this->response->setJSON(['generated' => $response]);
}

public function generatereview()
{
    helper('text');

    $db      = \Config\Database::connect();
    $request = service('request');
    $data    = $request->getJSON(true);
    $cid     = isset($data['cid']) ? (int) $data['cid'] : 0;

    if (!$cid) {
        return $this->response
                    ->setJSON(['error' => 'Invalid company ID'])
                    ->setStatusCode(400);
    }

    // Fetch company details
    $company = $db->table('company_profiles')
                  ->where('id', $cid)
                  ->get()
                  ->getRowArray();

    if (!$company) {
        return $this->response
                    ->setJSON(['error' => 'Company not found'])
                    ->setStatusCode(404);
    }

    // ✅ GPT prompt
    $messages = [
        [
            'role'    => 'system',
            'content' => "You are acting as a Senior AI Brand Strategist specializing in online presence audits.  
Your primary mission is to deliver a *detailed, highly personalized review* of a brand’s current online presence, before preparing any content calendar or marketing strategy.

Why this is important:  
A brand's online presence is its first handshake with the audience.  
If a brand’s website, social media, or listings are incomplete, outdated, irrelevant, or poorly presented, it reduces trust, engagement, and sales opportunities — no matter how good the later content is.  
A proper review ensures that all the foundation is strong before building any campaigns.

How to start the review:  
- Start positively — highlight everything the brand is currently doing well (no matter how small).  
- Appreciate good efforts to build trust and show that you are looking from a constructive point of view.

How to structure the detailed review:  
1. Checklist of Online Presence (Ideal Standards):  
   - Active and updated Website
   - Mobile-friendly website design
   - Fast website loading speed
   - SEO-optimized website (titles, descriptions, keywords)
   - Clear Call-to-Actions (CTAs) on website
   - Active Google Business Profile (if applicable)
   - Presence on relevant social media platforms (Instagram, Facebook, LinkedIn, etc.)
   - Consistent branding across all platforms (logo, colors, tone)
   - Regular posting activity (frequency)
   - Post content quality (design, messaging, creativity)
   - Use of reels, stories, carousels where applicable
   - Engagement rate (likes, comments, shares relative to followers)
   - Audience relevance and targeting
   - Reviews and ratings (Google, Facebook, Yelp, Zomato, etc.)
   - Response to reviews and comments (engagement with users)
   - Local SEO optimization if a physical location exists
   - Presence on any industry-specific platforms (Tripadvisor for hotels/restaurants, Houzz for interiors, etc.)
   - Presence of Highlights (for Instagram) and well-designed Cover Images
   - Updated bio/about sections (with location, contact details, brand tone)
   - Strategic use of hashtags
   - Paid advertising (Google Ads, Meta Ads, if any)

2. Personalized Insights Based on Niche and Location:  
   - Compare their efforts with trends and best practices in their specific industry (e.g., a restaurant’s Instagram should focus heavily on reels of dishes and customer experience).
   - Factor in regional behavior (e.g., high WhatsApp usage in India, Yelp importance in the U.S., Instagram food trends globally).
   - Check if the brand is missing any platform or style that's booming in their category.
   - Notice if their messaging suits the local audience tone and cultural sensitivities.

3. Highlight Positives First:  
   - Summarize all strong points.
   - Appreciate their branding consistency, engagement, responsiveness, quality design, creative efforts, local optimization, etc.

4. Then List Improvement Areas (Cons):  
   - Explain missing elements clearly but respectfully.
   - Show what risks they are facing because of missing parts (e.g., low trust, missing customers, low SEO rank).
   - Suggest why fixing these areas will *unlock more growth and success*.

5. Overall Recommendations:
   - End with a motivating note that after fixing/improving these areas, the brand’s growth will be much stronger.
   - Mention that the upcoming strategy (calendar plan, campaigns) will be *even more effective* once the foundation is optimized.

Tone:  
- Professional but friendly and encouraging.
- Never sound judgmental.
- Show that your role is to make them better and help them win.
Convert the following content into clean HTML using only the following tags:

<h4 class='mt-3'> for main sections,  
<h5 class='mt-2'> for subsections,  
<p> for paragraph text,  
<b> to bold inline phrases or section labels,  
<b> instead of **,  
<br> for light spacing between sections.

Do not include <html>, <head>, or <body> tags.  
Keep the formatting readable and styled like a professional web marketing document.

Ensure each section has appropriate line spacing. Use <b> only for labels within sentences (not entire lines)."
        ],
        [
            'role'    => 'user',
            'content' => "
Business Name: {$company['name']}
Industry: {$company['industry']}
Tagline: {$company['tagline']}
Key Strengths: {$company['uniqueness']}
Main Goals: {$company['goals']}
"
        ]
    ];

    // 🔑 API key
    $apiKey   = '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';
    $response = $this->callChatGPT($apiKey, $messages);

    // Insert or update in planner table
    $planner = $db->table('planner');
    $exists  = $planner->where('cid', $cid)->get()->getRowArray();
    if ($exists) {
        $planner->where('cid', $cid)
                ->update(['reviews' => $response]);
    } else {
        $planner->insert(['cid' => $cid, 'reviews' => $response]);
    }

    return $this->response->setJSON(['generated' => $response]);
}






    private function callChatGPT($apiKey, $messages)
    {
        $client = \Config\Services::curlrequest();

        $response = $client->post('https://api.openai.com/v1/chat/completions', [
            'headers' => [
                'Authorization' => 'Bearer ' . $apiKey,
                'Content-Type' => 'application/json',
            ],
            'json' => [
                'model' => 'gpt-4o-mini',
                'messages' => $messages,
                'temperature' => 0.7,
                'max_tokens' => 800
            ]
        ]);

        $json = json_decode($response->getBody(), true);
        return $json['choices'][0]['message']['content'] ?? 'No response from GPT';
    }


public function mark_read()
{
    $db = \Config\Database::connect();
    $uid = session()->get('user_id');

    $db->table('notifications')
       ->where('uid', $uid)
       ->where('is_read', 0)
       ->where('read_at', null)
       ->update([
           'read_at' => date('Y-m-d H:i:s')
       ]);

    return $this->response->setJSON(['status' => 'ok']);
}

public function remove()
{
    $db = \Config\Database::connect();
    $data = $this->request->getJSON(true);
    $id = $data['id'];
    $uid = session()->get('user_id');

    $db->table('notifications')
       ->where('id', $id)
       ->where('uid', $uid)
       ->update(['is_read' => 1]);

    return $this->response->setJSON(['status' => 'ok']);
}


public function login()
{
    if (session()->get('logged_in')) {
        return redirect()->to('/');
    }

    helper(['form', 'text']);

    if ($this->request->getPost('login')) {
        $email = $this->request->getPost('email');
        $password = $this->request->getPost('password');
        $remember = $this->request->getPost('remember');

        $db = \Config\Database::connect();
        $user = $db->table('codeigniter_register')->where('email', $email)->get()->getRowArray();

        if ($user) {
            if ($user['password'] === md5($password)) {

                // Check if email is verified ✅
                if ($user['is_email_verified'] != 1) {
                    return redirect()->back()->with('error', 'Please verify your email before logging in.');
                }

                // Login success, set session
                session()->set([
                    'user_id'    => $user['id'],
                    'name'       => $user['name'],
                    'user_email' => $user['email'],
                    'user_type'  => 'client',
                    'logged_in'  => true
                ]);

                // ✅ Set Remember Me cookie (7 days)
                if ($remember) {
                    $tokenPayload = $user['email'] . '|' . md5($user['email'] . '|' . $_SERVER['HTTP_USER_AGENT']);
                    setcookie('remember_token', $tokenPayload, time() + (86400 * 7), '/', '', false, true);
                }

                return redirect()->to('/');
            } else {
                return redirect()->back()->with('error', 'Invalid email or password.');
            }
        } else {
            return redirect()->back()->with('error', 'Invalid email or password.');
        }
    }

    return view('login');
}


public function register()
{
    if (session()->get('logged_in')) {
        return redirect()->to('/');
    }

    helper(['form', 'text']);

    if ($this->request->getPost('register')) {
        $name     = $this->request->getPost('name');
        $email    = $this->request->getPost('email');
        $password = $this->request->getPost('password');
        $confirm  = $this->request->getPost('confirm_password');

        if (empty($name) || empty($email) || empty($password) || empty($confirm)) {
            return redirect()->back()->with('error', 'Please fill in all fields.');
        }

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            return redirect()->back()->with('error', 'Invalid email format.');
        }

        if ($password !== $confirm) {
            return redirect()->back()->with('error', 'Passwords do not match.');
        }

        $db = \Config\Database::connect();
        $builder = $db->table('codeigniter_register');

        // Check if email already exists
        $existing = $builder->where('email', $email)->get()->getRow();
        if ($existing) {
            return redirect()->back()->with('error', 'Email already registered.');
        }

        // Generate verification key
        $verification_key = md5(rand().time());

        // Insert new user (set is_email_verified to 0)
        $builder->insert([
            'name'               => $name,
            'email'              => $email,
            'password'           => md5($password), // ⚠️ you can improve security later
            'verification_key'   => $verification_key,
            'is_email_verified'  => 0,
        ]);

        // Send email with verification link
        $this->sendVerificationEmail($email, $verification_key);

        return redirect()->to('home/register_success')->with('success', 'Registration successful! Please check your email to verify your account.');
    }

    return view('register');
}

public function verify($verification_key = null)
{
    if (!$verification_key) {
        return redirect()->to('/login')->with('error', 'Invalid verification link.');
    }

    $db = \Config\Database::connect();
    $builder = $db->table('codeigniter_register');

    $user = $builder->where('verification_key', $verification_key)->get()->getRow();

    if ($user) {
        if ($user->is_email_verified == 1) {
            return redirect()->to('/login')->with('success', 'Email already verified. Please login.');
        }

        $builder->where('id', $user->id)->update(['is_email_verified' => 1]);

        return redirect()->to('/login')->with('success', 'Email verified successfully! Please login.');
    } else {
        return redirect()->to('/login')->with('error', 'Invalid verification link.');
    }
}

private function sendVerificationEmail($email, $verification_key)
{
    $emailService = \Config\Services::email();

    $emailService->setFrom('noreply@yourdomain.com', 'Ai deigital ');
    $emailService->setTo($email);
    $emailService->setSubject('Verify Your Email Address');

    $message = '
    <h2>Email Verification</h2>
    <p>Thank you for registering. Please click below link to verify your email:</p>
    <p><a href="'.base_url('home/verify/'.$verification_key).'">Verify Email</a></p>
    <br><br>
    <p>If you did not request this, please ignore this email.</p>';

    $emailService->setMessage($message);
    $emailService->setMailType('html'); 

    $emailService->send();
}

public function register_success()
{


    return view('register_success', [
        'accounts' => []
    ]);
}


public function logout()
{
    session()->destroy();

    if (isset($_COOKIE['remember_token'])) {
        setcookie('remember_token', '', time() - 3600, '/', '', false, true);
    }

    return redirect()->to('/login');
}
}
