<?php
// /ai-chatbot-starter/api/oauth_callback.php
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/config.php';

session_start();

if (!isset($_GET['code'])) {
  http_response_code(400);
  echo "Missing authorization code.";
  exit;
}

try {
  $client = new Google_Client();
  $client->setApplicationName('Rovix AI');
  $client->setAuthConfig($GOOGLE_OAUTH_CLIENT);
  $client->setScopes(['https://www.googleapis.com/auth/calendar']);
  $client->setAccessType('offline');
  $client->setRedirectUri((isset($_SERVER['HTTPS']) ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/ai-chatbot-starter/api/oauth_callback.php');

  // Exchange code for tokens
  $token = $client->fetchAccessTokenWithAuthCode($_GET['code']);
  if (isset($token['error'])) {
    throw new Exception('Token error: ' . ($token['error_description'] ?? $token['error']));
  }

  // Persist token so server can refresh silently
  file_put_contents($GOOGLE_OAUTH_TOKEN, json_encode($token, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES));
  @chmod($GOOGLE_OAUTH_TOKEN, 0600);

  echo "<h2>Authorization successful ✅</h2><p>You can close this tab.</p>";
} catch (Throwable $e) {
  http_response_code(500);
  echo "Auth failed: " . htmlspecialchars($e->getMessage());
}
