<?php
// Env.php
class Env {
  private static $loaded = false;

  public static function load($path){
    if(self::$loaded) return;
    $envFile = rtrim($path, '/').'/../.env';
    if(!file_exists($envFile)){ return; }

    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach($lines as $line){
      if(strpos(ltrim($line), '#') === 0) continue;
      if(!str_contains($line, '=')) continue;

      list($key, $val) = array_map('trim', explode('=', $line, 2));

      // Corrected line to trim both single and double quotes
      $val = trim($val, '"\'');

      $_ENV[$key] = $val; 
      $_SERVER[$key] = $val; 
      putenv("{$key}={$val}");
    }

    self::$loaded = true;
  }
}
?>
